/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessInstanceVariableTest {
    public static final String PROCESS_ID = "process";
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done();
    private static long processDefinitionKey;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(PROCESS).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    @Test
    public void shouldCreateVariableByProcessInstanceCreation() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").create();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("x")).hasValue("1");
    }

    @Test
    public void shouldCreateVariableByJobCompletion() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("test").withVariables("{'x':1}").complete();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("x")).hasValue("1");
    }

    @Test
    public void shouldCreateVariableByOutputMapping() {
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"shouldCreateVariableByOutputMapping").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).zeebeOutputExpression("x", "y")).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId("shouldCreateVariableByOutputMapping").create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("test").withVariables("{'x':1}").complete();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("y").getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("y")).hasValue("1");
    }

    @Test
    public void shouldCreateVariableByUpdateVariables() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE_RULE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)1)})).update();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("x")).hasValue("1");
    }

    @Test
    public void shouldCreateMultipleVariables() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1, 'y':2}").create();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).hasSize(2)).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"x", "1"}), Assertions.tuple((Object[])new Object[]{"y", "2"})});
    }

    @Test
    public void shouldUpdateVariableByJobCompletion() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("test").withVariables("{'x':2}").complete();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("x")).hasValue("2");
    }

    @Test
    public void shouldUpdateVariableByOutputMapping() {
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"shouldUpdateVariableByOutputMapping").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType("test")).zeebeOutputExpression("x", "y")).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId("shouldUpdateVariableByOutputMapping").withVariables("{'y':1}").create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("test").withVariables("{'x':2}").complete();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("y")).hasValue("2");
    }

    @Test
    public void shouldUpdateVariableByUpdateVariables() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").create();
        ENGINE_RULE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)2)})).update();
        Record variableRecord = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableRecord.getValue())).hasScopeKey(processInstanceKey)).hasProcessDefinitionKey(processDefinitionKey)).hasName("x")).hasValue("2");
    }

    @Test
    public void shouldUpdateMultipleVariables() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1, 'y':2, 'z':3}").create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType("test").withVariables("{'x':1, 'y':4, 'z':5}").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords().withIntent((Intent)VariableIntent.UPDATED)).withProcessInstanceKey(processInstanceKey)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getName(), v.getValue()})).hasSize(2)).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"y", "4"}), Assertions.tuple((Object[])new Object[]{"z", "5"})});
    }

    @Test
    public void shouldCreateAndUpdateVariables() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").create();
        Record variableCreated = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE_RULE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)2), Assertions.entry((Object)"y", (Object)3)})).update();
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().skipUntil(r -> r.getPosition() > variableCreated.getPosition())).limit(2L)).extracting(record -> Assertions.tuple((Object[])new Object[]{record.getIntent(), ((VariableRecordValue)record.getValue()).getProcessDefinitionKey(), ((VariableRecordValue)record.getValue()).getName(), ((VariableRecordValue)record.getValue()).getValue()})).hasSize(2)).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{VariableIntent.UPDATED, processDefinitionKey, "x", "2"}), Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, processDefinitionKey, "y", "3"})});
    }

    @Test
    public void shouldHaveSameKeyOnVariableUpdate() {
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'x':1}").create();
        Record variableCreated = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE_RULE.variables().ofScope(processInstanceKey).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)2)})).update();
        Record variableUpdated = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Assertions.assertThat((long)variableCreated.getKey()).isEqualTo(variableUpdated.getKey());
    }
}

