/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class UpdateVariableDocumentProcessorTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private String jobType;

    @Before
    public void before() {
        this.jobType = Strings.newRandomValidBpmnId();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", b -> b.zeebeJobType(this.jobType)).done();
        ENGINE.deployment().withXmlResource(process).deploy();
    }

    @Test
    public void shouldRejectIfNoScopeFound() {
        long invalidScopeKey = Long.MAX_VALUE;
        Map<String, Object> document = Map.of("foo", "bar", "baz", 1);
        Record<VariableDocumentRecordValue> result = ENGINE.variables().ofScope(Long.MAX_VALUE).withDocument(document).expectRejection().update();
        ((RecordAssert)Assertions.assertThat(result).hasRecordType(RecordType.COMMAND_REJECTION)).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectOnMsgpackReadError() {
        UnsafeBuffer badDocument = new UnsafeBuffer(MsgPackUtil.asMsgPack((String)"{\"a\": 1}"));
        badDocument.putByte(1, (byte)0);
        long processInstanceKey = this.startProcessWithVariables(Map.of());
        Record<VariableDocumentRecordValue> result = ENGINE.variables().ofScope(processInstanceKey).withDocument((DirectBuffer)badDocument).expectRejection().update();
        ((RecordAssert)Assertions.assertThat(result).hasRecordType(RecordType.COMMAND_REJECTION)).hasRejectionType(RejectionType.INVALID_ARGUMENT);
    }

    @Test
    public void shouldPropagateValueFromTaskToProcess() {
        Map<String, Object> document = Map.of("updated", "newValue", "created", 1);
        long processInstanceKey = this.startProcessWithVariables(Map.of("updated", "oldValue"));
        long serviceTaskScopeKey = this.getServiceTaskScopeKey();
        Record<VariableDocumentRecordValue> result = ENGINE.variables().ofScope(serviceTaskScopeKey).withDocument(document).withUpdateSemantic(VariableDocumentUpdateSemantic.PROPAGATE).update();
        Record createdVariable = (Record)((VariableRecordStream)((VariableRecordStream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).skipUntil(r -> r.getPosition() > result.getSourceRecordPosition())).withScopeKey(processInstanceKey).withProcessInstanceKey(processInstanceKey).limit((long)document.size())).findFirst().orElseThrow();
        Record updatedVariable = (Record)((VariableRecordStream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withScopeKey(processInstanceKey).withProcessInstanceKey(processInstanceKey).limit((long)document.size())).findFirst().orElseThrow();
        ((RecordAssert)Assertions.assertThat(result).hasRecordType(RecordType.EVENT)).hasIntent((Intent)VariableDocumentIntent.UPDATED);
        ((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)createdVariable.getValue())).hasName("created")).hasValue("1");
        ((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)updatedVariable.getValue())).hasName("updated")).hasValue("\"newValue\"");
    }

    @Test
    public void shouldNotPropagateValueWithLocalSemantic() {
        Map<String, Object> document = Map.of("updated", "newValue");
        long processInstanceKey = this.startProcessWithVariables(Map.of("updated", "oldValue"));
        long serviceTaskScopeKey = this.getServiceTaskScopeKey();
        Record<VariableDocumentRecordValue> result = ENGINE.variables().ofScope(serviceTaskScopeKey).withDocument(document).withUpdateSemantic(VariableDocumentUpdateSemantic.LOCAL).update();
        Record createdVariable = (Record)((VariableRecordStream)((VariableRecordStream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).skipUntil(r -> r.getPosition() > result.getSourceRecordPosition())).withScopeKey(serviceTaskScopeKey).withProcessInstanceKey(processInstanceKey).limit((long)document.size())).findFirst().orElseThrow();
        ((RecordAssert)Assertions.assertThat(result).hasRecordType(RecordType.EVENT)).hasIntent((Intent)VariableDocumentIntent.UPDATED);
        ((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)createdVariable.getValue())).hasName("updated")).hasValue("\"newValue\"");
    }

    @Test
    public void shouldNotPropagateExistingVariable() {
        Map<String, Object> document = Map.of("updated", "newValue");
        long processInstanceKey = this.startProcessWithVariables(Map.of());
        long serviceTaskScopeKey = this.getServiceTaskScopeKey();
        ENGINE.variables().ofScope(serviceTaskScopeKey).withDocument(Map.of("updated", "oldValue")).withUpdateSemantic(VariableDocumentUpdateSemantic.LOCAL).update();
        Record<VariableDocumentRecordValue> result = ENGINE.variables().ofScope(serviceTaskScopeKey).withDocument(document).withUpdateSemantic(VariableDocumentUpdateSemantic.PROPAGATE).update();
        Record updatedVariable = (Record)((VariableRecordStream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withScopeKey(serviceTaskScopeKey).withProcessInstanceKey(processInstanceKey).limit((long)document.size())).findFirst().orElseThrow();
        ((RecordAssert)Assertions.assertThat(result).hasRecordType(RecordType.EVENT)).hasIntent((Intent)VariableDocumentIntent.UPDATED);
        ((VariableRecordValueAssert)Assertions.assertThat((VariableRecordValue)((VariableRecordValue)updatedVariable.getValue())).hasName("updated")).hasValue("\"newValue\"");
    }

    private long startProcessWithVariables(Map<String, Object> variables) {
        return ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(variables).create();
    }

    private long getServiceTaskScopeKey() {
        Record activatedJobs = (Record)Awaitility.await().until(() -> ENGINE.jobs().withType(this.jobType).activate(), r -> ((JobBatchRecordValue)r.getValue()).getJobs().size() > 0);
        return ((JobRecordValue)((JobBatchRecordValue)activatedJobs.getValue()).getJobs().get(0)).getElementInstanceKey();
    }
}

