/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.EventApplyingStateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedEventWriter;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.RecordingTypedEventWriter;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

final class VariableBehaviorTest {
    private final RecordingTypedEventWriter eventWriter = new RecordingTypedEventWriter();
    private ZeebeDb<ZbColumnFamilies> db;
    private MutableVariableState state;
    private VariableBehavior behavior;

    VariableBehaviorTest() {
    }

    @BeforeEach
    void beforeEach(@TempDir File directory) {
        this.db = DefaultZeebeDbFactory.defaultFactory().createDb(directory);
        ZeebeDbState zeebeState = new ZeebeDbState(this.db, this.db.createContext());
        EventApplyingStateWriter stateWriter = new EventApplyingStateWriter((TypedEventWriter)this.eventWriter, (EventApplier)new EventAppliers((MutableZeebeState)zeebeState));
        this.state = zeebeState.getVariableState();
        this.behavior = new VariableBehavior((VariableState)this.state, (StateWriter)stateWriter, zeebeState.getKeyGenerator());
    }

    @AfterEach
    void afterEach() {
        CloseHelper.close(this.db);
    }

    @Test
    void shouldMergeLocalDocument() {
        long processDefinitionKey = 1L;
        long parentScopeKey = 1L;
        long childScopeKey = 2L;
        long childFooKey = 3L;
        Map<String, String> document = Map.of("foo", "bar", "baz", "buz");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.setVariable(3L, 2L, 1L, "foo", "qux");
        this.behavior.mergeLocalDocument(2L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.CREATED);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("baz")).hasValue("\"buz\"")).hasScopeKey(2L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }, event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.UPDATED);
            Assertions.assertThat((long)event.key).isEqualTo(3L);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("foo")).hasValue("\"bar\"")).hasScopeKey(2L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldNotMergeLocalDocumentIfEmpty() {
        long processDefinitionKey = 1L;
        long scopeKey = 1L;
        Map document = Map.of();
        this.setVariable(2L, 1L, 1L, "foo", "qux");
        this.behavior.mergeLocalDocument(1L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        Assertions.assertThat(this.getFollowUpEvents()).isEmpty();
    }

    @Test
    void shouldMergeDocumentWithoutPropagatingMoreThanOnce() {
        long processDefinitionKey = 1L;
        long rootScopeKey = 1L;
        long parentScopeKey = 2L;
        long childScopeKey = 3L;
        long parentFooKey = 4L;
        Map<String, String> document = Map.of("foo", "bar");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.state.createScope(3L, 2L);
        this.setVariable(4L, 2L, 1L, "foo", "qux");
        this.setVariable(5L, 1L, 1L, "foo", "biz");
        this.behavior.mergeDocument(3L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.UPDATED);
            Assertions.assertThat((long)event.key).isEqualTo(4L);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("foo")).hasValue("\"bar\"")).hasScopeKey(2L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldMergeDocumentPropagatingToRoot() {
        long processDefinitionKey = 1L;
        long rootScopeKey = 1L;
        long parentScopeKey = 2L;
        long childScopeKey = 3L;
        Map<String, String> document = Map.of("foo", "bar", "buz", "baz");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.state.createScope(3L, 2L);
        this.behavior.mergeDocument(3L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.CREATED);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("foo")).hasValue("\"bar\"")).hasScopeKey(1L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }, event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.CREATED);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("buz")).hasValue("\"baz\"")).hasScopeKey(1L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldMergeDocumentWithoutUpdatingUnmodifiedVariable() {
        long processDefinitionKey = 1L;
        long rootScopeKey = 1L;
        long parentScopeKey = 2L;
        long childScopeKey = 3L;
        Map<String, String> document = Map.of("foo", "bar", "buz", "baz");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.state.createScope(3L, 2L);
        this.setVariable(4L, 1L, 1L, "foo", "bar");
        this.behavior.mergeDocument(3L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.CREATED);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("buz")).hasValue("\"baz\"")).hasScopeKey(1L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldMergeDocumentWithoutPropagatingExistingVariables() {
        long processDefinitionKey = 1L;
        long parentScopeKey = 1L;
        long childScopeKey = 2L;
        long childFooKey = 3L;
        Map<String, String> document = Map.of("foo", "bar");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.setVariable(3L, 2L, 1L, "foo", "qux");
        this.setVariable(4L, 1L, 1L, "foo", "biz");
        this.behavior.mergeDocument(2L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.UPDATED);
            Assertions.assertThat((long)event.key).isEqualTo(3L);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("foo")).hasValue("\"bar\"")).hasScopeKey(2L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldNotMergeDocumentIfEmpty() {
        boolean processDefinitionKey = true;
        boolean parentScopeKey = true;
        int childScopeKey = 2;
        Map document = Map.of();
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.setVariable(3L, 1L, 1L, "foo", "qux");
        this.setVariable(4L, 2L, 1L, "foo", "bar");
        this.behavior.mergeDocument(2L, 1L, 1L, MsgPackUtil.asMsgPack(document));
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).isEmpty();
    }

    @Test
    void shouldCreateLocalVariable() {
        boolean processDefinitionKey = true;
        boolean parentScopeKey = true;
        int childScopeKey = 2;
        DirectBuffer variableName = BufferUtil.wrapString((String)"foo");
        DirectBuffer variableValue = this.packString("bar");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.behavior.setLocalVariable(2L, 1L, 1L, variableName, variableValue, 0, variableValue.capacity());
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.CREATED);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("foo")).hasValue("\"bar\"")).hasScopeKey(2L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldUpdateLocalVariable() {
        long processDefinitionKey = 1L;
        long parentScopeKey = 1L;
        long childScopeKey = 2L;
        long parentFooKey = 3L;
        DirectBuffer variableName = BufferUtil.wrapString((String)"foo");
        DirectBuffer variableValue = this.packString("bar");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.setVariable(3L, 1L, 1L, "foo", "qux");
        this.behavior.setLocalVariable(1L, 1L, 1L, variableName, variableValue, 0, variableValue.capacity());
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).satisfiesExactlyInAnyOrder(new Consumer[]{event -> {
            Assertions.assertThat((Object)event.intent).isEqualTo((Object)VariableIntent.UPDATED);
            Assertions.assertThat((long)event.key).isEqualTo(3L);
            ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)VariableRecordValueAssert.assertThat((VariableRecordValue)((VariableRecordValue)event.value)).hasName("foo")).hasValue("\"bar\"")).hasScopeKey(1L)).hasProcessDefinitionKey(1L)).hasProcessInstanceKey(1L);
        }});
    }

    @Test
    void shouldNotUpdateUnmodifiedVariables() {
        long processDefinitionKey = 1L;
        long parentScopeKey = 1L;
        long childScopeKey = 2L;
        long parentFooKey = 3L;
        DirectBuffer variableName = BufferUtil.wrapString((String)"foo");
        DirectBuffer variableValue = this.packString("bar");
        this.state.createScope(1L, -1L);
        this.state.createScope(2L, 1L);
        this.setVariable(3L, 1L, 1L, "foo", "bar");
        this.behavior.setLocalVariable(1L, 1L, 1L, variableName, variableValue, 0, variableValue.capacity());
        List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> events = this.getFollowUpEvents();
        Assertions.assertThat(events).isEmpty();
    }

    private List<RecordingTypedEventWriter.RecordedEvent<VariableRecordValue>> getFollowUpEvents() {
        return this.eventWriter.getEvents().stream().filter(e -> e.value instanceof VariableRecordValue).map(e -> e).collect(Collectors.toList());
    }

    private void setVariable(long key, long scopeKey, long processDefinitionKey, String name, String value) {
        DirectBuffer nameBuffer = BufferUtil.wrapString((String)name);
        this.state.setVariableLocal(key, scopeKey, processDefinitionKey, nameBuffer, this.packString(value));
    }

    private DirectBuffer packString(String value) {
        return MsgPackUtil.encodeMsgPack(b -> b.packString(value));
    }
}

