/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.processing.variable.mapping.VariableValue;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ActivityOutputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String initialVariables;
    @Parameterized.Parameter(value=1)
    public Consumer<SubProcessBuilder> mappings;
    @Parameterized.Parameter(value=2)
    public List<VariableValue> expectedScopeVariables;

    @Parameterized.Parameters(name="from {0} to {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"{'x': 1}", ActivityOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "y")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("y", "1"))}, {"{'x': 1, 'y': 2}", ActivityOutputMappingTest.mapping(b -> b.zeebeOutputExpression("y", "z")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'x': 1}", ActivityOutputMappingTest.mapping(b -> ((SubProcessBuilder)b.zeebeInputExpression("x", "y")).zeebeOutputExpression("y", "z")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "1"))}, {"{'x': 1}", ActivityOutputMappingTest.mapping(b -> ((SubProcessBuilder)b.zeebeInputExpression("x", "y")).zeebeOutputExpression("x", "z")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "1"))}, {"{'x': {'y': 2}}", ActivityOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "z")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"y\":2}"))}, {"{'x': {'y': 2}}", ActivityOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x.y", "z")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'z': {'x': 1}, 'y': 2}", ActivityOutputMappingTest.mapping(b -> b.zeebeOutputExpression("y", "z.y")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"x\":1,\"y\":2}"))}, {"{'x': 1, 'y': 2}", ActivityOutputMappingTest.mapping(b -> ((SubProcessBuilder)b.zeebeOutputExpression("x", "z.x")).zeebeOutputExpression("y", "z.y")), ActivityOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"x\":1,\"y\":2}"))}};
    }

    @Test
    public void shouldApplyOutputMappings() {
        String jobType = UUID.randomUUID().toString();
        ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub", b -> {
            b.embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).endEvent();
            this.mappings.accept((SubProcessBuilder)b);
        }).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(this.initialVariables).create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType(jobType).complete();
        Record taskCompleted = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst();
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > taskCompleted.getPosition())).withScopeKey(processInstanceKey).limit((long)this.expectedScopeVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSize(this.expectedScopeVariables.size())).containsAll(this.expectedScopeVariables);
    }

    private static Consumer<ZeebeVariablesMappingBuilder<SubProcessBuilder>> mapping(Consumer<ZeebeVariablesMappingBuilder<SubProcessBuilder>> mappingBuilder) {
        return mappingBuilder;
    }

    private static List<VariableValue> scopeVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }
}

