/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.processing.variable.mapping.VariableValue;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class MessageOutputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String MESSAGE_NAME = "message";
    private static final String CORRELATION_VARIABLE = "key";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String messageVariables;
    @Parameterized.Parameter(value=1)
    public Consumer<IntermediateCatchEventBuilder> mappings;
    @Parameterized.Parameter(value=2)
    public List<VariableValue> expectedActivityVariables;
    @Parameterized.Parameter(value=3)
    public List<VariableValue> expectedScopeVariables;
    private String correlationKey;

    @Parameterized.Parameters(name="from {0} to activity: {2} and scope: {3}")
    public static Object[][] parameters() {
        return new Object[][]{{"{'x': 1}", MessageOutputMappingTest.mapping(b -> {}), MessageOutputMappingTest.activityVariables(new VariableValue[0]), MessageOutputMappingTest.scopeVariables(VariableValue.variable("x", "1"))}, {"{'x': 1}", MessageOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "x")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "1")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("x", "1"))}, {"{'x': 1}", MessageOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "y")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "1")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("y", "1"))}, {"{'x': 1, 'y': 2}", MessageOutputMappingTest.mapping(b -> b.zeebeOutputExpression("y", "z")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "1"), VariableValue.variable("y", "2")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'x': {'y': 2}}", MessageOutputMappingTest.mapping(b -> {}), MessageOutputMappingTest.activityVariables(new VariableValue[0]), MessageOutputMappingTest.scopeVariables(VariableValue.variable("x", "{\"y\":2}"))}, {"{'x': {'y': 2}}", MessageOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "y")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "{\"y\":2}")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("y", "{\"y\":2}"))}, {"{'x': {'y': 2}}", MessageOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x.y", "y")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "{\"y\":2}")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("y", "2"))}, {"{'x': 1, 'y': 2}", MessageOutputMappingTest.mapping(b -> ((IntermediateCatchEventBuilder)b.zeebeOutputExpression("x", "z.x")).zeebeOutputExpression("y", "z.y")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "1"), VariableValue.variable("y", "2")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"x\":1,\"y\":2}"))}, {"{'i': 1}", MessageOutputMappingTest.mapping(b -> {}), MessageOutputMappingTest.activityVariables(new VariableValue[0]), MessageOutputMappingTest.scopeVariables(VariableValue.variable("i", "1"))}, {"{'x': 1}", MessageOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "i")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "1")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("i", "1"))}, {"{'i': 2, 'x': 1}", MessageOutputMappingTest.mapping(b -> b.zeebeInputExpression("i", "x")), MessageOutputMappingTest.activityVariables(VariableValue.variable("x", "0")), MessageOutputMappingTest.scopeVariables(VariableValue.variable("i", "2"))}};
    }

    @Before
    public void init() {
        this.correlationKey = UUID.randomUUID().toString();
    }

    @Test
    public void shouldApplyOutputMappings() {
        ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent("catch-event", b -> {
            b.message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE));
            this.mappings.accept((IntermediateCatchEventBuilder)b);
        }).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("i", 0);
        variables.put(CORRELATION_VARIABLE, this.correlationKey);
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{'i':0,'key':'" + this.correlationKey + "'}").create();
        ENGINE_RULE.message().withName(MESSAGE_NAME).withCorrelationKey(this.correlationKey).withVariables(MsgPackUtil.asMsgPack((String)this.messageVariables)).publish();
        long elementInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId("catch-event").getFirst()).getKey();
        long latestPayloadVariablePosition = (Long)((VariableRecordStream)((VariableRecordStream)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(r -> variables.containsKey(((VariableRecordValue)r.getValue()).getName()))).limit((long)variables.size())).map(Record::getPosition).max(Comparator.naturalOrder()).orElseThrow();
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > latestPayloadVariablePosition)).withScopeKey(elementInstanceKey).limit((long)this.expectedActivityVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSameSizeAs(this.expectedActivityVariables)).containsAll(this.expectedActivityVariables);
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > latestPayloadVariablePosition)).withScopeKey(processInstanceKey).limit((long)this.expectedScopeVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSameSizeAs(this.expectedScopeVariables)).containsAll(this.expectedScopeVariables);
    }

    private static Consumer<ZeebeVariablesMappingBuilder<IntermediateCatchEventBuilder>> mapping(Consumer<ZeebeVariablesMappingBuilder<IntermediateCatchEventBuilder>> mappingBuilder) {
        return mappingBuilder;
    }

    private static List<VariableValue> activityVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }

    private static List<VariableValue> scopeVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }
}

