/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.VariableMappingTransformer;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeMapping;
import io.camunda.zeebe.test.util.MsgPackUtil;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class VariableMappingTransformerTest {
    private final VariableMappingTransformer transformer = new VariableMappingTransformer();
    private final ExpressionLanguage expressionLanguage = ExpressionLanguageFactory.createExpressionLanguage();

    @Test
    public void shouldCreateValidExpression() {
        Expression expression = this.transformer.transformInputMappings(List.of(VariableMappingTransformerTest.mapping("x", "a")), this.expressionLanguage);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expression.isValid()).describedAs("Expected valid expression: %s", new Object[]{expression.getFailureMessage()})).isTrue();
    }

    @Test
    public void shouldEvaluateToObject() {
        Expression expression = this.transformer.transformInputMappings(List.of(VariableMappingTransformerTest.mapping("x", "a")), this.expressionLanguage);
        EvaluationResult result = this.expressionLanguage.evaluateExpression(expression, name -> MsgPackUtil.asMsgPack((String)"1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isFailure()).describedAs("Expected valid result: %s", new Object[]{expression.getFailureMessage()})).isFalse();
        Assertions.assertThat((Comparable)result.getType()).isEqualTo((Object)ResultType.OBJECT);
    }

    @Test
    public void failToTransformWithInvalidSourceExpression() {
        List<ZeebeMapping> mappings = List.of(VariableMappingTransformerTest.mapping("x?", "a"));
        Assertions.assertThatThrownBy(() -> this.transformer.transformInputMappings((Collection)mappings, this.expressionLanguage)).hasMessageStartingWith("Failed to build variable mapping expression: failed to parse expression '{a:x?}'");
    }

    @Test
    public void failToTransformWithInvalidTargetExpression() {
        List<ZeebeMapping> mappings = List.of(VariableMappingTransformerTest.mapping("x", "a?"));
        Assertions.assertThatThrownBy(() -> this.transformer.transformInputMappings((Collection)mappings, this.expressionLanguage)).hasMessageStartingWith("Failed to build variable mapping expression: failed to parse expression '{a?:x}'");
    }

    @Test
    public void shouldEvaluateWithNotExistingVariable() {
        List<ZeebeMapping> mappings = List.of(VariableMappingTransformerTest.mapping("x", "a"));
        Expression expression = this.transformer.transformInputMappings(mappings, this.expressionLanguage);
        EvaluationResult result = this.expressionLanguage.evaluateExpression(expression, name -> null);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.isFailure()).describedAs("Expected evaluation failure: %s", new Object[]{expression.getFailureMessage()})).isTrue();
        Assertions.assertThat((String)result.getFailureMessage()).isEqualTo("failed to evaluate expression '{a:x}': no variable found for name 'x'");
    }

    private static ZeebeMapping mapping(final String source, final String target) {
        return new ZeebeMapping(){

            public String getSource() {
                return source;
            }

            public String getTarget() {
                return target;
            }

            public String toString() {
                return source + " -> " + target;
            }
        };
    }
}

