/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.VariableMappingTransformer;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeMapping;
import io.camunda.zeebe.test.util.MsgPackUtil;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class VariableOutputMappingTransformerTest {
    @Parameterized.Parameter(value=0)
    public List<ZeebeMapping> mappings;
    @Parameterized.Parameter(value=1)
    public Map<String, DirectBuffer> variables;
    @Parameterized.Parameter(value=2)
    public String expectedOutput;
    private final VariableMappingTransformer transformer = new VariableMappingTransformer();
    private final ExpressionLanguage expressionLanguage = ExpressionLanguageFactory.createExpressionLanguage();

    @Parameterized.Parameters(name="with {0} to {2}")
    public static Object[][] parameters() {
        return new Object[][]{{List.of(), Map.of(), "{}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "x")), Map.of("x", MsgPackUtil.asMsgPack((String)"1")), "{'x':1}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"1")), "{'a':1}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a"), VariableOutputMappingTransformerTest.mapping("y", "b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "y", MsgPackUtil.asMsgPack((String)"2")), "{'a':1, 'b':2}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"{'y':1}")), "{'a':{'y':1}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1")), "{'a':{'b':1}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b"), VariableOutputMappingTransformerTest.mapping("y", "a.c")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "y", MsgPackUtil.asMsgPack((String)"2")), "{'a':{'b':1, 'c':2}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b.c")), Map.of("x", MsgPackUtil.asMsgPack((String)"1")), "{'a':{'b':{'c':1}}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "a", MsgPackUtil.asMsgPack((String)"{}")), "{'a':{'b':1}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x.y", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"{'y':1}")), "{'a':1}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x.y", "a"), VariableOutputMappingTransformerTest.mapping("x.z", "b")), Map.of("x", MsgPackUtil.asMsgPack((String)"{'y':1, 'z':2}")), "{'a':1, 'b':2}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x.y", "a.b"), VariableOutputMappingTransformerTest.mapping("x.z", "a.c")), Map.of("x", MsgPackUtil.asMsgPack((String)"{'y':1, 'z':2}")), "{'a': {'b':1, 'c':2}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "a", MsgPackUtil.asMsgPack((String)"{'b':2}")), "{'a':1}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "a", MsgPackUtil.asMsgPack((String)"{'c':2}")), "{'a':{'b':1,'c':2}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b.c")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "a", MsgPackUtil.asMsgPack((String)"{'b':{'d':2}, 'e':3}")), "{'a':{'b':{'c':1, 'd':2}, 'e':3}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "a", MsgPackUtil.asMsgPack((String)"{'b':2}")), "{'a':{'b':1}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a.b"), VariableOutputMappingTransformerTest.mapping("x", "a.c")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "a", MsgPackUtil.asMsgPack((String)"{'d':2}")), "{'a':{'b':1, 'c':1, 'd':2}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a"), VariableOutputMappingTransformerTest.mapping("a + 1", "b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1")), "{'a':1, 'b':2}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a"), VariableOutputMappingTransformerTest.mapping("y", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "y", MsgPackUtil.asMsgPack((String)"2")), "{'a':2}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x", "a"), VariableOutputMappingTransformerTest.mapping("y", "a.b")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "y", MsgPackUtil.asMsgPack((String)"2")), "{'a':{'b':2}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("1", "a")), Map.of(), "{'a':1}"}, {List.of(VariableOutputMappingTransformerTest.mapping("\"foo\"", "a")), Map.of(), "{'a':'foo'}"}, {List.of(VariableOutputMappingTransformerTest.mapping("[1,2,3]", "a")), Map.of(), "{'a':[1,2,3]}"}, {List.of(VariableOutputMappingTransformerTest.mapping("x + y", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "y", MsgPackUtil.asMsgPack((String)"2")), "{'a':3}"}, {List.of(VariableOutputMappingTransformerTest.mapping("{x:x, y:y}", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"1"), "y", MsgPackUtil.asMsgPack((String)"2")), "{'a':{'x':1, 'y':2}}"}, {List.of(VariableOutputMappingTransformerTest.mapping("append(x, y)", "a")), Map.of("x", MsgPackUtil.asMsgPack((String)"[1,2]"), "y", MsgPackUtil.asMsgPack((String)"3")), "{'a':[1,2,3]}"}};
    }

    @Test
    public void shouldApplyMappings() {
        Expression expression = this.transformer.transformOutputMappings(this.mappings, this.expressionLanguage);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)expression.isValid()).describedAs("Expected valid expression: %s", new Object[]{expression.getFailureMessage()})).isTrue();
        EvaluationResult result = this.expressionLanguage.evaluateExpression(expression, this.variables::get);
        Assertions.assertThat((Comparable)result.getType()).isEqualTo((Object)ResultType.OBJECT);
        MsgPackUtil.assertEquality((DirectBuffer)result.toBuffer(), (String)this.expectedOutput);
    }

    private static ZeebeMapping mapping(final String source, final String target) {
        return new ZeebeMapping(){

            public String getSource() {
                return source;
            }

            public String getTarget() {
                return target;
            }

            public String toString() {
                return source + " -> " + target;
            }
        };
    }
}

