/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.protocol.Protocol;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class KeyGeneratorTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private KeyGenerator keyGenerator;

    @Before
    public void setUp() throws Exception {
        this.keyGenerator = this.stateRule.getZeebeState().getKeyGenerator();
    }

    @Test
    public void shouldGetFirstValue() {
        long firstKey = this.keyGenerator.nextKey();
        Assertions.assertThat((long)firstKey).isEqualTo(Protocol.encodePartitionId((int)1, (long)1L));
    }

    @Test
    public void shouldGetNextValue() {
        long key = this.keyGenerator.nextKey();
        long nextKey = this.keyGenerator.nextKey();
        Assertions.assertThat((long)nextKey).isGreaterThan(key);
    }

    @Test
    public void shouldGetUniqueValuesOverPartitions() throws Exception {
        ZeebeDb<ZbColumnFamilies> newDb = this.stateRule.createNewDb();
        int secondPartitionId = 2;
        ZeebeDbState otherZeebeState = new ZeebeDbState(2, newDb, newDb.createContext());
        KeyGenerator keyGenerator2 = otherZeebeState.getKeyGenerator();
        long keyOfFirstPartition = this.keyGenerator.nextKey();
        long keyOfSecondPartition = keyGenerator2.nextKey();
        Assertions.assertThat((long)keyOfFirstPartition).isNotEqualTo(keyOfSecondPartition);
        Assertions.assertThat((int)Protocol.decodePartitionId((long)keyOfFirstPartition)).isEqualTo(1);
        Assertions.assertThat((int)Protocol.decodePartitionId((long)keyOfSecondPartition)).isEqualTo(2);
        newDb.close();
    }
}

