/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.instance.AwaitProcessInstanceResultMetadata;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class ElementInstanceStateTest {
    private static final long PROCESS_KEY = 123L;
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableElementInstanceState elementInstanceState;
    private MutableZeebeState zeebeState;

    @Before
    public void setUp() {
        this.zeebeState = this.stateRule.getZeebeState();
        this.elementInstanceState = this.zeebeState.getElementInstanceState();
    }

    @Test
    public void shouldCreateNewInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance elementInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        this.assertElementInstance(elementInstance, 0);
    }

    @Test
    public void shouldCreateNewInstanceWithParent() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        ProcessInstanceRecord otherRecord = this.createProcessInstanceRecord();
        otherRecord.setElementId("subProcess");
        ElementInstance childInstance = this.elementInstanceState.newInstance(parentInstance, 101L, otherRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        this.assertElementInstance(parentInstance, 1);
        this.assertChildInstance(childInstance, 101L, "subProcess");
    }

    @Test
    public void shouldFindElementInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        ElementInstance instance = this.elementInstanceState.getInstance(100L);
        this.assertElementInstance(instance, 0);
    }

    @Test
    public void shouldFindChildInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        processInstanceRecord.setElementId("subProcess");
        this.elementInstanceState.newInstance(parentInstance, 101L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        ElementInstance childInstance = this.elementInstanceState.getInstance(101L);
        this.assertChildInstance(childInstance, 101L, "subProcess");
    }

    @Test
    public void shouldFindParentInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        processInstanceRecord.setElementId("subProcess");
        this.elementInstanceState.newInstance(parentInstance, 101L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        ElementInstance updatedParentInstance = this.elementInstanceState.getInstance(100L);
        this.assertElementInstance(updatedParentInstance, 1);
    }

    @Test
    public void shouldRemoveParentInstanceAfterRemovingChild() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        processInstanceRecord.setElementId("subProcess");
        this.elementInstanceState.newInstance(parentInstance, 101L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        this.elementInstanceState.removeInstance(101L);
        this.elementInstanceState.removeInstance(100L);
        ElementInstance childInstance = this.elementInstanceState.getInstance(101L);
        Assertions.assertThat((Object)childInstance).isNull();
        ElementInstance parent = this.elementInstanceState.getInstance(100L);
        Assertions.assertThat((Object)parent).isNull();
        List children = this.elementInstanceState.getChildren(100L);
        Assertions.assertThat((List)children).hasSize(0);
    }

    @Test
    public void shouldRemoveChildInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        processInstanceRecord.setElementId("subProcess");
        this.elementInstanceState.newInstance(parentInstance, 101L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        processInstanceRecord.setElementId("subProcess2");
        this.elementInstanceState.newInstance(parentInstance, 102L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        this.elementInstanceState.removeInstance(101L);
        ElementInstance childInstance = this.elementInstanceState.getInstance(101L);
        Assertions.assertThat((Object)childInstance).isNull();
        List children = this.elementInstanceState.getChildren(100L);
        Assertions.assertThat((List)children).hasSize(1);
        ElementInstance childInstance2 = this.elementInstanceState.getInstance(102L);
        this.assertChildInstance(childInstance2, 102L, "subProcess2");
        ElementInstance updatedParent = this.elementInstanceState.getInstance(100L);
        this.assertElementInstance(updatedParent, 1);
    }

    @Test
    public void shouldUpdateElementInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance instance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        instance.setState(ProcessInstanceIntent.ELEMENT_ACTIVATING);
        instance.setJobKey(5L);
        this.elementInstanceState.updateInstance(instance);
        ElementInstance updatedInstance = this.elementInstanceState.getInstance(100L);
        Assertions.assertThat((long)updatedInstance.getKey()).isEqualTo(100L);
        Assertions.assertThat((Comparable)updatedInstance.getState()).isEqualTo((Object)ProcessInstanceIntent.ELEMENT_ACTIVATING);
        Assertions.assertThat((long)updatedInstance.getJobKey()).isEqualTo(5L);
        Assertions.assertThat((boolean)updatedInstance.canTerminate()).isTrue();
        Assertions.assertThat((int)updatedInstance.getNumberOfActiveElementInstances()).isEqualTo(0);
        ProcessInstanceRecord record = updatedInstance.getValue();
        this.assertProcessInstanceRecord(record);
    }

    @Test
    public void shouldNotUpdateElementInstance() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance instance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        instance.setState(ProcessInstanceIntent.ELEMENT_ACTIVATING);
        instance.setJobKey(5L);
        ElementInstance updatedInstance = this.elementInstanceState.getInstance(100L);
        Assertions.assertThat((long)updatedInstance.getKey()).isEqualTo(100L);
        Assertions.assertThat((Comparable)updatedInstance.getState()).isEqualTo((Object)ProcessInstanceIntent.ELEMENT_ACTIVATED);
        Assertions.assertThat((long)updatedInstance.getJobKey()).isEqualTo(0L);
        Assertions.assertThat((boolean)updatedInstance.canTerminate()).isTrue();
        Assertions.assertThat((int)updatedInstance.getNumberOfActiveElementInstances()).isEqualTo(0);
        ProcessInstanceRecord record = updatedInstance.getValue();
        this.assertProcessInstanceRecord(record);
    }

    @Test
    public void shouldNotUpdateElementInstanceWithoutFlush() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance instance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        instance.setState(ProcessInstanceIntent.ELEMENT_ACTIVATING);
        instance.setJobKey(5L);
        ElementInstance oldInstance = this.elementInstanceState.getInstance(100L);
        this.assertElementInstance(oldInstance, 0);
    }

    @Test
    public void shouldCollectChildInstances() {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        processInstanceRecord.setElementId("subProcess");
        this.elementInstanceState.newInstance(parentInstance, 101L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        processInstanceRecord.setElementId("subProcess2");
        this.elementInstanceState.newInstance(parentInstance, 102L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        List children = this.elementInstanceState.getChildren(100L);
        Assertions.assertThat((List)children).hasSize(2);
        this.assertChildInstance((ElementInstance)children.get(0), 101L, "subProcess");
        this.assertChildInstance((ElementInstance)children.get(1), 102L, "subProcess2");
    }

    @Test
    public void shouldNotLeakMemoryOnRemoval() {
        int parent = 100;
        int child = 101;
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord();
        ElementInstance parentInstance = this.elementInstanceState.newInstance(100L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        this.zeebeState.getVariableState().setVariableLocal(1L, 100L, 123L, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        processInstanceRecord.setElementId("subProcess");
        this.elementInstanceState.newInstance(parentInstance, 101L, processInstanceRecord, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        this.zeebeState.getVariableState().setVariableLocal(2L, 101L, 123L, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.elementInstanceState.removeInstance(101L);
        this.elementInstanceState.removeInstance(100L);
        List nonEmptyColumns = Arrays.stream(ZbColumnFamilies.values()).filter(Predicate.not(arg_0 -> ZbColumnFamilies.KEY.equals(arg_0))).filter(Predicate.not(arg_0 -> ((MutableZeebeState)this.zeebeState).isEmpty(arg_0))).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(nonEmptyColumns).describedAs("Expected all columns to be empty", new Object[0])).isEmpty();
    }

    @Test
    public void shouldUpdateAwaitResultMetadata() {
        long key = 10L;
        int streamId = 2;
        long requestId = 10000L;
        this.elementInstanceState.setAwaitResultRequestMetadata(10L, new AwaitProcessInstanceResultMetadata().setRequestStreamId(2).setRequestId(10000L));
        AwaitProcessInstanceResultMetadata metadata = this.elementInstanceState.getAwaitResultRequestMetadata(10L);
        Assertions.assertThat((long)metadata.getRequestId()).isEqualTo(10000L);
        Assertions.assertThat((int)metadata.getRequestStreamId()).isEqualTo(2);
    }

    private void assertElementInstance(ElementInstance elementInstance, int childCount) {
        Assertions.assertThat((long)elementInstance.getKey()).isEqualTo(100L);
        Assertions.assertThat((Comparable)elementInstance.getState()).isEqualTo((Object)ProcessInstanceIntent.ELEMENT_ACTIVATED);
        Assertions.assertThat((long)elementInstance.getJobKey()).isEqualTo(0L);
        Assertions.assertThat((boolean)elementInstance.canTerminate()).isTrue();
        Assertions.assertThat((int)elementInstance.getNumberOfActiveElementInstances()).isEqualTo(childCount);
        ProcessInstanceRecord record = elementInstance.getValue();
        this.assertProcessInstanceRecord(record);
    }

    private void assertChildInstance(ElementInstance childInstance, long key, String elementId) {
        Assertions.assertThat((long)childInstance.getKey()).isEqualTo(key);
        Assertions.assertThat((Comparable)childInstance.getState()).isEqualTo((Object)ProcessInstanceIntent.ELEMENT_ACTIVATING);
        Assertions.assertThat((long)childInstance.getJobKey()).isEqualTo(0L);
        Assertions.assertThat((boolean)childInstance.canTerminate()).isTrue();
        Assertions.assertThat((int)childInstance.getNumberOfActiveElementInstances()).isEqualTo(0);
        this.assertProcessInstanceRecord(childInstance.getValue(), BufferUtil.wrapString((String)elementId));
    }

    private ProcessInstanceRecord createProcessInstanceRecord() {
        ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
        processInstanceRecord.setElementId("startEvent");
        processInstanceRecord.setBpmnProcessId(BufferUtil.wrapString((String)"process1"));
        processInstanceRecord.setProcessInstanceKey(1000L);
        processInstanceRecord.setFlowScopeKey(1001L);
        processInstanceRecord.setVersion(1);
        processInstanceRecord.setProcessDefinitionKey(2L);
        processInstanceRecord.setBpmnElementType(BpmnElementType.START_EVENT);
        return processInstanceRecord;
    }

    private void assertProcessInstanceRecord(ProcessInstanceRecord record) {
        this.assertProcessInstanceRecord(record, BufferUtil.wrapString((String)"startEvent"));
    }

    private void assertProcessInstanceRecord(ProcessInstanceRecord record, DirectBuffer elementId) {
        Assertions.assertThat((Comparable)record.getElementIdBuffer()).isEqualTo((Object)elementId);
        Assertions.assertThat((Comparable)record.getBpmnProcessIdBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"process1"));
        Assertions.assertThat((long)record.getProcessInstanceKey()).isEqualTo(1000L);
        Assertions.assertThat((long)record.getFlowScopeKey()).isEqualTo(1001L);
        Assertions.assertThat((int)record.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)record.getProcessDefinitionKey()).isEqualTo(2L);
        Assertions.assertThat((Comparable)record.getBpmnElementType()).isEqualTo((Object)BpmnElementType.START_EVENT);
    }
}

