/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.instance.EventScopeInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class EventScopeInstanceStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableEventScopeInstanceState state;

    @Before
    public void setUp() {
        MutableZeebeState zeebeState = this.stateRule.getZeebeState();
        this.state = zeebeState.getEventScopeInstanceState();
    }

    @Test
    public void shouldCreateInterruptingEventScopeInstance() {
        long key = 123L;
        this.state.createIfNotExists(123L, Collections.singleton(BufferUtil.wrapString((String)"foo")));
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterrupting(BufferUtil.wrapString((String)"foo"))).isTrue();
    }

    @Test
    public void shouldCreateNonInterruptingEventScopeInstance() {
        long key = 123L;
        this.state.createIfNotExists(123L, Collections.singleton(BufferUtil.wrapString((String)"foo")));
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
        Assertions.assertThat((boolean)instance.isInterrupting(BufferUtil.wrapString((String)"bar"))).isFalse();
    }

    @Test
    public void shouldTriggerInterruptingEventScopeInstance() {
        long key = 123L;
        long eventKey = 456L;
        EventTrigger eventTrigger = this.createEventTrigger();
        this.state.createIfNotExists(123L, Collections.singleton(eventTrigger.getElementId()));
        boolean triggered = this.triggerEvent(123L, 456L, eventTrigger);
        Assertions.assertThat((boolean)triggered).isTrue();
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isFalse();
    }

    @Test
    public void shouldTriggerInterruptingEventScopeInstanceOnlyOnce() {
        long key = 123L;
        long eventKey1 = 456L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 789L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.state.createIfNotExists(123L, Collections.singleton(eventTrigger1.getElementId()));
        boolean triggered1 = this.triggerEvent(123L, 456L, eventTrigger1);
        boolean triggered2 = this.triggerEvent(123L, 789L, eventTrigger2);
        Assertions.assertThat((boolean)triggered1).isTrue();
        Assertions.assertThat((boolean)triggered2).isFalse();
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isFalse();
    }

    @Test
    public void shouldTriggerNonInterruptingEventScopeInstanceMultipleTimes() {
        long key = 123L;
        long eventKey1 = 456L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        long eventKey2 = 789L;
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.state.createIfNotExists(123L, Collections.emptyList());
        boolean triggered1 = this.triggerEvent(123L, 456L, eventTrigger1);
        boolean triggered2 = this.triggerEvent(123L, 789L, eventTrigger2);
        Assertions.assertThat((boolean)triggered1).isTrue();
        Assertions.assertThat((boolean)triggered2).isTrue();
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isTrue();
    }

    @Test
    public void shouldNotTriggerOnNonExistingEventScope() {
        EventTrigger eventTrigger = this.createEventTrigger();
        boolean triggered = this.triggerEvent(123L, 456L, eventTrigger);
        Assertions.assertThat((boolean)triggered).isFalse();
    }

    @Test
    public void shouldTriggerStartEventForNonExistingEventScope() {
        long scopeKey = 123L;
        EventTrigger eventTrigger = this.createEventTrigger();
        this.triggerStartEvent(123L, 456L, eventTrigger);
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isEqualTo((Object)eventTrigger);
    }

    @Test
    public void shouldPeekEventTrigger() {
        long key = 123L;
        EventTrigger eventTrigger = this.createEventTrigger();
        this.state.createIfNotExists(123L, Collections.emptyList());
        this.triggerEvent(123L, 1L, eventTrigger);
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isEqualTo((Object)eventTrigger);
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isEqualTo((Object)eventTrigger);
    }

    @Test
    public void shouldPollEventTrigger() {
        long key = 123L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.state.createIfNotExists(123L, Collections.emptyList());
        this.triggerEvent(123L, 1L, eventTrigger1);
        this.triggerEvent(123L, 2L, eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    public void shouldPollStartEventTrigger() {
        long scopeKey = 123L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        EventTrigger eventTrigger2 = this.createEventTrigger();
        this.triggerStartEvent(123L, 1L, eventTrigger1);
        this.triggerStartEvent(123L, 2L, eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger1);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isEqualTo((Object)eventTrigger2);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    public void shouldDeleteTrigger() {
        long key = 123L;
        long eventKey = 456L;
        this.state.createIfNotExists(123L, Collections.emptyList());
        this.triggerEvent(123L, 456L, this.createEventTrigger());
        this.state.deleteTrigger(123L, 456L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    public void shouldDeleteStartEventTrigger() {
        long scopeKey = 123L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        this.triggerStartEvent(123L, 1L, eventTrigger1);
        this.state.deleteTrigger(123L, 1L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    public void shouldDeleteEventScopeAndTriggers() {
        long key = 123L;
        this.state.createIfNotExists(123L, Collections.emptyList());
        this.triggerEvent(123L, 1L, this.createEventTrigger());
        this.triggerEvent(123L, 2L, this.createEventTrigger());
        this.triggerEvent(123L, 3L, this.createEventTrigger());
        this.state.deleteInstance(123L);
        Assertions.assertThat((Object)this.state.getInstance(123L)).isNull();
        Assertions.assertThat((Object)this.state.peekEventTrigger(123L)).isNull();
    }

    @Test
    public void shouldNotTriggerOnDeletedEventScope() {
        long key = 123L;
        EventTrigger eventTrigger = this.createEventTrigger();
        this.state.createIfNotExists(123L, Collections.singleton(eventTrigger.getElementId()));
        this.state.deleteInstance(123L);
        boolean triggered = this.triggerEvent(123L, 456L, eventTrigger);
        Assertions.assertThat((boolean)triggered).isFalse();
    }

    @Test
    public void shouldDeleteStartEventTriggerOnDeletionOfInstance() {
        long scopeKey = 123L;
        EventTrigger eventTrigger1 = this.createEventTrigger();
        this.triggerStartEvent(123L, 1L, eventTrigger1);
        this.state.deleteInstance(123L);
        Assertions.assertThat((Object)this.state.pollEventTrigger(123L)).isNull();
    }

    @Test
    public void shouldNotFailOnDeletionOfNonExistingInstance() {
        long key = 123L;
        Assertions.assertThatNoException().isThrownBy(() -> this.state.deleteInstance(123L));
    }

    @Test
    public void shouldShutdownInstance() {
        long key = 123L;
        this.state.createIfNotExists(123L, Collections.singleton(BufferUtil.wrapString((String)"foo")));
        this.state.shutdownInstance(123L);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((boolean)instance.isAccepting()).isFalse();
    }

    @Test
    public void shouldNotCreateInstanceIfTryingToShutdownNonExistentOne() {
        long key = 123L;
        this.state.shutdownInstance(123L);
        EventScopeInstance instance = this.state.getInstance(123L);
        Assertions.assertThat((Object)instance).isNull();
    }

    @Test
    public void shouldResetElementInstance() {
        long firstKey = 123L;
        long secondKey = 345L;
        DirectBuffer firstId = BufferUtil.wrapString((String)"a");
        List<DirectBuffer> firstIds = Collections.singletonList(firstId);
        this.state.createIfNotExists(123L, firstIds);
        this.state.createIfNotExists(345L, Collections.emptyList());
        Assertions.assertThat((boolean)this.state.getInstance(123L).isInterrupting(firstId)).isTrue();
        Assertions.assertThat((boolean)this.state.getInstance(345L).isInterrupting(firstId)).isFalse();
    }

    private boolean triggerEvent(long eventScopeKey, long eventKey, EventTrigger eventTrigger) {
        return this.state.triggerEvent(eventScopeKey, eventKey, eventTrigger.getElementId(), eventTrigger.getVariables());
    }

    private void triggerStartEvent(long eventScopeKey, long eventKey, EventTrigger eventTrigger) {
        this.state.triggerStartEvent(eventScopeKey, eventKey, eventTrigger.getElementId(), eventTrigger.getVariables());
    }

    private EventTrigger createEventTrigger() {
        return this.createEventTrigger(this.randomString(), this.randomString());
    }

    private EventTrigger createEventTrigger(String elementId, String variables) {
        return new EventTrigger().setElementId(BufferUtil.wrapString((String)elementId)).setVariables(BufferUtil.wrapString((String)variables));
    }

    private String randomString() {
        return UUID.randomUUID().toString();
    }
}

