/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class TimerInstanceStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableTimerInstanceState state;

    @Before
    public void setUp() {
        MutableZeebeState zeebeState = this.stateRule.getZeebeState();
        this.state = zeebeState.getTimerState();
    }

    @Test
    public void shouldInsertTimer() {
        TimerInstance timer = new TimerInstance();
        timer.setElementInstanceKey(1L);
        timer.setKey(2L);
        timer.setDueDate(1000L);
        this.state.put(timer);
        ArrayList timers = new ArrayList();
        this.state.findTimersWithDueDateBefore(1000L, timers::add);
        Assertions.assertThat(timers).hasSize(1);
        TimerInstance readTimer = (TimerInstance)timers.get(0);
        Assertions.assertThat((long)readTimer.getElementInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)readTimer.getKey()).isEqualTo(2L);
        Assertions.assertThat((long)readTimer.getDueDate()).isEqualTo(1000L);
    }

    @Test
    public void shouldRemoveTimer() {
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setDueDate(1000L);
        this.state.put(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(2L);
        timer2.setDueDate(2000L);
        this.state.put(timer2);
        TimerInstance timer = new TimerInstance();
        timer.setElementInstanceKey(1L);
        timer.setDueDate(1000L);
        this.state.remove(timer);
        ArrayList timers = new ArrayList();
        this.state.findTimersWithDueDateBefore(2000L, timers::add);
        Assertions.assertThat(timers).hasSize(1);
        Assertions.assertThat((long)((TimerInstance)timers.get(0)).getElementInstanceKey()).isEqualTo(2L);
    }

    @Test
    public void shouldGetTimerByElementInstanceKey() {
        TimerInstance timer = new TimerInstance();
        timer.setElementInstanceKey(1L);
        timer.setProcessInstanceKey(1L);
        timer.setKey(2L);
        timer.setDueDate(1000L);
        this.state.put(timer);
        TimerInstance readTimer = this.state.get(1L, 2L);
        Assertions.assertThat((Object)readTimer).isNotNull();
        Assertions.assertThat((long)readTimer.getElementInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)readTimer.getKey()).isEqualTo(2L);
        Assertions.assertThat((long)readTimer.getProcessInstanceKey()).isEqualTo(1L);
        Assertions.assertThat((long)readTimer.getDueDate()).isEqualTo(1000L);
        Assertions.assertThat((Object)this.state.get(2L, 1L)).isNull();
    }

    @Test
    public void shouldFindTimersWithDueDate() {
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setDueDate(1000L);
        this.state.put(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(2L);
        timer2.setDueDate(2000L);
        this.state.put(timer2);
        TimerInstance timer3 = new TimerInstance();
        timer3.setElementInstanceKey(3L);
        timer3.setDueDate(3000L);
        this.state.put(timer3);
        ArrayList keys = new ArrayList();
        this.state.findTimersWithDueDateBefore(2000L, t -> keys.add(t.getElementInstanceKey()));
        Assertions.assertThat(keys).hasSize(2);
        Assertions.assertThat(keys).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldReturnNextDueDate() {
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setDueDate(1000L);
        this.state.put(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(2L);
        timer2.setDueDate(2000L);
        this.state.put(timer2);
        TimerInstance timer3 = new TimerInstance();
        timer3.setElementInstanceKey(3L);
        timer3.setDueDate(3000L);
        this.state.put(timer3);
        long nextDueDate = this.state.findTimersWithDueDateBefore(2000L, t -> true);
        Assertions.assertThat((long)nextDueDate).isEqualTo(3000L);
    }

    @Test
    public void shouldReturnNegativeDueDateIfEmpty() {
        long nextDueDate = this.state.findTimersWithDueDateBefore(2000L, t -> true);
        Assertions.assertThat((long)nextDueDate).isEqualTo(-1L);
    }

    @Test
    public void shouldReturnNegativeDueDateIfNoMoreTimers() {
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setDueDate(1000L);
        this.state.put(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(1L);
        timer2.setDueDate(1000L);
        this.state.put(timer2);
        TimerInstance timer3 = new TimerInstance();
        timer3.setElementInstanceKey(3L);
        timer3.setDueDate(3000L);
        this.state.put(timer3);
        long nextDueDate = this.state.findTimersWithDueDateBefore(3000L, t -> true);
        Assertions.assertThat((long)nextDueDate).isEqualTo(-1L);
    }

    @Test
    public void shouldFindTimersWithDueDateUntilNotConsumed() {
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setDueDate(1000L);
        this.state.put(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(2L);
        timer2.setDueDate(2000L);
        this.state.put(timer2);
        ArrayList keys = new ArrayList();
        long nextDueDate = this.state.findTimersWithDueDateBefore(2000L, t -> {
            keys.add(t.getElementInstanceKey());
            return false;
        });
        Assertions.assertThat(keys).hasSize(1);
        Assertions.assertThat(keys).contains((Object[])new Long[]{1L});
        Assertions.assertThat((long)nextDueDate).isEqualTo(timer1.getDueDate());
    }

    @Test
    public void shouldListAllTimersByElementInstanceKey() {
        TimerInstance timer1 = new TimerInstance();
        timer1.setElementInstanceKey(1L);
        timer1.setKey(1L);
        timer1.setDueDate(1000L);
        this.state.put(timer1);
        TimerInstance timer2 = new TimerInstance();
        timer2.setElementInstanceKey(1L);
        timer2.setKey(2L);
        timer2.setDueDate(2000L);
        this.state.put(timer2);
        TimerInstance timer3 = new TimerInstance();
        timer3.setElementInstanceKey(2L);
        timer3.setKey(3L);
        timer3.setDueDate(2000L);
        this.state.put(timer3);
        ArrayList keys = new ArrayList();
        this.state.forEachTimerForElementInstance(1L, t -> keys.add(t.getKey()));
        Assertions.assertThat(keys).hasSize(2);
        Assertions.assertThat(keys).containsExactly((Object[])new Long[]{1L, 2L});
    }
}

