/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class MessageStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableMessageState messageState;
    private MutableZeebeState zeebeState;

    @Before
    public void setUp() {
        this.zeebeState = this.stateRule.getZeebeState();
        this.messageState = this.zeebeState.getMessageState();
    }

    @Test
    public void shouldNotExistIfNameDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"otherName"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"));
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotExistIfCorrelationKeyDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"otherCorrelationKey"), BufferUtil.wrapString((String)"id"));
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotExistIfMessageIdDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"otherCorrelationKey"), BufferUtil.wrapString((String)"otherId"));
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldExist() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id");
        this.messageState.put(1L, message);
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"));
        Assertions.assertThat((boolean)exist).isTrue();
    }

    @Test
    public void shouldVisitMessages() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        ArrayList messages = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), messages::add);
        Assertions.assertThat(messages).hasSize(1);
        Assertions.assertThat((long)((StoredMessage)messages.get(0)).getMessageKey()).isEqualTo(1L);
        Assertions.assertThat((String)((StoredMessage)messages.get(0)).getMessage().getName()).isEqualTo(message.getName());
        Assertions.assertThat((String)((StoredMessage)messages.get(0)).getMessage().getCorrelationKey()).isEqualTo(message.getCorrelationKey());
    }

    @Test
    public void shouldVisitMessagesInOrder() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        MessageRecord message2 = this.createMessage("name", "correlationKey");
        this.messageState.put(2L, message2);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldVisitMessagesUntilStop() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        MessageRecord message2 = this.createMessage("name", "correlationKey");
        this.messageState.put(2L, message2);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> {
            keys.add(m.getMessageKey());
            return false;
        });
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldNotVisitMessagesIfNameDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"otherName"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldNotVisitMessageIfCorrelationKeyDoesntMatch() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"otherCorrelationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldNotVisitMessagesBeforeTime() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("name", "correlationKey", "{}", "nr2", 4567L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(1000L, readMessage::add);
        Assertions.assertThat(readMessage).isEmpty();
    }

    @Test
    public void shouldVisitMessagesBeforeTime() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("otherName", "correlationKey", "{}", "nr2", 2000L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(1999L, readMessage::add);
        Assertions.assertThat((int)readMessage.size()).isEqualTo(1);
        Assertions.assertThat((long)((StoredMessage)readMessage.get(0)).getMessageKey()).isEqualTo(1L);
    }

    @Test
    public void shouldVisitMessagesBeforeTimeInOrder() {
        long now = ActorClock.currentTimeMillis();
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "nr1", 1234L);
        MessageRecord message2 = this.createMessage("name", "correlationKey", "{}", "nr1", 2000L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        long deadline = now + 3000L;
        ArrayList readMessage = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(deadline, m -> readMessage.add(m.getMessageKey()));
        Assertions.assertThat((int)readMessage.size()).isEqualTo(2);
        Assertions.assertThat(readMessage).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldRemoveMessage() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id", 1234L);
        this.messageState.put(1L, message);
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"a"));
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"b"));
        this.messageState.remove(1L);
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(2000L, readMessages::add);
        Assertions.assertThat((int)readMessages.size()).isEqualTo(0);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"));
        Assertions.assertThat((boolean)exist).isFalse();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"a"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"b"))).isFalse();
    }

    @Test
    public void shouldRemoveMessageWithoutId() {
        MessageRecord message = this.createMessage("name", "correlationKey");
        this.messageState.put(1L, message);
        this.messageState.remove(1L);
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(2000L, readMessages::add);
        Assertions.assertThat((int)readMessages.size()).isEqualTo(0);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldNotFailOnRemoveMessageTwice() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id", 1234L);
        this.messageState.put(1L, message);
        this.messageState.remove(1L);
        this.messageState.remove(1L);
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(2000L, readMessages::add);
        Assertions.assertThat((int)readMessages.size()).isEqualTo(0);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        Assertions.assertThat(keys).isEmpty();
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"messageName"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id"));
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldNotRemoveDifferentMessage() {
        MessageRecord message = this.createMessage("name", "correlationKey", "{}", "id1", 1234L);
        MessageRecord message2 = this.createMessage("name", "correlationKey", "{}", "id2", 4567L);
        this.messageState.put(1L, message);
        this.messageState.put(2L, message2);
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"a"));
        this.messageState.putMessageCorrelation(2L, BufferUtil.wrapString((String)"b"));
        this.messageState.remove(2L);
        long deadline = ActorClock.currentTimeMillis() + 2000L;
        ArrayList readMessages = new ArrayList();
        this.messageState.visitMessagesWithDeadlineBefore(deadline, readMessages::add);
        Assertions.assertThat((int)readMessages.size()).isEqualTo(1);
        ArrayList keys = new ArrayList();
        this.messageState.visitMessages(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), m -> keys.add(m.getMessageKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
        boolean exist = this.messageState.exist(BufferUtil.wrapString((String)"name"), BufferUtil.wrapString((String)"correlationKey"), BufferUtil.wrapString((String)"id1"));
        Assertions.assertThat((boolean)exist).isTrue();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"a"))).isTrue();
    }

    @Test
    public void shouldExistCorrelatedMessage() {
        this.messageState.putMessageCorrelation(1L, BufferUtil.wrapString((String)"a"));
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"a"))).isTrue();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(3L, BufferUtil.wrapString((String)"a"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(1L, BufferUtil.wrapString((String)"b"))).isFalse();
    }

    @Test
    public void shouldRemoveMessageCorrelation() {
        long messageKey = 6L;
        long processInstanceKey = 9L;
        this.messageState.putMessageCorrelation(6L, BufferUtil.wrapString((String)"a"));
        this.messageState.removeMessageCorrelation(6L, BufferUtil.wrapString((String)"a"));
        Assertions.assertThat((boolean)this.messageState.existMessageCorrelation(6L, BufferUtil.wrapString((String)"a"))).isFalse();
    }

    @Test
    public void shouldExistActiveProcessInstance() {
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"))).isTrue();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(BufferUtil.wrapString((String)"wf-2"), BufferUtil.wrapString((String)"key-1"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-2"))).isFalse();
    }

    @Test
    public void shouldRemoveActiveProcessInstance() {
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"));
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-2"), BufferUtil.wrapString((String)"key-1"));
        this.messageState.putActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-2"));
        this.messageState.removeActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-1"))).isFalse();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(BufferUtil.wrapString((String)"wf-2"), BufferUtil.wrapString((String)"key-1"))).isTrue();
        Assertions.assertThat((boolean)this.messageState.existActiveProcessInstance(BufferUtil.wrapString((String)"wf-1"), BufferUtil.wrapString((String)"key-2"))).isTrue();
    }

    @Test
    public void shouldGetProcessInstanceCorrelationKey() {
        this.messageState.putProcessInstanceCorrelationKey(1L, BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(1L)).isEqualTo((Object)BufferUtil.wrapString((String)"key-1"));
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(2L)).isNull();
    }

    @Test
    public void shouldRemoveProcessInstanceCorrelationKey() {
        this.messageState.putProcessInstanceCorrelationKey(1L, BufferUtil.wrapString((String)"key-1"));
        this.messageState.putProcessInstanceCorrelationKey(2L, BufferUtil.wrapString((String)"key-2"));
        this.messageState.removeProcessInstanceCorrelationKey(1L);
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(1L)).isNull();
        Assertions.assertThat((Comparable)this.messageState.getProcessInstanceCorrelationKey(2L)).isEqualTo((Object)BufferUtil.wrapString((String)"key-2"));
    }

    private MessageRecord createMessage(String name, String correlationKey) {
        return new MessageRecord().setName(name).setCorrelationKey(correlationKey).setTimeToLive(10000L).setDeadline(0L);
    }

    private MessageRecord createMessage(String name, String correlationKey, String variables, String id) {
        return new MessageRecord().setName(name).setCorrelationKey(correlationKey).setTimeToLive(10000L).setVariables(MsgPackUtil.asMsgPack((String)variables)).setMessageId(id);
    }

    private MessageRecord createMessage(String name, String correlationKey, String variables, String id, long deadline) {
        return new MessageRecord().setName(name).setCorrelationKey(correlationKey).setVariables(MsgPackUtil.asMsgPack((String)variables)).setMessageId(id).setDeadline(deadline).setTimeToLive(10000L);
    }
}

