/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.message.TransientSubscriptionCommandState;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TransientSubscriptionCommandStateTest {
    private TransientSubscriptionCommandState sut;

    @BeforeEach
    public void setUp() {
        this.sut = new TransientSubscriptionCommandState();
    }

    @Test
    public void shouldReturnNoEntriesByDefault() {
        Iterable actual = this.sut.getEntriesBefore(Long.MAX_VALUE);
        Assertions.assertThat((Iterable)actual).isEmpty();
    }

    @Test
    public void shouldReturnEntriesBeforeDeadline() {
        TransientSubscriptionCommandState.CommandEntry expected = new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L);
        this.sut.add(expected);
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(2L, "message", 2000L));
        Iterable actual = this.sut.getEntriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientSubscriptionCommandState.CommandEntry[]{expected});
    }

    @Test
    public void shouldReturnEntriesOrderedBySentTime() {
        TransientSubscriptionCommandState.CommandEntry first = new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L);
        TransientSubscriptionCommandState.CommandEntry second = new TransientSubscriptionCommandState.CommandEntry(2L, "message", 600L);
        TransientSubscriptionCommandState.CommandEntry third = new TransientSubscriptionCommandState.CommandEntry(3L, "message", 700L);
        this.sut.add(second);
        this.sut.add(first);
        this.sut.add(third);
        Iterable actual = this.sut.getEntriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientSubscriptionCommandState.CommandEntry[]{first, second, third});
    }

    @Test
    public void shouldOverwriteExistingEntries() {
        TransientSubscriptionCommandState.CommandEntry first = new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L);
        TransientSubscriptionCommandState.CommandEntry second = new TransientSubscriptionCommandState.CommandEntry(1L, "message", 600L);
        this.sut.add(first);
        this.sut.add(second);
        Iterable actual = this.sut.getEntriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientSubscriptionCommandState.CommandEntry[]{second});
    }

    @Test
    public void shouldAcceptEntriesWithTheSameSentTime() {
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L));
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(2L, "message", 500L));
        Iterable actual = this.sut.getEntriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).hasSize(2);
    }

    @Test
    public void shouldReturnEntriesBasedOnUpdatedSentTime() {
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(1L, "message", 3000L));
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(2L, "message", 2000L));
        TransientSubscriptionCommandState.CommandEntry expected = new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L);
        this.sut.updateCommandSentTime(expected);
        Iterable actual = this.sut.getEntriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).containsExactly((Object[])new TransientSubscriptionCommandState.CommandEntry[]{expected});
    }

    @Test
    public void shouldNotReturnEntriesThatHaveBeenRemoved() {
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L));
        this.sut.add(new TransientSubscriptionCommandState.CommandEntry(2L, "message", 2000L));
        this.sut.remove(new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L));
        Iterable actual = this.sut.getEntriesBefore(1000L);
        Assertions.assertThat((Iterable)actual).isEmpty();
    }

    @Test
    public void shouldBeTolerantWhenRemovingEntriesThatDoNotExist() {
        Assertions.assertThatNoException().isThrownBy(() -> this.sut.remove(new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L)));
    }

    @Test
    public void shouldBeTolerantWhenUpdatingEntriesThatDoNotExist() {
        Assertions.assertThatNoException().isThrownBy(() -> this.sut.updateCommandSentTime(new TransientSubscriptionCommandState.CommandEntry(1L, "message", 500L)));
    }
}

