/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_1;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.migration.to_1_1.LegacyProcessMessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class LegacyDbProcessMessageSubscriptionState {
    private final TransactionContext transactionContext;
    private final DbLong elementInstanceKey;
    private final DbString messageName;
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName;
    private final LegacyProcessMessageSubscription processMessageSubscription;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, LegacyProcessMessageSubscription> subscriptionColumnFamily;
    private final DbLong sentTime;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> sentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> sentTimeColumnFamily;

    public LegacyDbProcessMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        this.elementInstanceKey = new DbLong();
        this.messageName = new DbString();
        this.elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
        this.processMessageSubscription = new LegacyProcessMessageSubscription();
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, (DbValue)this.processMessageSubscription);
        this.sentTime = new DbLong();
        this.sentTimeCompositeKey = new DbCompositeKey((DbKey)this.sentTime, this.elementKeyAndMessageName);
        this.sentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    public void put(long key, ProcessMessageSubscriptionRecord record, long commandSentTime) {
        this.wrapSubscriptionKeys(record.getElementInstanceKey(), record.getMessageNameBuffer());
        this.processMessageSubscription.reset();
        this.processMessageSubscription.setKey(key).setRecord(record).setCommandSentTime(commandSentTime);
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)this.processMessageSubscription);
        this.sentTime.wrapLong(commandSentTime);
        this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    public void updateToOpenedState(ProcessMessageSubscriptionRecord record) {
        this.update(record, (LegacyProcessMessageSubscription s) -> s.setRecord(record).setCommandSentTime(0L).setOpened());
    }

    public void updateToClosingState(ProcessMessageSubscriptionRecord record, long commandSentTime) {
        this.update(record, (LegacyProcessMessageSubscription s) -> s.setRecord(record).setCommandSentTime(commandSentTime).setClosing());
    }

    public void updateSentTimeInTransaction(LegacyProcessMessageSubscription subscription, long commandSentTime) {
        this.transactionContext.runInTransaction(() -> this.update(subscription, (LegacyProcessMessageSubscription s) -> s.setCommandSentTime(commandSentTime)));
    }

    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        LegacyProcessMessageSubscription subscription = this.getSubscription(elementInstanceKey, messageName);
        boolean bl = found = subscription != null;
        if (found) {
            this.remove(subscription);
        }
        return found;
    }

    public LegacyProcessMessageSubscription getSubscription(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return (LegacyProcessMessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    private void update(ProcessMessageSubscriptionRecord record, Consumer<LegacyProcessMessageSubscription> modifier) {
        LegacyProcessMessageSubscription subscription = this.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer());
        if (subscription == null) {
            return;
        }
        this.update(subscription, modifier);
    }

    private void update(LegacyProcessMessageSubscription subscription, Consumer<LegacyProcessMessageSubscription> modifier) {
        long previousSentTime = subscription.getCommandSentTime();
        modifier.accept(subscription);
        this.wrapSubscriptionKeys(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageNameBuffer());
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        long updatedSentTime = subscription.getCommandSentTime();
        if (updatedSentTime != previousSentTime) {
            if (previousSentTime > 0L) {
                this.sentTime.wrapLong(previousSentTime);
                this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
            }
            if (updatedSentTime > 0L) {
                this.sentTime.wrapLong(updatedSentTime);
                this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
            }
        }
    }

    private void remove(LegacyProcessMessageSubscription subscription) {
        this.wrapSubscriptionKeys(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageNameBuffer());
        this.subscriptionColumnFamily.delete(this.elementKeyAndMessageName);
        this.sentTime.wrapLong(subscription.getCommandSentTime());
        this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
    }

    private void wrapSubscriptionKeys(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
    }
}

