/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.LongConsumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ListLogStorage
implements LogStorage {
    private final ConcurrentNavigableMap<Long, Integer> positionIndexMapping;
    private final List<Entry> entries;
    private LongConsumer positionListener;
    private final Set<LogStorage.CommitListener> commitListeners = new HashSet<LogStorage.CommitListener>();

    public ListLogStorage() {
        this.entries = new CopyOnWriteArrayList<Entry>();
        this.positionIndexMapping = new ConcurrentSkipListMap<Long, Integer>();
    }

    public void setPositionListener(LongConsumer positionListener) {
        this.positionListener = positionListener;
    }

    public LogStorageReader newReader() {
        return new ListLogStorageReader();
    }

    public void append(long lowestPosition, long highestPosition, ByteBuffer blockBuffer, LogStorage.AppendListener listener) {
        try {
            Entry entry = new Entry(blockBuffer);
            this.entries.add(entry);
            int index = this.entries.size();
            this.positionIndexMapping.put(lowestPosition, index);
            listener.onWrite((long)index);
            if (this.positionListener != null) {
                this.positionListener.accept(highestPosition);
            }
            listener.onCommit((long)index);
            this.commitListeners.forEach(LogStorage.CommitListener::onCommit);
        }
        catch (Exception e) {
            listener.onWriteError((Throwable)e);
        }
    }

    public void addCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.remove(listener);
    }

    private class ListLogStorageReader
    implements LogStorageReader {
        int currentIndex;

        private ListLogStorageReader() {
        }

        public void seek(long position) {
            this.currentIndex = Optional.ofNullable(ListLogStorage.this.positionIndexMapping.lowerEntry(position)).map(Map.Entry::getValue).map(index -> index - 1).orElse(0);
        }

        public void close() {
        }

        public boolean hasNext() {
            return this.currentIndex >= 0 && this.currentIndex < ListLogStorage.this.entries.size();
        }

        public DirectBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.currentIndex++;
            return new UnsafeBuffer(ListLogStorage.this.entries.get((int)index).data);
        }
    }

    private static final class Entry {
        private final ByteBuffer data;

        public Entry(ByteBuffer data) {
            this.data = data;
        }

        public ByteBuffer getData() {
            return this.data;
        }
    }
}

