/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.util.SynchronousLogStream;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogStreamPrinter {
    private static final String HEADER_INDENTATION = "\t\t\t";
    private static final String ENTRY_INDENTATION = "\t\t\t\t";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"io.camunda.zeebe.broker.test");

    public static void printRecords(SynchronousLogStream logStream) {
        StringBuilder sb = new StringBuilder();
        sb.append("Records on partition ");
        sb.append(logStream.getPartitionId());
        sb.append(":\n");
        EnumMap<ValueType, UnpackedObject> eventCache = new EnumMap<ValueType, UnpackedObject>(ValueType.class);
        TypedEventRegistry.EVENT_REGISTRY.forEach((t, c) -> eventCache.put((ValueType)t, (UnpackedObject)ReflectUtil.newInstance((Class)c)));
        try (LogStreamReader streamReader = logStream.newLogStreamReader();){
            streamReader.seekToFirstEvent();
            while (streamReader.hasNext()) {
                LoggedEvent event = (LoggedEvent)streamReader.next();
                LogStreamPrinter.writeRecord(eventCache, event, sb);
            }
        }
        LOGGER.info(sb.toString());
    }

    private static void writeRecord(Map<ValueType, UnpackedObject> eventCache, LoggedEvent event, StringBuilder sb) {
        sb.append(HEADER_INDENTATION);
        LogStreamPrinter.writeRecordHeader(event, sb);
        sb.append("\n");
        RecordMetadata metadata = new RecordMetadata();
        event.readMetadata((BufferReader)metadata);
        sb.append(ENTRY_INDENTATION);
        LogStreamPrinter.writeMetadata(metadata, sb);
        sb.append("\n");
        UnpackedObject unpackedObject = eventCache.get(metadata.getValueType());
        event.readValue((BufferReader)unpackedObject);
        sb.append(ENTRY_INDENTATION).append("Value:\n");
        unpackedObject.writeJSON(sb);
        sb.append("\n");
    }

    private static void writeRecordHeader(LoggedEvent event, StringBuilder sb) {
        sb.append("Position: ");
        sb.append(event.getPosition());
        sb.append(" Key: ");
        sb.append(event.getKey());
    }

    private static void writeMetadata(RecordMetadata metadata, StringBuilder sb) {
        sb.append(metadata.toString());
    }
}

