/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;

public final class MockTypedRecord<T extends UnifiedRecordValue>
implements TypedRecord<T> {
    private final long timestamp;
    private long key;
    private RecordMetadata metadata;
    private T value;

    public MockTypedRecord(long key, RecordMetadata metadata, T value) {
        this.key = key;
        this.metadata = metadata;
        this.value = value;
        this.timestamp = System.currentTimeMillis();
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public T getValue() {
        return this.value;
    }

    public int getRequestStreamId() {
        return this.metadata.getRequestStreamId();
    }

    public long getRequestId() {
        return this.metadata.getRequestId();
    }

    public long getLength() {
        return this.metadata.getLength() + this.value.getLength();
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setMetadata(RecordMetadata metadata) {
        this.metadata = metadata;
    }

    public long getPosition() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long getSourceRecordPosition() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Intent getIntent() {
        return this.metadata.getIntent();
    }

    public int getPartitionId() {
        return Protocol.decodePartitionId((long)this.key);
    }

    public RecordType getRecordType() {
        return this.metadata.getRecordType();
    }

    public RejectionType getRejectionType() {
        return this.metadata.getRejectionType();
    }

    public String getRejectionReason() {
        return this.metadata.getRejectionReason();
    }

    public String getBrokerVersion() {
        return this.metadata.getBrokerVersion().toString();
    }

    public ValueType getValueType() {
        return this.metadata.getValueType();
    }

    public String toJson() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Record<T> clone() {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

