/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.bpmn.random.steps.AbstractExecutionStep;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndCompleteJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndFailJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndTimeoutJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateJobAndThrowError;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepCompleteUserTask;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPublishMessage;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPublishStartMessage;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepRaiseIncidentThenResolveAndPickConditionCase;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepStartProcessInstance;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepThrowError;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepTriggerTimerBoundaryEvent;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepTriggerTimerStartEvent;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import org.awaitility.Awaitility;

public class ProcessExecutor {
    private final EngineRule engineRule;

    public ProcessExecutor(EngineRule engineRule) {
        this.engineRule = engineRule;
    }

    public void applyStep(AbstractExecutionStep step) {
        if (!step.isAutomatic()) {
            if (step instanceof StepStartProcessInstance) {
                StepStartProcessInstance startProcess = (StepStartProcessInstance)step;
                this.createProcessInstance(startProcess);
            } else if (step instanceof StepPublishStartMessage) {
                StepPublishStartMessage publishMessage = (StepPublishStartMessage)step;
                this.publishStartMessage(publishMessage);
            } else if (step instanceof StepPublishMessage) {
                StepPublishMessage publishMessage = (StepPublishMessage)step;
                this.publishMessage(publishMessage);
            } else if (step instanceof StepActivateAndCompleteJob) {
                StepActivateAndCompleteJob activateAndCompleteJob = (StepActivateAndCompleteJob)step;
                this.activateAndCompleteJob(activateAndCompleteJob);
            } else if (step instanceof StepActivateAndFailJob) {
                StepActivateAndFailJob activateAndFailJob = (StepActivateAndFailJob)step;
                this.activateAndFailJob(activateAndFailJob);
            } else if (step instanceof StepActivateAndTimeoutJob) {
                StepActivateAndTimeoutJob activateAndTimeoutJob = (StepActivateAndTimeoutJob)step;
                this.activateAndTimeoutJob(activateAndTimeoutJob);
            } else if (step instanceof StepTriggerTimerBoundaryEvent) {
                StepTriggerTimerBoundaryEvent timeoutElement = (StepTriggerTimerBoundaryEvent)step;
                this.triggerTimerBoundaryEvent(timeoutElement);
            } else if (step instanceof StepActivateJobAndThrowError) {
                StepActivateJobAndThrowError activateJobAndThrowError = (StepActivateJobAndThrowError)step;
                this.activateJobAndThrowError(activateJobAndThrowError);
            } else if (step instanceof StepRaiseIncidentThenResolveAndPickConditionCase) {
                StepRaiseIncidentThenResolveAndPickConditionCase expressionIncident = (StepRaiseIncidentThenResolveAndPickConditionCase)step;
                this.resolveExpressionIncident(expressionIncident);
            } else if (step instanceof StepTriggerTimerStartEvent) {
                StepTriggerTimerStartEvent timerStep = (StepTriggerTimerStartEvent)step;
                this.triggerTimerStartEvent(timerStep);
            } else if (step instanceof StepCompleteUserTask) {
                StepCompleteUserTask stepCompleteUserTask = (StepCompleteUserTask)step;
                this.completeUserTask(stepCompleteUserTask);
            } else if (step instanceof StepThrowError) {
                StepThrowError stepThrowError = (StepThrowError)step;
                this.throwError(stepThrowError);
            } else {
                throw new IllegalStateException("Not yet implemented: " + step);
            }
        }
    }

    private void triggerTimerBoundaryEvent(StepTriggerTimerBoundaryEvent timeoutElement) {
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withHandlerNodeId(timeoutElement.getBoundaryTimerEventId()).getFirst();
        this.waitUntilRecordIsProcessed("await the timer to be processed", timerCreated);
        this.engineRule.getClock().addTime(timeoutElement.getDeltaTime());
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withHandlerNodeId(timeoutElement.getBoundaryTimerEventId()).await();
    }

    private void activateAndCompleteJob(StepActivateAndCompleteJob activateAndCompleteJob) {
        this.waitForJobToBeCreated(activateAndCompleteJob.getElementId());
        Map variables = activateAndCompleteJob.getVariables();
        ((JobBatchRecordValue)this.engineRule.jobs().withType(activateAndCompleteJob.getJobType()).activate().getValue()).getJobKeys().forEach(jobKey -> this.engineRule.job().withKey((long)jobKey).withVariables(variables).complete());
    }

    private void activateAndFailJob(StepActivateAndFailJob activateAndFailJob) {
        this.waitForJobToBeCreated(activateAndFailJob.getElementId());
        if (activateAndFailJob.isUpdateRetries()) {
            ((JobBatchRecordValue)this.engineRule.jobs().withType(activateAndFailJob.getJobType()).activate().getValue()).getJobKeys().forEach(jobKey -> {
                this.engineRule.job().withKey((long)jobKey).withRetries(0).fail();
                Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withJobKey(jobKey.longValue()).findFirst().get();
                this.engineRule.job().withKey((long)jobKey).withRetries(3).updateRetries();
                this.engineRule.incident().ofInstance(((IncidentRecordValue)incidentRecord.getValue()).getProcessInstanceKey()).withKey(incidentRecord.getKey()).resolve();
                RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withJobKey(jobKey.longValue()).await();
            });
        } else {
            ((JobBatchRecordValue)this.engineRule.jobs().withType(activateAndFailJob.getJobType()).activate().getValue()).getJobKeys().forEach(jobKey -> this.engineRule.job().withKey((long)jobKey).withRetries(3).fail());
        }
    }

    private void activateAndTimeoutJob(StepActivateAndTimeoutJob activateAndTimeoutJob) {
        this.waitForJobToBeCreated(activateAndTimeoutJob.getElementId());
        this.engineRule.jobs().withType(activateAndTimeoutJob.getJobType()).withTimeout(100L).activate();
        Record activatedJobBatch = (Record)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATED).withType(activateAndTimeoutJob.getJobType()).getFirst();
        this.waitUntilRecordIsProcessed("await job batch to be processed", activatedJobBatch);
        this.engineRule.getClock().addTime(activateAndTimeoutJob.getDeltaTime());
        RecordingExporter.jobRecords((JobIntent)JobIntent.TIME_OUT).withType(activateAndTimeoutJob.getJobType()).await();
    }

    private void activateJobAndThrowError(StepActivateJobAndThrowError stepActivateJobAndThrowError) {
        this.waitForJobToBeCreated(stepActivateJobAndThrowError.getElementId());
        ((JobBatchRecordValue)this.engineRule.jobs().withType(stepActivateJobAndThrowError.getJobType()).withTimeout(100L).activate().getValue()).getJobKeys().forEach(jobKey -> this.engineRule.job().withKey((long)jobKey).withErrorCode(stepActivateJobAndThrowError.getErrorCode()).throwError());
    }

    private Record<JobRecordValue> waitForJobToBeCreated(String elementId) {
        return (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withElementId(elementId).getFirst();
    }

    private void publishMessage(StepPublishMessage publishMessage) {
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withMessageName(publishMessage.getMessageName()).withCorrelationKey(publishMessage.getCorrelationKeyValue()).await();
        this.engineRule.message().withName(publishMessage.getMessageName()).withCorrelationKey(publishMessage.getCorrelationKeyValue()).withVariables(publishMessage.getVariables()).publish();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CORRELATED).withMessageName(publishMessage.getMessageName()).await();
    }

    private void publishStartMessage(StepPublishStartMessage publishMessage) {
        RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).withMessageName(publishMessage.getMessageName()).await();
        this.engineRule.message().withName(publishMessage.getMessageName()).withCorrelationKey("").withVariables(publishMessage.getProcessVariables()).publish();
        RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CORRELATED).withMessageName(publishMessage.getMessageName()).await();
    }

    private void createProcessInstance(StepStartProcessInstance startProcess) {
        this.engineRule.processInstance().ofBpmnProcessId(startProcess.getProcessId()).withVariables(startProcess.getProcessVariables()).create();
    }

    private void triggerTimerStartEvent(StepTriggerTimerStartEvent timerStep) {
        Record timerSchedulingRecord = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).getFirst();
        this.waitUntilRecordIsProcessed("until start timer is scheduled", timerSchedulingRecord);
        this.engineRule.increaseTime(timerStep.getDeltaTime());
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).await();
    }

    private void completeUserTask(StepCompleteUserTask completeUserTask) {
        Record<JobRecordValue> jobRecord = this.waitForJobToBeCreated(completeUserTask.getElementId());
        this.engineRule.job().withKey(jobRecord.getKey()).complete();
    }

    private void throwError(StepThrowError stepThrowError) {
        Record<JobRecordValue> jobRecord = this.waitForJobToBeCreated(stepThrowError.getElementId());
        this.engineRule.job().withKey(jobRecord.getKey()).withErrorCode(stepThrowError.getErrorCode()).throwError();
    }

    private void resolveExpressionIncident(StepRaiseIncidentThenResolveAndPickConditionCase expressionIncident) {
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withElementId(expressionIncident.getGatewayElementId()).findFirst().get();
        this.engineRule.variables().ofScope(((IncidentRecordValue)incident.getValue()).getProcessInstanceKey()).withDocument(MsgPackUtil.asMsgPack(Map.of(expressionIncident.getGatewayConditionVariable(), expressionIncident.getEdgeId()))).withUpdateSemantic(VariableDocumentUpdateSemantic.LOCAL).update();
        this.engineRule.incident().ofInstance(((IncidentRecordValue)incident.getValue()).getProcessInstanceKey()).withKey(incident.getKey()).resolve();
        RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withElementId(expressionIncident.getGatewayElementId()).await();
    }

    private void waitUntilRecordIsProcessed(String condition, Record<?> record) {
        Awaitility.await((String)condition).until(() -> this.engineRule.getLastProcessedPosition() >= record.getPosition());
    }
}

