/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class Records {
    public static DeploymentRecord asDeploymentRecord(LoggedEvent event) {
        return Records.readValueAs(event, DeploymentRecord.class);
    }

    public static JobRecord asJobRecord(LoggedEvent event) {
        return Records.readValueAs(event, JobRecord.class);
    }

    protected static <T extends UnpackedObject> T readValueAs(LoggedEvent event, Class<T> valueClass) {
        DirectBuffer copy = BufferUtil.cloneBuffer((DirectBuffer)event.getValueBuffer(), (int)event.getValueOffset(), (int)event.getValueLength());
        UnpackedObject valuePojo = (UnpackedObject)ReflectUtil.newInstance(valueClass);
        valuePojo.wrap(copy);
        return (T)valuePojo;
    }

    public static boolean isDeploymentRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.DEPLOYMENT);
    }

    public static boolean isJobRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.JOB);
    }

    public static boolean isIncidentRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.INCIDENT);
    }

    public static boolean isProcessInstanceRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.PROCESS_INSTANCE);
    }

    public static boolean isMessageRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.MESSAGE);
    }

    public static boolean isMessageSubscriptionRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.MESSAGE_SUBSCRIPTION);
    }

    public static boolean isMessageStartEventSubscriptionRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.MESSAGE_START_EVENT_SUBSCRIPTION);
    }

    public static boolean isProcessMessageSubscriptionRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.PROCESS_MESSAGE_SUBSCRIPTION);
    }

    public static boolean isTimerRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.TIMER);
    }

    public static boolean isProcessInstanceCreationRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.PROCESS_INSTANCE_CREATION);
    }

    public static boolean isErrorRecord(LoggedEvent event) {
        return Records.isRecordOfType(event, ValueType.ERROR);
    }

    public static boolean hasIntent(LoggedEvent event, Intent intent) {
        if (event == null) {
            return false;
        }
        RecordMetadata metadata = Records.getMetadata(event);
        return metadata.getIntent() == intent;
    }

    private static RecordMetadata getMetadata(LoggedEvent event) {
        RecordMetadata metadata = new RecordMetadata();
        event.readMetadata((BufferReader)metadata);
        return metadata;
    }

    public static boolean isRejection(LoggedEvent event) {
        RecordMetadata metadata = Records.getMetadata(event);
        return metadata.getRecordType() == RecordType.COMMAND_REJECTION;
    }

    public static boolean isRejection(LoggedEvent event, ValueType valueType, Intent intent) {
        return Records.isRejection(event) && Records.isRecordOfType(event, valueType) && Records.hasIntent(event, intent);
    }

    public static boolean isEvent(LoggedEvent event) {
        RecordMetadata metadata = Records.getMetadata(event);
        return metadata.getRecordType() == RecordType.EVENT;
    }

    public static boolean isEvent(LoggedEvent event, ValueType valueType, Intent intent) {
        return Records.isEvent(event) && Records.isRecordOfType(event, valueType) && Records.hasIntent(event, intent);
    }

    public static boolean isCommand(LoggedEvent event) {
        RecordMetadata metadata = Records.getMetadata(event);
        return metadata.getRecordType() == RecordType.COMMAND;
    }

    public static boolean isCommand(LoggedEvent event, ValueType valueType, Intent intent) {
        return Records.isCommand(event) && Records.isRecordOfType(event, valueType) && Records.hasIntent(event, intent);
    }

    public static boolean isRecordOfType(LoggedEvent event, ValueType type) {
        if (event == null) {
            return false;
        }
        RecordMetadata metadata = Records.getMetadata(event);
        return metadata.getValueType() == type;
    }

    public static ProcessRecord process(long processKey, String processId) {
        ProcessRecord record = new ProcessRecord();
        record.setKey(processKey).setBpmnProcessId(processId).setResourceName("process.bpmn").setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)Bpmn.createExecutableProcess((String)processId).startEvent().endEvent().done()))).setVersion(1).setChecksum(BufferUtil.wrapString((String)"checksum"));
        return record;
    }

    public static ProcessInstanceRecord processInstance(long instanceKey) {
        return Records.processInstance(instanceKey, "processId");
    }

    public static ProcessInstanceRecord processInstance(long instanceKey, String processId) {
        ProcessInstanceRecord record = new ProcessInstanceRecord();
        record.setProcessInstanceKey(instanceKey);
        record.setBpmnProcessId(processId);
        return record;
    }

    public static ErrorRecord error(int instanceKey, long pos) {
        ErrorRecord event = new ErrorRecord();
        event.initErrorRecord((Throwable)new Exception("expected"), pos);
        event.setProcessInstanceKey((long)instanceKey);
        return event;
    }

    public static JobRecord job(long instanceKey) {
        return Records.job(instanceKey, "processId");
    }

    public static JobRecord job(long instanceKey, String processId) {
        JobRecord record = new JobRecord();
        record.setProcessInstanceKey(instanceKey);
        record.setType("test");
        record.setBpmnProcessId(processId);
        return record;
    }

    public static TimerRecord timer(long instanceKey) {
        TimerRecord event = new TimerRecord();
        event.setProcessInstanceKey(instanceKey).setElementInstanceKey(instanceKey).setDueDate(1245L).setTargetElementId(BufferUtil.wrapString((String)"foo")).setRepetitions(0).setProcessDefinitionKey(1L);
        return event;
    }

    public static VariableDocumentRecord variableDocument(long instanceKey, String variables) {
        return new VariableDocumentRecord().setScopeKey(instanceKey).setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
    }

    public static <T extends UnpackedObject> T cloneValue(RecordValue value) {
        UnpackedObject unpackedValue = (UnpackedObject)value;
        UnsafeBuffer buffer = new UnsafeBuffer(ByteBuffer.allocate(unpackedValue.getLength()));
        UnpackedObject cloned = (UnpackedObject)ReflectUtil.newInstance(value.getClass());
        unpackedValue.write((MutableDirectBuffer)buffer, 0);
        cloned.wrap((DirectBuffer)buffer, 0, unpackedValue.getLength());
        return (T)cloned;
    }
}

