/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.LastProcessedPositionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.RecordStream;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.engine.util.Records;
import io.camunda.zeebe.engine.util.TestStreams;
import io.camunda.zeebe.logstreams.log.LogStreamRecordWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;

public class StreamProcessingComposite {
    private static final String STREAM_NAME = "stream-";
    private final TestStreams streams;
    private final int partitionId;
    private final ZeebeDbFactory zeebeDbFactory;
    private MutableZeebeState zeebeState;
    private LastProcessedPositionState lastProcessedPositionState;

    public StreamProcessingComposite(TestStreams streams, int partitionId, ZeebeDbFactory zeebeDbFactory) {
        this.streams = streams;
        this.partitionId = partitionId;
        this.zeebeDbFactory = zeebeDbFactory;
    }

    public LogStreamRecordWriter getLogStreamRecordWriter(int partitionId) {
        String logName = StreamProcessingComposite.getLogName(partitionId);
        return this.streams.getLogStreamRecordWriter(logName);
    }

    public StreamProcessor startTypedStreamProcessor(StreamProcessorTestFactory factory) {
        return this.startTypedStreamProcessor(processingContext -> this.createTypedRecordProcessors(factory, processingContext));
    }

    private TypedRecordProcessors createTypedRecordProcessors(StreamProcessorTestFactory factory, ProcessingContext processingContext) {
        this.zeebeState = processingContext.getZeebeState();
        this.lastProcessedPositionState = processingContext.getLastProcessedPositionState();
        return factory.build(TypedRecordProcessors.processors((KeyGenerator)this.zeebeState.getKeyGenerator(), (Writers)processingContext.getWriters()), (ReadonlyProcessingContext)processingContext);
    }

    public StreamProcessor startTypedStreamProcessor(TypedRecordProcessorFactory factory) {
        return this.startTypedStreamProcessor(this.partitionId, factory);
    }

    public StreamProcessor startTypedStreamProcessor(int partitionId, TypedRecordProcessorFactory factory) {
        return this.streams.startStreamProcessor(StreamProcessingComposite.getLogName(partitionId), this.zeebeDbFactory, processingContext -> {
            this.zeebeState = processingContext.getZeebeState();
            this.lastProcessedPositionState = processingContext.getLastProcessedPositionState();
            return factory.createProcessors(processingContext);
        });
    }

    public StreamProcessor startTypedStreamProcessorNotAwaitOpening(StreamProcessorTestFactory factory) {
        return this.startTypedStreamProcessorNotAwaitOpening(processingContext -> this.createTypedRecordProcessors(factory, processingContext));
    }

    public StreamProcessor startTypedStreamProcessorNotAwaitOpening(TypedRecordProcessorFactory factory) {
        return this.startTypedStreamProcessorNotAwaitOpening(this.partitionId, factory);
    }

    public StreamProcessor startTypedStreamProcessorNotAwaitOpening(int partitionId, TypedRecordProcessorFactory factory) {
        return this.streams.startStreamProcessorNotAwaitOpening(StreamProcessingComposite.getLogName(partitionId), this.zeebeDbFactory, processingContext -> {
            this.zeebeState = processingContext.getZeebeState();
            this.lastProcessedPositionState = processingContext.getLastProcessedPositionState();
            return factory.createProcessors(processingContext);
        });
    }

    public void pauseProcessing(int partitionId) {
        this.streams.pauseProcessing(StreamProcessingComposite.getLogName(partitionId));
    }

    public void resumeProcessing(int partitionId) {
        this.streams.resumeProcessing(StreamProcessingComposite.getLogName(partitionId));
    }

    public void snapshot(int partitionId) {
        this.streams.snapshot(StreamProcessingComposite.getLogName(partitionId));
    }

    public void closeStreamProcessor(int partitionId) {
        try {
            this.streams.closeProcessor(StreamProcessingComposite.getLogName(partitionId));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StreamProcessor getStreamProcessor(int partitionId) {
        return this.streams.getStreamProcessor(StreamProcessingComposite.getLogName(partitionId));
    }

    public MutableZeebeState getZeebeState() {
        return this.zeebeState;
    }

    public long getLastSuccessfulProcessedRecordPosition() {
        return this.lastProcessedPositionState.getLastSuccessfulProcessedRecordPosition();
    }

    public RecordStream events() {
        return new RecordStream(this.streams.events(StreamProcessingComposite.getLogName(this.partitionId)));
    }

    public long writeProcessInstanceEvent(ProcessInstanceIntent intent) {
        return this.writeProcessInstanceEvent(intent, 1);
    }

    public long writeProcessInstanceEventWithSource(ProcessInstanceIntent intent, int instanceKey, long sourceEventPosition) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).event((UnpackedObject)Records.processInstance(instanceKey)).recordType(RecordType.EVENT).sourceRecordPosition(sourceEventPosition).intent((Intent)intent).write();
    }

    public long writeProcessInstanceEvent(ProcessInstanceIntent intent, int instanceKey) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).event((UnpackedObject)Records.processInstance(instanceKey)).recordType(RecordType.EVENT).intent((Intent)intent).write();
    }

    public long writeEvent(long key, Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).recordType(RecordType.EVENT).key(key).intent(intent).event(value).write();
    }

    public long writeEvent(Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).recordType(RecordType.EVENT).intent(intent).event(value).write();
    }

    public long writeBatch(RecordToWrite ... recordToWrites) {
        return this.streams.writeBatch(StreamProcessingComposite.getLogName(this.partitionId), recordToWrites);
    }

    public long writeCommandOnPartition(int partition, Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(partition)).recordType(RecordType.COMMAND).intent(intent).event(value).write();
    }

    public long writeCommandOnPartition(int partition, long key, Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(partition)).key(key).recordType(RecordType.COMMAND).intent(intent).event(value).write();
    }

    public long writeCommand(long key, Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).recordType(RecordType.COMMAND).key(key).intent(intent).event(value).write();
    }

    public long writeCommand(Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).recordType(RecordType.COMMAND).intent(intent).event(value).write();
    }

    public long writeCommand(int requestStreamId, long requestId, Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).recordType(RecordType.COMMAND).requestId(requestId).requestStreamId(requestStreamId).intent(intent).event(value).write();
    }

    public long writeCommandRejection(Intent intent, UnpackedObject value) {
        return this.streams.newRecord(StreamProcessingComposite.getLogName(this.partitionId)).recordType(RecordType.COMMAND_REJECTION).intent(intent).event(value).write();
    }

    public static String getLogName(int partitionId) {
        return STREAM_NAME + partitionId;
    }

    @FunctionalInterface
    public static interface StreamProcessorTestFactory {
        public TypedRecordProcessors build(TypedRecordProcessors var1, ReadonlyProcessingContext var2);
    }
}

