/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class ZeebeStateExtension
implements BeforeEachCallback {
    private static final String FIELD_STATE = "state";

    public void beforeEach(ExtensionContext context) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectFields(context, instance, instance.getClass()));
    }

    public ZeebeStateExtensionState lookupOrCreate(ExtensionContext extensionContext) {
        ExtensionContext.Store store = this.getStore(extensionContext);
        return (ZeebeStateExtensionState)store.getOrComputeIfAbsent((Object)FIELD_STATE, key -> new ZeebeStateExtensionState());
    }

    private void injectFields(ExtensionContext context, Object testInstance, Class<?> testClass) {
        ReflectionUtils.findFields(testClass, field -> ReflectionUtils.isNotStatic((Member)field) && field.getType() == ZeebeDb.class, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
            try {
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, this.lookupOrCreate(context).getZeebeDb());
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
        ReflectionUtils.findFields(testClass, field -> ReflectionUtils.isNotStatic((Member)field) && field.getType() == TransactionContext.class, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
            try {
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, this.lookupOrCreate(context).getTransactionContext());
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
        ReflectionUtils.findFields(testClass, field -> ReflectionUtils.isNotStatic((Member)field) && field.getType().isAssignableFrom(MutableZeebeState.class), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
            try {
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, this.lookupOrCreate(context).getZeebeState());
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getUniqueId()}));
    }

    private static final class ZeebeStateExtensionState
    implements ExtensionContext.Store.CloseableResource {
        private Path tempFolder;
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private TransactionContext transactionContext;
        private MutableZeebeState zeebeState;

        private ZeebeStateExtensionState() {
            ZeebeDbFactory factory = DefaultZeebeDbFactory.defaultFactory();
            try {
                this.tempFolder = Files.createTempDirectory(null, new FileAttribute[0]);
                this.zeebeDb = factory.createDb(this.tempFolder.toFile());
                this.transactionContext = this.zeebeDb.createContext();
                this.zeebeState = new ZeebeDbState(this.zeebeDb, this.transactionContext);
            }
            catch (Exception e) {
                ExceptionUtils.throwAsUncheckedException((Throwable)e);
            }
        }

        public void close() throws Throwable {
            this.transactionContext.getCurrentTransaction().rollback();
            this.zeebeDb.close();
            SortedMap<Path, IOException> failures = this.clearFolder();
            if (!failures.isEmpty()) {
                this.throwException(failures);
            }
        }

        private void throwException(SortedMap<Path, IOException> failures) throws IOException {
            String joinedPaths = failures.keySet().stream().map(Path::toString).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to clear temp directory " + this.tempFolder.toAbsolutePath() + ". The following paths could not be deleted: " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            throw exception;
        }

        private SortedMap<Path, IOException> clearFolder() throws IOException {
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            Files.walkFileTree(this.tempFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    return this.delete(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.delete(dir);
                }

                private FileVisitResult delete(Path path) {
                    try {
                        Files.delete(path);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                    }
                    catch (IOException exception) {
                        try {
                            path.toFile().deleteOnExit();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        failures.put(path, exception);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return failures;
        }

        private ZeebeDb<ZbColumnFamilies> getZeebeDb() {
            return this.zeebeDb;
        }

        private MutableZeebeState getZeebeState() {
            return this.zeebeState;
        }

        private TransactionContext getTransactionContext() {
            return this.transactionContext;
        }
    }
}

