/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public final class ZeebeStateRule
extends ExternalResource {
    private final TemporaryFolder tempFolder = new TemporaryFolder();
    private final int partition;
    private ZeebeDb<ZbColumnFamilies> db;
    private MutableZeebeState zeebeState;

    public ZeebeStateRule() {
        this(1);
    }

    public ZeebeStateRule(int partition) {
        this.partition = partition;
    }

    protected void before() throws Throwable {
        this.tempFolder.create();
        this.db = this.createNewDb();
        this.zeebeState = new ZeebeDbState(this.partition, this.db, this.db.createContext());
    }

    protected void after() {
        try {
            this.db.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tempFolder.delete();
    }

    public MutableZeebeState getZeebeState() {
        return this.zeebeState;
    }

    public KeyGenerator getKeyGenerator() {
        return this.zeebeState.getKeyGenerator();
    }

    public ZeebeDb<ZbColumnFamilies> createNewDb() {
        try {
            return DefaultZeebeDbFactory.defaultFactory().createDb(this.tempFolder.newFolder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

