/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.StreamProcessorRule;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;

public final class IncidentClient {
    private final StreamProcessorRule environmentRule;

    public IncidentClient(StreamProcessorRule environmentRule) {
        this.environmentRule = environmentRule;
    }

    public ResolveIncidentClient ofInstance(long processInstanceKey) {
        return new ResolveIncidentClient(this.environmentRule, processInstanceKey);
    }

    public static class ResolveIncidentClient {
        private static final long DEFAULT_KEY = -1L;
        private final StreamProcessorRule environmentRule;
        private final long processInstanceKey;
        private final IncidentRecord incidentRecord;
        private long incidentKey = -1L;

        public ResolveIncidentClient(StreamProcessorRule environmentRule, long processInstanceKey) {
            this.environmentRule = environmentRule;
            this.processInstanceKey = processInstanceKey;
            this.incidentRecord = new IncidentRecord();
        }

        public ResolveIncidentClient withKey(long incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public Record<IncidentRecordValue> resolve() {
            if (this.incidentKey == -1L) {
                this.incidentKey = ((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(this.processInstanceKey).getFirst()).getKey();
            }
            long position = this.environmentRule.writeCommandOnPartition(Protocol.decodePartitionId((long)this.incidentKey), this.incidentKey, (Intent)IncidentIntent.RESOLVE, (UnpackedObject)this.incidentRecord);
            return (Record)((IncidentRecordStream)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(this.processInstanceKey).withRecordKey(this.incidentKey)).withSourceRecordPosition(position)).withIntent((Intent)IncidentIntent.RESOLVED)).getFirst();
        }
    }
}

