/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.StreamProcessorRule;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.test.util.record.JobBatchRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;

public final class JobActivationClient {
    private static final int DEFAULT_PARTITION = 1;
    private static final long DEFAULT_TIMEOUT = 10000L;
    private static final String DEFAULT_WORKER = "defaultWorker";
    private static final int DEFAULT_MAX_ACTIVATE = 10;
    private static final BiFunction<Integer, Long, Record<JobBatchRecordValue>> SUCCESS_EXPECTATION_SUPPLIER = (partitionId, position) -> (Record)((JobBatchRecordStream)((JobBatchRecordStream)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATED).withPartitionId(partitionId.intValue())).withSourceRecordPosition(position.longValue())).getFirst();
    private static final BiFunction<Integer, Long, Record<JobBatchRecordValue>> REJECTION_EXPECTATION_SUPPLIER = (partitionId, position) -> (Record)((JobBatchRecordStream)((JobBatchRecordStream)((JobBatchRecordStream)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATE).onlyCommandRejections()).withPartitionId(partitionId.intValue())).withSourceRecordPosition(position.longValue())).getFirst();
    private final StreamProcessorRule environmentRule;
    private final JobBatchRecord jobBatchRecord;
    private int partitionId;
    private BiFunction<Integer, Long, Record<JobBatchRecordValue>> expectation = SUCCESS_EXPECTATION_SUPPLIER;

    public JobActivationClient(StreamProcessorRule environmentRule) {
        this.environmentRule = environmentRule;
        this.jobBatchRecord = new JobBatchRecord();
        this.jobBatchRecord.setTimeout(10000L).setMaxJobsToActivate(10);
        this.partitionId = 1;
    }

    public JobActivationClient withType(String type) {
        this.jobBatchRecord.setType(type);
        return this;
    }

    public JobActivationClient withTimeout(long timeout) {
        this.jobBatchRecord.setTimeout(timeout);
        return this;
    }

    public JobActivationClient withFetchVariables(String ... fetchVariables) {
        return this.withFetchVariables(Arrays.asList(fetchVariables));
    }

    public JobActivationClient withFetchVariables(List<String> fetchVariables) {
        ValueArray variables = this.jobBatchRecord.variables();
        fetchVariables.stream().map(BufferUtil::wrapString).forEach(buffer -> ((StringValue)variables.add()).wrap(buffer));
        return this;
    }

    public JobActivationClient byWorker(String name) {
        this.jobBatchRecord.setWorker(name);
        return this;
    }

    public JobActivationClient onPartition(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public JobActivationClient withMaxJobsToActivate(int count) {
        this.jobBatchRecord.setMaxJobsToActivate(count);
        return this;
    }

    public JobActivationClient expectRejection() {
        this.expectation = REJECTION_EXPECTATION_SUPPLIER;
        return this;
    }

    public Record<JobBatchRecordValue> activate() {
        long position = this.environmentRule.writeCommandOnPartition(this.partitionId, (Intent)JobBatchIntent.ACTIVATE, (UnpackedObject)this.jobBatchRecord);
        return this.expectation.apply(this.partitionId, position);
    }
}

