/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.StreamProcessorRule;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JobClient {
    private static final long DEFAULT_KEY = -1L;
    private static final Function<Long, Record<JobRecordValue>> SUCCESS_SUPPLIER = position -> (Record)((JobRecordStream)RecordingExporter.jobRecords().withSourceRecordPosition(position.longValue())).getFirst();
    private static final Function<Long, Record<JobRecordValue>> REJECTION_SUPPLIER = position -> (Record)((JobRecordStream)((JobRecordStream)RecordingExporter.jobRecords().onlyCommandRejections()).withSourceRecordPosition(position.longValue())).getFirst();
    private final JobRecord jobRecord;
    private final StreamProcessorRule environmentRule;
    private long processInstanceKey;
    private long jobKey = -1L;
    private Function<Long, Record<JobRecordValue>> expectation = SUCCESS_SUPPLIER;

    public JobClient(StreamProcessorRule environmentRule) {
        this.environmentRule = environmentRule;
        this.jobRecord = new JobRecord();
    }

    public JobClient ofInstance(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public JobClient withType(String jobType) {
        this.jobRecord.setType(jobType);
        return this;
    }

    public JobClient withKey(long jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    public JobClient withVariables(String variables) {
        this.jobRecord.setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
        return this;
    }

    public JobClient withVariables(DirectBuffer variables) {
        this.jobRecord.setVariables(variables);
        return this;
    }

    public JobClient withVariable(String key, Object value) {
        this.jobRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
        return this;
    }

    public JobClient withVariables(Map<String, Object> variables) {
        this.jobRecord.setVariables(MsgPackUtil.asMsgPack(variables));
        return this;
    }

    public JobClient withRetries(int retries) {
        this.jobRecord.setRetries(retries);
        return this;
    }

    public JobClient withErrorMessage(String errorMessage) {
        this.jobRecord.setErrorMessage(errorMessage);
        return this;
    }

    public JobClient withErrorCode(String errorCode) {
        this.jobRecord.setErrorCode(BufferUtil.wrapString((String)errorCode));
        return this;
    }

    public JobClient expectRejection() {
        this.expectation = REJECTION_SUPPLIER;
        return this;
    }

    private long findJobKey() {
        if (this.jobKey == -1L) {
            Record createdJob = (Record)((JobRecordStream)RecordingExporter.jobRecords().withType(this.jobRecord.getType()).withIntent((Intent)JobIntent.CREATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
            return createdJob.getKey();
        }
        return this.jobKey;
    }

    public Record<JobRecordValue> complete() {
        long jobKey = this.findJobKey();
        long position = this.environmentRule.writeCommand(jobKey, (Intent)JobIntent.COMPLETE, (UnpackedObject)this.jobRecord);
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> fail() {
        long jobKey = this.findJobKey();
        long position = this.environmentRule.writeCommand(jobKey, (Intent)JobIntent.FAIL, (UnpackedObject)this.jobRecord);
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> updateRetries() {
        long jobKey = this.findJobKey();
        long position = this.environmentRule.writeCommand(jobKey, (Intent)JobIntent.UPDATE_RETRIES, (UnpackedObject)this.jobRecord);
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> throwError() {
        long jobKey = this.findJobKey();
        long position = this.environmentRule.writeCommand(jobKey, (Intent)JobIntent.THROW_ERROR, (UnpackedObject)this.jobRecord);
        return this.expectation.apply(position);
    }
}

