/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.StreamProcessorRule;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class ProcessInstanceClient {
    private final StreamProcessorRule environmentRule;

    public ProcessInstanceClient(StreamProcessorRule environmentRule) {
        this.environmentRule = environmentRule;
    }

    public ProcessInstanceCreationClient ofBpmnProcessId(String bpmnProcessId) {
        return new ProcessInstanceCreationClient(this.environmentRule, bpmnProcessId);
    }

    public ExistingInstanceClient withInstanceKey(long processInstanceKey) {
        return new ExistingInstanceClient(this.environmentRule, processInstanceKey);
    }

    public static class ExistingInstanceClient {
        public static final Function<Long, Record<ProcessInstanceRecordValue>> SUCCESS_EXPECTATION = processInstanceKey -> (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withRecordKey(processInstanceKey.longValue())).withIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED)).withProcessInstanceKey(processInstanceKey.longValue()).getFirst();
        public static final Function<Long, Record<ProcessInstanceRecordValue>> REJECTION_EXPECTATION = processInstanceKey -> (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyCommandRejections()).withIntent((Intent)ProcessInstanceIntent.CANCEL)).withRecordKey(processInstanceKey.longValue())).withProcessInstanceKey(processInstanceKey.longValue()).getFirst();
        private static final int DEFAULT_PARTITION = -1;
        private final StreamProcessorRule environmentRule;
        private final long processInstanceKey;
        private int partition = -1;
        private Function<Long, Record<ProcessInstanceRecordValue>> expectation = SUCCESS_EXPECTATION;

        public ExistingInstanceClient(StreamProcessorRule environmentRule, long processInstanceKey) {
            this.environmentRule = environmentRule;
            this.processInstanceKey = processInstanceKey;
        }

        public ExistingInstanceClient onPartition(int partition) {
            this.partition = partition;
            return this;
        }

        public ExistingInstanceClient expectRejection() {
            this.expectation = REJECTION_EXPECTATION;
            return this;
        }

        public Record<ProcessInstanceRecordValue> cancel() {
            if (this.partition == -1) {
                this.partition = ((Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).getFirst()).getPartitionId();
            }
            this.environmentRule.writeCommandOnPartition(this.partition, this.processInstanceKey, (Intent)ProcessInstanceIntent.CANCEL, (UnpackedObject)new ProcessInstanceRecord().setProcessInstanceKey(this.processInstanceKey));
            return this.expectation.apply(this.processInstanceKey);
        }
    }

    public static class ProcessInstanceCreationWithResultClient {
        private final StreamProcessorRule environmentRule;
        private final ProcessInstanceCreationRecord record;
        private long requestId = 1L;
        private int requestStreamId = 1;

        public ProcessInstanceCreationWithResultClient(StreamProcessorRule environmentRule, ProcessInstanceCreationRecord record) {
            this.environmentRule = environmentRule;
            this.record = record;
        }

        public ProcessInstanceCreationWithResultClient withFetchVariables(Set<String> fetchVariables) {
            ArrayProperty variablesToCollect = this.record.fetchVariables();
            fetchVariables.forEach(variable -> ((StringValue)variablesToCollect.add()).wrap(BufferUtil.wrapString((String)variable)));
            return this;
        }

        public ProcessInstanceCreationWithResultClient withRequestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        public ProcessInstanceCreationWithResultClient withRequestStreamId(int requestStreamId) {
            this.requestStreamId = requestStreamId;
            return this;
        }

        public long create() {
            long position = this.environmentRule.writeCommand(this.requestStreamId, this.requestId, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, (UnpackedObject)this.record);
            return ((ProcessInstanceCreationRecordValue)((Record)((ProcessInstanceCreationRecordStream)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withIntent((Intent)ProcessInstanceCreationIntent.CREATED)).withSourceRecordPosition(position)).getFirst()).getValue()).getProcessInstanceKey();
        }

        public void asyncCreate() {
            this.environmentRule.writeCommand(this.requestStreamId, this.requestId, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, (UnpackedObject)this.record);
        }
    }

    public static class ProcessInstanceCreationClient {
        private final StreamProcessorRule environmentRule;
        private final ProcessInstanceCreationRecord processInstanceCreationRecord;

        public ProcessInstanceCreationClient(StreamProcessorRule environmentRule, String bpmnProcessId) {
            this.environmentRule = environmentRule;
            this.processInstanceCreationRecord = new ProcessInstanceCreationRecord();
            this.processInstanceCreationRecord.setBpmnProcessId(bpmnProcessId);
        }

        public ProcessInstanceCreationClient withVariables(Map<String, Object> variables) {
            this.processInstanceCreationRecord.setVariables(MsgPackUtil.asMsgPack(variables));
            return this;
        }

        public ProcessInstanceCreationClient withVariables(String variables) {
            this.processInstanceCreationRecord.setVariables(MsgPackUtil.asMsgPack((String)variables));
            return this;
        }

        public ProcessInstanceCreationClient withVariable(String key, Object value) {
            this.processInstanceCreationRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
            return this;
        }

        public ProcessInstanceCreationWithResultClient withResult() {
            return new ProcessInstanceCreationWithResultClient(this.environmentRule, this.processInstanceCreationRecord);
        }

        public long create() {
            long position = this.environmentRule.writeCommand((Intent)ProcessInstanceCreationIntent.CREATE, (UnpackedObject)this.processInstanceCreationRecord);
            return ((ProcessInstanceCreationRecordValue)((Record)((ProcessInstanceCreationRecordStream)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().withIntent((Intent)ProcessInstanceCreationIntent.CREATED)).withSourceRecordPosition(position)).getFirst()).getValue()).getProcessInstanceKey();
        }
    }
}

