/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstances;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ActivityTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final BpmnModelInstance WITHOUT_BOUNDARY_EVENTS = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> ((ServiceTaskBuilder)((ServiceTaskBuilder)b.zeebeJobType("type")).zeebeInputExpression("foo", "bar")).zeebeOutputExpression("bar", "oof")).endEvent().done();
    private static final BpmnModelInstance WITH_BOUNDARY_EVENTS = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("timer1").timerWithDuration("PT10S")).endEvent().moveToActivity("task").boundaryEvent("timer2").timerWithDuration("PT20S")).endEvent().moveToActivity("task").endEvent("taskEnd").done();
    private static final BpmnModelInstance WITH_STATIC_INPUT_MAPPING = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)b.zeebeJobType("type")).zeebeInput("text", "textStatic")).zeebeInputExpression("\"text\"", "textExpression")).zeebeInput("123", "numberStatic")).zeebeInputExpression("\"123\"", "numberExpression")).zeebeInput("true", "booleanStatic")).zeebeInputExpression("\"true\"", "booleanExpression")).zeebeInput("null", "nullStatic")).zeebeInputExpression("\"null\"", "nullExpression")).zeebeInput("https://github.com/{{orgId}}/{{repoId}}", "urlStatic")).zeebeInputExpression("\"https://github.com/{{orgId}}/{{repoId}}\"", "urlExpression")).zeebeInput("My Name is \"Zeebe\", nice to meet you", "quotesStatic")).zeebeInputExpression("\"My Name is \\\"Zeebe\\\", nice to meet you\"", "quotesExpression")).endEvent().done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldApplyInputMappingOnReady() {
        ENGINE.deployment().withXmlResource(WITHOUT_BOUNDARY_EVENTS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"foo\": 1, \"boo\": 2 }").create();
        Record record = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Map variables = ProcessInstances.getCurrentVariables((long)processInstanceKey, (long)record.getPosition());
        Assertions.assertThat((Map)variables).contains(new Map.Entry[]{Assertions.entry((Object)"bar", (Object)"1")});
    }

    @Test
    public void shouldApplyStaticInputMapping() {
        ENGINE.deployment().withXmlResource(WITH_STATIC_INPUT_MAPPING).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record record = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Map variables = ProcessInstances.getCurrentVariables((long)processInstanceKey, (long)record.getPosition());
        Assertions.assertThat((Map)variables).contains(new Map.Entry[]{Assertions.entry((Object)"textStatic", (Object)"\"text\""), Assertions.entry((Object)"textExpression", (Object)"\"text\""), Assertions.entry((Object)"numberStatic", (Object)"\"123\""), Assertions.entry((Object)"numberExpression", (Object)"\"123\""), Assertions.entry((Object)"booleanStatic", (Object)"\"true\""), Assertions.entry((Object)"booleanExpression", (Object)"\"true\""), Assertions.entry((Object)"nullStatic", (Object)"\"null\""), Assertions.entry((Object)"nullExpression", (Object)"\"null\""), Assertions.entry((Object)"urlStatic", (Object)"\"https://github.com/{{orgId}}/{{repoId}}\""), Assertions.entry((Object)"urlExpression", (Object)"\"https://github.com/{{orgId}}/{{repoId}}\""), Assertions.entry((Object)"quotesStatic", (Object)"\"My Name is \\\\\\\"Zeebe\\\\\\\", nice to meet you\""), Assertions.entry((Object)"quotesExpression", (Object)"\"My Name is \\\\\\\"Zeebe\\\\\\\", nice to meet you\"")});
    }

    @Test
    public void shouldSubscribeToBoundaryEventTriggersOnReady() {
        ENGINE.deployment().withXmlResource(WITH_BOUNDARY_EVENTS).deploy();
        ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List records = ((RecordStream)((RecordStream)RecordingExporter.records().skipUntil(r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("task") && r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATING)).limit(r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("task") && r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATED)).asList();
        Assertions.assertThat((List)records).hasSize(5);
        Assertions.assertThat((List)records).extracting(Record::getIntent).contains((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, TimerIntent.CREATED, TimerIntent.CREATED, JobIntent.CREATED, ProcessInstanceIntent.ELEMENT_ACTIVATED});
    }

    @Test
    public void shouldUnsubscribeFromBoundaryEventTriggersOnCompleting() {
        ENGINE.deployment().withXmlResource(WITH_BOUNDARY_EVENTS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().withType("type").ofInstance(processInstanceKey).complete();
        this.shouldUnsubscribeFromBoundaryEventTrigger(processInstanceKey, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED);
    }

    @Test
    public void shouldUnsubscribeFromBoundaryEventTriggersOnTerminating() {
        ENGINE.deployment().withXmlResource(WITH_BOUNDARY_EVENTS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withElementId("task").withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        this.shouldUnsubscribeFromBoundaryEventTrigger(processInstanceKey, ProcessInstanceIntent.ELEMENT_TERMINATING, ProcessInstanceIntent.ELEMENT_TERMINATED);
    }

    @Test
    public void shouldIgnoreTaskHeadersIfEmpty() {
        this.createProcessAndAssertIgnoredHeaders("");
    }

    @Test
    public void shouldIgnoreTaskHeadersIfNull() {
        this.createProcessAndAssertIgnoredHeaders(null);
    }

    private void createProcessAndAssertIgnoredHeaders(String testValue) {
        BpmnModelInstance model = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").serviceTask("task1", b -> ((ServiceTaskBuilder)b.zeebeJobType("type1")).zeebeTaskHeader("key", testValue)).endEvent("end").moveToActivity("task1").serviceTask("task2", b -> ((ServiceTaskBuilder)b.zeebeJobType("type2")).zeebeTaskHeader(testValue, "value")).connectTo("end").moveToActivity("task1").serviceTask("task3", b -> ((ServiceTaskBuilder)b.zeebeJobType("type3")).zeebeTaskHeader(testValue, testValue)).connectTo("end").done();
        ENGINE.deployment().withXmlResource(model).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("type1").complete();
        ENGINE.job().ofInstance(processInstanceKey).withType("type2").complete();
        JobRecordValue thirdJob = (JobRecordValue)((Record)RecordingExporter.jobRecords().withType("type3").getFirst()).getValue();
        Assertions.assertThat((Map)thirdJob.getCustomHeaders()).isEmpty();
    }

    private void shouldUnsubscribeFromBoundaryEventTrigger(long processInstanceKey, ProcessInstanceIntent leavingState, ProcessInstanceIntent leftState) {
        List records = RecordingExporter.records().betweenProcessInstance(processInstanceKey).between(r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("task") && r.getIntent() == leavingState, r -> r.getValue() instanceof ProcessInstanceRecord && ((ProcessInstanceRecord)r.getValue()).getElementId().equals("task") && r.getIntent() == leftState).asList();
        Assertions.assertThat((List)records).extracting(Record::getIntent).contains((Object[])new Intent[]{leavingState, TimerIntent.CANCELED, TimerIntent.CANCELED, leftState});
    }
}

