/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.activity;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class UserTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    private static BpmnModelInstance process() {
        return UserTaskTest.process(b -> {});
    }

    private static BpmnModelInstance process(Consumer<UserTaskBuilder> consumer) {
        UserTaskBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("task");
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Test
    public void shouldActivateUserTask() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.USER_TASK).limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record userTask = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.USER_TASK).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)userTask.getValue())).hasElementId("task").hasBpmnElementType(BpmnElementType.USER_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey);
    }

    @Test
    public void shouldCreateJob() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record taskActivated = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.USER_TASK).getFirst();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)job.getValue())).hasType("io.camunda.zeebe:userTask").hasRetries(1).hasElementInstanceKey(taskActivated.getKey()).hasElementId(((ProcessInstanceRecordValue)taskActivated.getValue()).getElementId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)taskActivated.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)taskActivated.getValue()).getBpmnProcessId()).hasProcessDefinitionVersion(((ProcessInstanceRecordValue)taskActivated.getValue()).getVersion());
    }

    @Test
    public void shouldCreateJobWithVariables() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeInputExpression("processVariable", "taskVariable"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("processVariable", "processValue").create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        Optional<JobRecordValue> jobRecordValue = ((JobBatchRecordValue)ENGINE.jobs().withType("io.camunda.zeebe:userTask").withMaxJobsToActivate(Integer.MAX_VALUE).withTimeout(200L).activate().getValue()).getJobs().stream().filter(j -> j.getProcessInstanceKey() == processInstanceKey).findFirst();
        Assertions.assertThat(jobRecordValue).hasValueSatisfying(v -> ((MapAssert)Assertions.assertThat((Map)v.getVariables()).containsEntry((Object)"processVariable", (Object)"processValue")).containsEntry((Object)"taskVariable", (Object)"processValue"));
    }

    @Test
    public void shouldCreateJobWithProcessInstanceAndCustomHeaders() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> ((UserTaskBuilder)t.zeebeTaskHeader("a", "b")).zeebeTaskHeader("c", "d"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(2)).containsEntry((Object)"a", (Object)"b")).containsEntry((Object)"c", (Object)"d");
    }

    @Test
    public void shouldCreateJobWithFormKeyHeader() {
        String formKey = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeUserTaskForm(formKey, "User Task Form"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:formKey", (Object)String.format("%s:%s:%s", "camunda-forms", "bpmn", formKey));
    }

    @Test
    public void shouldCreateJobWithFormKeyHeaderAndCustomHeaders() {
        String formKey = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> ((UserTaskBuilder)((UserTaskBuilder)t.zeebeUserTaskForm(formKey, "User Task Form")).zeebeTaskHeader("a", "b")).zeebeTaskHeader("c", "d"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(3)).containsEntry((Object)"io.camunda.zeebe:formKey", (Object)String.format("%s:%s:%s", "camunda-forms", "bpmn", formKey))).containsEntry((Object)"a", (Object)"b")).containsEntry((Object)"c", (Object)"d");
    }

    @Test
    public void shouldCreateJobWithAssigneeHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeAssignee("alice"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:assignee", (Object)"alice");
    }

    @Test
    public void shouldCreateJobWithEvaluatedAssigneeExpressionHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeAssigneeExpression("user"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("user", "alice")).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:assignee", (Object)"alice");
    }

    @Test
    public void shouldCreateJobAndIgnoreEmptyEvaluatedAssigneeExpressionHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeAssigneeExpression("user"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("user", "")).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(0)).doesNotContainKey((Object)"io.camunda.zeebe:assignee");
    }

    @Test
    public void shouldCreateJobWithCandidateGroupsHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeCandidateGroups("alice,bob"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:candidateGroups", (Object)"[\"alice\",\"bob\"]");
    }

    @Test
    public void shouldCreateJobWithEvaluatedCandidateGroupsExpressionHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeCandidateGroupsExpression("users"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"users\": [\"alice\", \"bob\"] }").create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:candidateGroups", (Object)"[\"alice\",\"bob\"]");
    }

    @Test
    public void shouldCreateJobWithCandidateUsersHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeCandidateUsers("jack,rose"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:candidateUsers", (Object)"[\"jack\",\"rose\"]");
    }

    @Test
    public void shouldCreateJobWithEvaluatedCandidateUsersExpressionHeader() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeCandidateUsersExpression("users"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables("{ \"users\": [\"jack\", \"rose\"] }").create();
        Record job = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Map customHeaders = ((JobRecordValue)job.getValue()).getCustomHeaders();
        ((MapAssert)Assertions.assertThat((Map)customHeaders).hasSize(1)).containsEntry((Object)"io.camunda.zeebe:candidateUsers", (Object)"[\"jack\",\"rose\"]");
    }

    @Test
    public void shouldCompleteUserTask() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("io.camunda.zeebe:userTask").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SEQUENCE_FLOW, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldResolveIncidentsWhenTerminating() {
        ENGINE.deployment().withXmlResource(UserTaskTest.process(t -> t.zeebeInputExpression("nonexisting_variable", "target"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("foo", 10).create();
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).limit(1L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED});
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
    }
}

