/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ExclusiveGatewayTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldSplitOnExclusiveGateway() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractExclusiveGatewayBuilder)((AbstractGatewayBuilder)((AbstractGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("foo < 5")).endEvent("a").moveToLastGateway().sequenceFlowId("s2")).conditionExpression("foo >= 5 and foo < 10")).endEvent("b").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s3")).endEvent("c").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstance1 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 4).create();
        long processInstance2 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 8).create();
        long processInstance3 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 12).create();
        List<Long> processInstanceKeys = Arrays.asList(processInstance1, processInstance2, processInstance3);
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).valueFilter(r -> processInstanceKeys.contains(r.getProcessInstanceKey()))).withElementType(BpmnElementType.END_EVENT).limit(3L)).extracting(Record::getValue).extracting(v -> Assertions.tuple((Object[])new Object[]{v.getProcessInstanceKey(), v.getElementId()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processInstance1, "a"}), Assertions.tuple((Object[])new Object[]{processInstance2, "b"}), Assertions.tuple((Object[])new Object[]{processInstance3, "c"})});
    }

    @Test
    public void shouldJoinOnExclusiveGateway() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("split").sequenceFlowId("s1")).conditionExpression("foo < 5")).exclusiveGateway("joinRequest").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s2")).connectTo("joinRequest").endEvent("end").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstance1 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 4).create();
        long processInstance2 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 8).create();
        List takenSequenceFlows = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN)).withProcessInstanceKey(processInstance1).limit(3L)).map(s -> ((ProcessInstanceRecordValue)s.getValue()).getElementId()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(takenSequenceFlows).contains((Object[])new String[]{"s1"})).doesNotContain((Object[])new String[]{"s2"});
        takenSequenceFlows = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN)).withProcessInstanceKey(processInstance2).limit(3L)).map(s -> ((ProcessInstanceRecordValue)s.getValue()).getElementId()).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(takenSequenceFlows).contains((Object[])new String[]{"s2"})).doesNotContain((Object[])new String[]{"s1"});
    }

    @Test
    public void shouldSetSourceRecordPositionCorrectOnJoinXor() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("split").sequenceFlowId("s1")).conditionExpression("foo < 5")).exclusiveGateway("joinRequest").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s2")).connectTo("joinRequest").endEvent("end").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstance1 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 4).create();
        List sequenceFlows = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN)).withProcessInstanceKey(processInstance1).limit(3L)).asList();
        List gateWays = ((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT)).withElementType(BpmnElementType.EXCLUSIVE_GATEWAY).withProcessInstanceKey(processInstance1).limit(2L)).asList();
        Assertions.assertThat((long)((Record)gateWays.get(0)).getSourceRecordPosition()).isEqualTo(((Record)sequenceFlows.get(0)).getSourceRecordPosition());
        Assertions.assertThat((long)((Record)gateWays.get(1)).getSourceRecordPosition()).isEqualTo(((Record)sequenceFlows.get(1)).getSourceRecordPosition());
        Assertions.assertThat((String)((ProcessInstanceRecordValue)((Record)sequenceFlows.get(1)).getValue()).getElementId()).isEqualTo("s1");
        long processInstance2 = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 8).create();
        sequenceFlows = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN)).withProcessInstanceKey(processInstance2).limit(3L)).collect(Collectors.toList());
        gateWays = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT)).withElementType(BpmnElementType.EXCLUSIVE_GATEWAY).withProcessInstanceKey(processInstance2).limit(2L)).collect(Collectors.toList());
        Assertions.assertThat((long)((Record)gateWays.get(0)).getSourceRecordPosition()).isEqualTo(((Record)sequenceFlows.get(0)).getSourceRecordPosition());
        Assertions.assertThat((long)((Record)gateWays.get(1)).getSourceRecordPosition()).isEqualTo(((Record)sequenceFlows.get(1)).getSourceRecordPosition());
        Assertions.assertThat((String)((ProcessInstanceRecordValue)((Record)sequenceFlows.get(1)).getValue()).getElementId()).isEqualTo("s2");
    }

    @Test
    public void testProcessInstanceStatesWithExclusiveGateway() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("foo < 5")).endEvent("a").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s2")).endEvent("b").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 4).create();
        List processEvents = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("xor"))).limitToProcessInstanceCompleted().asList();
        Assertions.assertThat((List)processEvents).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ACTIVATE_ELEMENT, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, ProcessInstanceIntent.ACTIVATE_ELEMENT, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.COMPLETE_ELEMENT, ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
    }

    @Test
    public void shouldSplitIfDefaultFlowIsDeclaredFirst() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway().defaultFlow()).endEvent("a").moveToLastExclusiveGateway().conditionExpression("foo < 5")).endEvent("b").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 10).create();
        List completedEvents = (List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).withElementType(BpmnElementType.END_EVENT).collect(Collectors.toList());
        Assertions.assertThat((List)completedEvents).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsExactly((Object[])new String[]{"a"});
    }

    @Test
    public void shouldEndScopeIfGatewayHasNoOutgoingFlows() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 10).create();
        List completedEvents = (List)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).skipUntil(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("xor"))).limitToProcessInstanceCompleted().collect(Collectors.toList());
        Assertions.assertThat((List)completedEvents).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.EXCLUSIVE_GATEWAY, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EXCLUSIVE_GATEWAY, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EXCLUSIVE_GATEWAY, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EXCLUSIVE_GATEWAY, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldResolveIncidentsWhenTerminating() {
        String processId = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource(((AbstractGatewayBuilder)((AbstractGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).defaultFlow()).endEvent("default-end").moveToLastGateway().sequenceFlowId("s2")).conditionExpression("nonexisting_variable")).endEvent("non-default-end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("foo", 10).create();
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).limit(1L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED});
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceTerminated()).extracting(r -> Assertions.tuple((Object[])new Object[]{((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), r.getIntent()})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EXCLUSIVE_GATEWAY, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.EXCLUSIVE_GATEWAY, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED})});
        Assertions.assertThat((Stream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
    }

    @Test
    public void shouldCreateDeploymentExclusiveGatewayWithDefaultFlow() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition1 = ((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s2")).endEvent("end2").done();
        Record<DeploymentRecordValue> deployment1 = ENGINE.deployment().withXmlResource(processDefinition1).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment1.getKey()).describedAs("Exclusive gateway's default flow should be allowed to have no condition", new Object[0])).isNotNegative();
        BpmnModelInstance processDefinition2 = ((AbstractExclusiveGatewayBuilder)((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("end2").done();
        Record<DeploymentRecordValue> deployment2 = ENGINE.deployment().withXmlResource(processDefinition2).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment2.getKey()).describedAs("Exclusive gateway's default flow should be allowed to have a condition, but not be required", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldNotEvaluateConditionOfDefaultFlow() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((AbstractExclusiveGatewayBuilder)((AbstractExclusiveGatewayBuilder)((AbstractGatewayBuilder)((AbstractGatewayBuilder)((ExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().exclusiveGateway("xor").sequenceFlowId("s1")).conditionExpression("= contains(str,\"a\")")).endEvent("end1").moveToLastGateway().sequenceFlowId("s2")).conditionExpression("= contains(str,\"b\")")).endEvent("end2").moveToLastExclusiveGateway().defaultFlow().sequenceFlowId("s3")).conditionExpression("= nonexisting_variable")).endEvent("end3").done();
        ENGINE.deployment().withXmlResource(processDefinition).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariable("str", "d").create();
        ((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey)).describedAs("Expect that the default flow is taken", new Object[0])).satisfies(new ThrowingConsumer[]{record -> Assertions.assertThat(record.stream().filter(r -> r.getValueType() == ValueType.PROCESS_INSTANCE)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"xor", ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{"s3", ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN}), Assertions.tuple((Object[])new Object[]{"end3", ProcessInstanceIntent.ELEMENT_COMPLETED})})})).describedAs("Expect that the default flow's condition `= nonexisting_variable` is not evaluated and no incident is created", new Object[0])).satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((List)r).extracting(Record::getIntent).doesNotContain((Object[])new Intent[]{IncidentIntent.CREATED})});
    }
}

