/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.el.EvaluationContext;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.test.util.asserts.EitherAssert;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class ExpressionProcessorTest {
    private static final ExpressionLanguage EXPRESSION_LANGUAGE = ExpressionLanguageFactory.createExpressionLanguage();
    private static final EvaluationContext EMPTY_LOOKUP = x -> null;
    private static final ExpressionProcessor.EvaluationContextLookup DEFAULT_CONTEXT_LOOKUP = scope -> EMPTY_LOOKUP;

    ExpressionProcessorTest() {
    }

    @Nested
    @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
    class EvaluateArrayOfStringsExpressionTest {
        EvaluateArrayOfStringsExpressionTest() {
        }

        @ParameterizedTest
        @MethodSource(value={"arrayOfStringsExpressions"})
        void testSuccessfulEvaluations(String expression, List<String> expected) {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression(expression);
            EitherAssert.assertThat((Either)processor.evaluateArrayOfStringsExpression(parsedExpression, -1L)).isRight().extracting(Either::get).isEqualTo(expected);
        }

        @ParameterizedTest
        @MethodSource(value={"notArrayOfStringsExpressions"})
        void testFailingEvaluations(String expression, String message) {
            ExpressionProcessor processor = new ExpressionProcessor(EXPRESSION_LANGUAGE, DEFAULT_CONTEXT_LOOKUP);
            Expression parsedExpression = EXPRESSION_LANGUAGE.parseExpression(expression);
            EitherAssert.assertThat((Either)processor.evaluateArrayOfStringsExpression(parsedExpression, -1L)).isLeft().extracting(Either::getLeft).extracting(Failure::getMessage).isEqualTo((Object)message);
        }

        Stream<Arguments> arrayOfStringsExpressions() {
            return Stream.of(Arguments.of((Object[])new Object[]{"= []", List.of()}), Arguments.of((Object[])new Object[]{"= [\"a\"]", List.of("a")}), Arguments.of((Object[])new Object[]{"= [\"a\",\"b\"]", List.of("a", "b")}));
        }

        Stream<Arguments> notArrayOfStringsExpressions() {
            return Stream.of(Arguments.of((Object[])new Object[]{"= \"a\"", "Expected result of the expression ' \"a\"' to be 'ARRAY', but was 'STRING'."}), Arguments.of((Object[])new Object[]{"= 1", "Expected result of the expression ' 1' to be 'ARRAY', but was 'NUMBER'."}), Arguments.of((Object[])new Object[]{"= {}", "Expected result of the expression ' {}' to be 'ARRAY', but was 'OBJECT'."}), Arguments.of((Object[])new Object[]{"[]", "Expected result of the expression '[]' to be 'ARRAY', but was 'STRING'."}), Arguments.of((Object[])new Object[]{"= [1,2,3]", "Expected result of the expression ' [1,2,3]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item."}), Arguments.of((Object[])new Object[]{"= [{},{}]", "Expected result of the expression ' [{},{}]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item."}), Arguments.of((Object[])new Object[]{"= [null]", "Expected result of the expression ' [null]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item."}));
        }
    }
}

