/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.DeploymentDistributionRecordStream;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CreateDeploymentMultiplePartitionsTest {
    public static final String PROCESS_ID = "process";
    public static final int PARTITION_ID = 1;
    public static final int PARTITION_COUNT = 3;
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.multiplePartition(3);
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
    private static final BpmnModelInstance PROCESS_2 = Bpmn.createExecutableProcess((String)"process2").startEvent().endEvent().done();
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_V2 = "/dmn/decision-table_v2.dmn";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCreateDeploymentOnAllPartitions() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldCreateDeploymentOnAllPartitions").startEvent().endEvent().done();
        BpmnModelInstance secondNoopModel = Bpmn.createExecutableProcess((String)"shouldCreateDeploymentOnAllPartitionsSecondNoopDeployment").startEvent().endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", modelInstance).deploy();
        Record<DeploymentRecordValue> secondDeployment = ENGINE.deployment().withXmlResource("secondNoopModel.bpmn", secondNoopModel).deploy();
        Assertions.assertThat((long)deployment.getKey()).isNotNegative();
        Assertions.assertThat((int)deployment.getPartitionId()).isEqualTo(1);
        Assertions.assertThat((Comparable)deployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        List deploymentRecords = (List)((RecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == DeploymentIntent.FULLY_DISTRIBUTED && r.getKey() == secondDeployment.getKey())).withRecordKey(deployment.getKey())).collect(Collectors.toList());
        List listOfFullyDistributed = deploymentRecords.stream().filter(r -> r.getIntent() == DeploymentIntent.FULLY_DISTRIBUTED).collect(Collectors.toList());
        Assertions.assertThat(listOfFullyDistributed).hasSize(1);
        Record fullyDistributedDeployment = (Record)listOfFullyDistributed.get(0);
        Assertions.assertThat((long)fullyDistributedDeployment.getKey()).isNotNegative();
        Assertions.assertThat((int)fullyDistributedDeployment.getPartitionId()).isEqualTo(1);
        Assertions.assertThat((Comparable)fullyDistributedDeployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)fullyDistributedDeployment.getIntent()).isEqualTo((Object)DeploymentIntent.FULLY_DISTRIBUTED);
        Assertions.assertThat((long)deploymentRecords.stream().filter(r -> r.getIntent() == DeploymentIntent.DISTRIBUTE).count()).isEqualTo(2L);
        Assertions.assertThat((long)deploymentRecords.stream().filter(r -> r.getIntent() == DeploymentDistributionIntent.DISTRIBUTING).count()).isEqualTo(2L);
        Assertions.assertThat((long)deploymentRecords.stream().filter(r -> r.getIntent() == DeploymentDistributionIntent.COMPLETE).count()).isEqualTo(2L);
        ENGINE.getPartitionIds().forEach(partitionId -> {
            if (1 == partitionId) {
                return;
            }
            this.assertDeploymentEventResources((int)partitionId, DeploymentIntent.DISTRIBUTED, deployment.getKey(), createdDeployment -> this.assertDeploymentRecord(deployment, (Record<DeploymentRecordValue>)createdDeployment));
        });
    }

    private void assertDeploymentRecord(Record<DeploymentRecordValue> deployment, Record<DeploymentRecordValue> createdDeployment) {
        DeploymentResource resource = (DeploymentResource)((DeploymentRecordValue)createdDeployment.getValue()).getResources().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DeploymentResource)resource).hasResource(this.bpmnXml(PROCESS));
        List deployedProcesses = ((DeploymentRecordValue)createdDeployment.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).hasSize(1);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessMetadataValue)((ProcessMetadataValue)deployedProcesses.get(0))).hasBpmnProcessId("shouldCreateDeploymentOnAllPartitions").hasVersion(1).hasProcessDefinitionKey(this.getDeployedProcess(deployment, 0).getProcessDefinitionKey()).hasResourceName("process.bpmn");
    }

    @Test
    public void shouldOnlyDistributeFromDeploymentPartition() {
        long deploymentKey1 = ENGINE.deployment().withXmlResource(PROCESS).deploy().getKey();
        List deploymentRecords = ((DeploymentDistributionRecordStream)((DeploymentDistributionRecordStream)((DeploymentDistributionRecordStream)RecordingExporter.deploymentDistributionRecords().withRecordKey(deploymentKey1)).withIntent((Intent)DeploymentDistributionIntent.DISTRIBUTING)).limit(2L)).asList();
        Assertions.assertThat((List)deploymentRecords).hasSize(2);
        Assertions.assertThat((List)deploymentRecords).extracting(Record::getValue).extracting(DeploymentDistributionRecordValue::getPartitionId).doesNotContain((Object[])new Integer[]{1});
    }

    @Test
    public void shouldWriteDistributingRecordsForOtherPartitions() {
        long deploymentKey = ENGINE.deployment().withXmlResource(PROCESS).deploy().getKey();
        List deploymentDistributionRecords = ((DeploymentDistributionRecordStream)((DeploymentDistributionRecordStream)RecordingExporter.deploymentDistributionRecords().withIntent((Intent)DeploymentDistributionIntent.DISTRIBUTING)).limit(2L)).asList();
        Assertions.assertThat((List)deploymentDistributionRecords).extracting(Record::getKey).containsOnly((Object[])new Long[]{deploymentKey});
        Assertions.assertThat((List)deploymentDistributionRecords).extracting(Record::getPartitionId).containsOnly((Object[])new Integer[]{1});
        Assertions.assertThat((List)deploymentDistributionRecords).extracting(Record::getValue).extracting(DeploymentDistributionRecordValue::getPartitionId).containsExactly((Object[])new Integer[]{2, 3});
    }

    @Test
    public void shouldCreateDeploymentResourceWithMultipleProcesses() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).withXmlResource("process2.bpmn", PROCESS_2).deploy();
        Assertions.assertThat((Comparable)deployment.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
        List distributedDeployments = ((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.DISTRIBUTED)).withRecordKey(deployment.getKey())).limit(2L)).asList();
        ((ListAssert)Assertions.assertThat((List)distributedDeployments).hasSize(2)).extracting(Record::getValue).flatExtracting(DeploymentRecordValue::getProcessesMetadata).extracting(ProcessMetadataValue::getBpmnProcessId).containsOnly((Object[])new String[]{PROCESS_ID, "process2"});
    }

    @Test
    public void shouldIncrementProcessVersions() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldIncrementProcessVersions").startEvent().endEvent().done();
        Record<DeploymentRecordValue> firstDeployment = ENGINE.deployment().withXmlResource("process1.bpmn", modelInstance).deploy();
        Record<DeploymentRecordValue> secondDeployment = ENGINE.deployment().withXmlResource("process2.bpmn", modelInstance).deploy();
        Record firstCreatedDeployment = (Record)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.CREATED)).withRecordKey(firstDeployment.getKey())).getFirst();
        List deployedProcesses = ((DeploymentRecordValue)firstCreatedDeployment.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).flatExtracting(new ThrowingExtractor[]{ProcessMetadataValue::getVersion}).containsOnly(new Object[]{1});
        Record secondCreatedDeployments = (Record)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)DeploymentIntent.CREATED)).withRecordKey(secondDeployment.getKey())).getFirst();
        deployedProcesses = ((DeploymentRecordValue)secondCreatedDeployments.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).flatExtracting(new ThrowingExtractor[]{ProcessMetadataValue::getVersion}).containsOnly(new Object[]{2});
    }

    @Test
    public void shouldFilterDuplicateProcess() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<ProcessMetadataValue> repeatedWfs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (ProcessMetadataValue)((DeploymentRecordValue)r.getValue()).getProcessesMetadata().get(0)).collect(Collectors.toList());
        Assertions.assertThat((int)repeatedWfs.size()).isEqualTo(2);
        repeatedWfs.forEach(repeatedWf -> this.assertSameProcess((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedWf));
    }

    @Test
    public void shouldNotFilterDifferentProcesses() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process.bpmn", PROCESS).deploy();
        BpmnModelInstance sameBpmnIdModel = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process.bpmn", sameBpmnIdModel).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        this.assertDifferentProcesses((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedProcesses.get(0));
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<ProcessMetadataValue> repeatedWfs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (ProcessMetadataValue)((DeploymentRecordValue)r.getValue()).getProcessesMetadata().get(0)).collect(Collectors.toList());
        Assertions.assertThat((int)repeatedWfs.size()).isEqualTo(2);
        repeatedWfs.forEach(repeatedWf -> this.assertDifferentProcesses((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedWf));
    }

    @Test
    public void shouldFilterDuplicateDmnResource() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalDecision = ((DeploymentRecordValue)original.getValue()).getDecisionsMetadata();
        List originalDrg = ((DeploymentRecordValue)original.getValue()).getDecisionRequirementsMetadata();
        List repeatedDecision = ((DeploymentRecordValue)repeated.getValue()).getDecisionsMetadata();
        List repeatedDrg = ((DeploymentRecordValue)repeated.getValue()).getDecisionRequirementsMetadata();
        Assertions.assertThat((int)repeatedDecision.size()).isEqualTo(originalDecision.size()).isOne();
        Assertions.assertThat((int)repeatedDrg.size()).isEqualTo(originalDrg.size()).isOne();
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<DecisionRecordValue> repeatedDecisions = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRecordValue)((DeploymentRecordValue)r.getValue()).getDecisionsMetadata().get(0)).collect(Collectors.toList());
        Assertions.assertThat((int)repeatedDecisions.size()).isEqualTo(2);
        repeatedDecisions.forEach(r -> this.assertSameDecision((DecisionRecordValue)originalDecision.get(0), (DecisionRecordValue)r));
        List<DecisionRequirementsMetadataValue> repeatedDrgs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRequirementsMetadataValue)((DeploymentRecordValue)r.getValue()).getDecisionRequirementsMetadata().get(0)).collect(Collectors.toList());
        Assertions.assertThat((int)repeatedDrgs.size()).isEqualTo(2);
        repeatedDrgs.forEach(r -> this.assertSameDrg((DecisionRequirementsMetadataValue)originalDrg.get(0), (DecisionRequirementsMetadataValue)r));
    }

    @Test
    public void shouldNotFilterDifferentDmnResource() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlClasspathResource(DMN_DECISION_TABLE_V2).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalDecision = ((DeploymentRecordValue)original.getValue()).getDecisionsMetadata();
        List originalDrg = ((DeploymentRecordValue)original.getValue()).getDecisionRequirementsMetadata();
        List repeatedDecision = ((DeploymentRecordValue)repeated.getValue()).getDecisionsMetadata();
        List repeatedDrg = ((DeploymentRecordValue)repeated.getValue()).getDecisionRequirementsMetadata();
        Assertions.assertThat((int)repeatedDecision.size()).isEqualTo(originalDecision.size()).isOne();
        Assertions.assertThat((int)repeatedDrg.size()).isEqualTo(originalDrg.size()).isOne();
        Assertions.assertThat((long)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTE).withRecordKey(repeated.getKey())).limit(2L)).count()).isEqualTo(2L);
        List<DecisionRecordValue> repeatedDecisions = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRecordValue)((DeploymentRecordValue)r.getValue()).getDecisionsMetadata().get(0)).collect(Collectors.toList());
        Assertions.assertThat((int)repeatedDecisions.size()).isEqualTo(2);
        repeatedDecisions.forEach(r -> this.assertDifferentDecision((DecisionRecordValue)originalDecision.get(0), (DecisionRecordValue)r));
        List<DecisionRequirementsMetadataValue> repeatedDrgs = ((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords((DeploymentIntent)DeploymentIntent.DISTRIBUTED).withRecordKey(repeated.getKey())).limit(2L)).map(r -> (DecisionRequirementsMetadataValue)((DeploymentRecordValue)r.getValue()).getDecisionRequirementsMetadata().get(0)).collect(Collectors.toList());
        Assertions.assertThat((int)repeatedDrgs.size()).isEqualTo(2);
        repeatedDrgs.forEach(r -> this.assertDifferentDrg((DecisionRequirementsMetadataValue)originalDrg.get(0), (DecisionRequirementsMetadataValue)r));
    }

    private void assertSameProcess(ProcessMetadataValue original, ProcessMetadataValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessMetadataValue)repeated).hasVersion(original.getVersion()).hasProcessDefinitionKey(original.getProcessDefinitionKey()).hasResourceName(original.getResourceName()).hasBpmnProcessId(original.getBpmnProcessId());
    }

    private void assertDifferentProcesses(ProcessMetadataValue original, ProcessMetadataValue repeated) {
        Assertions.assertThat((long)original.getProcessDefinitionKey()).isLessThan(repeated.getProcessDefinitionKey());
        Assertions.assertThat((int)original.getVersion()).isLessThan(repeated.getVersion());
    }

    private void assertSameDecision(DecisionRecordValue original, DecisionRecordValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRecordValue)repeated).hasDecisionId(original.getDecisionId()).hasDecisionName(original.getDecisionName()).hasVersion(original.getVersion()).hasDecisionKey(original.getDecisionKey()).hasDecisionRequirementsId(original.getDecisionRequirementsId()).hasDecisionRequirementsKey(original.getDecisionRequirementsKey());
    }

    private void assertDifferentDecision(DecisionRecordValue original, DecisionRecordValue repeated) {
        Assertions.assertThat((int)original.getVersion()).isLessThan(repeated.getVersion());
        Assertions.assertThat((long)original.getDecisionKey()).isLessThan(repeated.getDecisionKey());
        Assertions.assertThat((long)original.getDecisionRequirementsKey()).isLessThan(repeated.getDecisionRequirementsKey());
    }

    private void assertSameDrg(DecisionRequirementsMetadataValue original, DecisionRequirementsMetadataValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionRequirementsMetadataValue)repeated).hasDecisionRequirementsId(original.getDecisionRequirementsId()).hasDecisionRequirementsName(original.getDecisionRequirementsName()).hasDecisionRequirementsVersion(original.getDecisionRequirementsVersion()).hasDecisionRequirementsKey(original.getDecisionRequirementsKey()).hasNamespace(original.getNamespace()).hasResourceName(original.getResourceName()).hasChecksum(original.getChecksum());
    }

    private void assertDifferentDrg(DecisionRequirementsMetadataValue original, DecisionRequirementsMetadataValue repeated) {
        Assertions.assertThat((int)original.getDecisionRequirementsVersion()).isLessThan(repeated.getDecisionRequirementsVersion());
        Assertions.assertThat((long)original.getDecisionRequirementsKey()).isLessThan(repeated.getDecisionRequirementsKey());
    }

    private byte[] bpmnXml(BpmnModelInstance definition) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream((OutputStream)outStream, (BpmnModelInstance)definition);
        return outStream.toByteArray();
    }

    private ProcessMetadataValue getDeployedProcess(Record<DeploymentRecordValue> record, int offset) {
        return (ProcessMetadataValue)((DeploymentRecordValue)record.getValue()).getProcessesMetadata().get(offset);
    }

    private void assertDeploymentEventResources(int expectedPartition, DeploymentIntent deploymentIntent, long expectedKey, Consumer<Record<DeploymentRecordValue>> deploymentAssert) {
        Record deploymentCreatedEvent = (Record)((DeploymentRecordStream)((DeploymentRecordStream)((DeploymentRecordStream)RecordingExporter.deploymentRecords().withPartitionId(expectedPartition)).withIntent((Intent)deploymentIntent)).withRecordKey(expectedKey)).getFirst();
        Assertions.assertThat((long)deploymentCreatedEvent.getKey()).isEqualTo(expectedKey);
        Assertions.assertThat((int)deploymentCreatedEvent.getPartitionId()).isEqualTo(expectedPartition);
        deploymentAssert.accept((Record<DeploymentRecordValue>)deploymentCreatedEvent);
    }
}

