/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.MessageEventDefinitionBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.ProcessRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class CreateDeploymentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String NONE_EXECUTABLE_POOLS = "/processes/non-executable-process-pools.bpmn";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private String processId;
    private String processId2;
    private BpmnModelInstance process;
    private BpmnModelInstance process2;
    private BpmnModelInstance process_V2;
    private BpmnModelInstance process2_V2;

    private BpmnModelInstance createProcess(String processId, String startEventId) {
        return Bpmn.createExecutableProcess((String)processId).startEvent(startEventId).endEvent().done();
    }

    @Before
    public void init() {
        this.processId = Strings.newRandomValidBpmnId();
        this.processId2 = Strings.newRandomValidBpmnId();
        this.process = this.createProcess(this.processId, "v1");
        this.process2 = this.createProcess(this.processId2, "v1");
        this.process_V2 = this.createProcess(this.processId, "v2");
        this.process2_V2 = this.createProcess(this.processId2, "v2");
    }

    @Test
    public void shouldCreateDeploymentWithBpmnXml() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(this.process).deploy();
        Assertions.assertThat((long)deployment.getKey()).isNotNegative();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deployment).hasPartitionId(1).hasRecordType(RecordType.EVENT).hasIntent((Intent)DeploymentIntent.CREATED);
    }

    @Test
    public void testLifecycle() {
        ENGINE.deployment().withXmlResource(this.process).deploy();
        List deploymentPartitionRecords = (List)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == DeploymentIntent.FULLY_DISTRIBUTED)).collect(Collectors.toList());
        Assertions.assertThat((List)deploymentPartitionRecords).extracting(new Function[]{Record::getIntent, Record::getRecordType}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATE, RecordType.COMMAND}), Assertions.tuple((Object[])new Object[]{ProcessIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.FULLY_DISTRIBUTED, RecordType.EVENT})});
    }

    @Test
    public void testLifecycleOfDuplicateDeployment() {
        ENGINE.deployment().withXmlResource(this.process).deploy();
        Record<DeploymentRecordValue> duplicatedDeployment = ENGINE.deployment().withXmlResource(this.process).deploy();
        List deploymentRecords = (List)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == DeploymentIntent.FULLY_DISTRIBUTED)).collect(Collectors.toList());
        Assertions.assertThat((List)deploymentRecords).extracting(new Function[]{Record::getIntent, Record::getRecordType}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATE, RecordType.COMMAND}), Assertions.tuple((Object[])new Object[]{ProcessIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.FULLY_DISTRIBUTED, RecordType.EVENT})});
        List duplicatedDeploymentRecords = (List)((RecordStream)((RecordStream)RecordingExporter.records().skipUntil(r -> r.getIntent() == DeploymentIntent.CREATE && r.getPosition() == duplicatedDeployment.getSourceRecordPosition())).limit(r -> r.getIntent() == DeploymentIntent.FULLY_DISTRIBUTED)).collect(Collectors.toList());
        Assertions.assertThat((List)duplicatedDeploymentRecords).extracting(new Function[]{Record::getIntent, Record::getRecordType}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATE, RecordType.COMMAND}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.CREATED, RecordType.EVENT}), Assertions.tuple((Object[])new Object[]{DeploymentIntent.FULLY_DISTRIBUTED, RecordType.EVENT})});
    }

    @Test
    public void shouldCreateDeploymentWithProcessWhichHaveUniqueKeys() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(process).deploy();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long deploymentKey = deployment.getKey();
        Assertions.assertThat((long)processDefinitionKey).isNotEqualTo(deploymentKey);
    }

    @Test
    public void shouldReturnDeployedProcessDefinitions() {
        Record<DeploymentRecordValue> firstDeployment = ENGINE.deployment().withXmlResource("wf1.bpmn", this.process).deploy();
        Record<DeploymentRecordValue> secondDeployment = ENGINE.deployment().withXmlResource("wf2.bpmn", this.process).deploy();
        List deployedProcesses = ((DeploymentRecordValue)firstDeployment.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).hasSize(1);
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)deployedProcesses.get(0);
        Assertions.assertThat((String)deployedProcess.getBpmnProcessId()).isEqualTo(this.processId);
        Assertions.assertThat((String)deployedProcess.getResourceName()).isEqualTo("wf1.bpmn");
        deployedProcesses = ((DeploymentRecordValue)secondDeployment.getValue()).getProcessesMetadata();
        Assertions.assertThat((List)deployedProcesses).hasSize(1);
        deployedProcess = (ProcessMetadataValue)deployedProcesses.get(0);
        Assertions.assertThat((String)deployedProcess.getBpmnProcessId()).isEqualTo(this.processId);
        Assertions.assertThat((String)deployedProcess.getResourceName()).isEqualTo("wf2.bpmn");
    }

    @Test
    public void shouldCreateDeploymentResourceWithCollaboration() {
        InputStream resourceAsStream = this.getClass().getResourceAsStream("/processes/collaboration.bpmn");
        BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)resourceAsStream);
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("collaboration.bpmn", modelInstance).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata()).extracting(ProcessMetadataValue::getBpmnProcessId).contains((Object[])new String[]{"process1", "process2"});
    }

    @Test
    public void shouldCreateDeploymentResourceWithMultipleProcesses() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", this.process).withXmlResource("process2.bpmn", this.process2).deploy();
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata()).extracting(ProcessMetadataValue::getBpmnProcessId).contains((Object[])new String[]{this.processId, this.processId2});
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getResources()).extracting(DeploymentResource::getResourceName).contains((Object[])new String[]{"process.bpmn", "process2.bpmn"});
        Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getResources()).extracting(DeploymentResource::getResource).contains((Object[])new byte[][]{Bpmn.convertToString((BpmnModelInstance)this.process).getBytes(), Bpmn.convertToString((BpmnModelInstance)this.process2).getBytes()});
    }

    @Test
    public void shouldWriteProcessRecordsOnDeployment() {
        DeploymentRecordValue deployment = (DeploymentRecordValue)ENGINE.deployment().withXmlResource("process.bpmn", this.process).withXmlResource("process2.bpmn", this.process2).deploy().getValue();
        List processDefinitionKeyList = deployment.getProcessesMetadata().stream().map(ProcessMetadataValue::getProcessDefinitionKey).collect(Collectors.toList());
        List processRecordKeys = ((ProcessRecordStream)RecordingExporter.processRecords().limit(2L)).map(Record::getKey).collect(Collectors.toList());
        Assertions.assertThat(processDefinitionKeyList).hasSameElementsAs(processRecordKeys);
        Record firstProcessRecord = (Record)RecordingExporter.processRecords().withBpmnProcessId(this.processId).getFirst();
        Assertions.assertThat((Object)firstProcessRecord).isNotNull();
        Assertions.assertThat((String)((Process)firstProcessRecord.getValue()).getResourceName()).isEqualTo("process.bpmn");
        Assertions.assertThat((int)((Process)firstProcessRecord.getValue()).getVersion()).isEqualTo(1);
        Assertions.assertThat((long)firstProcessRecord.getKey()).isEqualTo(((Process)firstProcessRecord.getValue()).getProcessDefinitionKey());
        Record secondProcessRecord = (Record)RecordingExporter.processRecords().withBpmnProcessId(this.processId2).getFirst();
        Assertions.assertThat((Object)secondProcessRecord).isNotNull();
        Assertions.assertThat((String)((Process)secondProcessRecord.getValue()).getResourceName()).isEqualTo("process2.bpmn");
        Assertions.assertThat((int)((Process)secondProcessRecord.getValue()).getVersion()).isEqualTo(1);
        Assertions.assertThat((long)secondProcessRecord.getKey()).isEqualTo(((Process)secondProcessRecord.getValue()).getProcessDefinitionKey());
    }

    @Test
    public void shouldCreateDeploymentIfUnusedInvalidMessage() {
        BpmnModelInstance process = Bpmn.createExecutableProcess().startEvent().done();
        process.getDefinitions().addChildElement(process.newInstance(Message.class));
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(process).deploy();
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
    }

    @Test
    public void shouldCreateDeploymentWithMessageStartEvent() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess();
        BpmnModelInstance process = ((StartEventBuilder)processBuilder.startEvent().message(m -> m.name("startMessage"))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(process).deploy();
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
    }

    @Test
    public void shouldCreateDeploymentWithMultipleMessageStartEvent() {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"processWithMultipleMsgStartEvent");
        ((StartEventBuilder)processBuilder.startEvent().message(m -> m.name("startMessage1"))).endEvent().done();
        BpmnModelInstance process = ((StartEventBuilder)processBuilder.startEvent().message(m -> m.name("startMessage2"))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(process).deploy();
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
    }

    @Test
    public void shouldIncrementProcessVersions() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"shouldIncrementProcessVersions").startEvent().endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process1.bpmn", modelInstance).deploy();
        Record<DeploymentRecordValue> deployment2 = ENGINE.deployment().withXmlResource("process2.bpmn", modelInstance).deploy();
        Assertions.assertThat((int)((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getVersion()).isEqualTo(1L);
        Assertions.assertThat((int)((ProcessMetadataValue)((DeploymentRecordValue)deployment2.getValue()).getProcessesMetadata().get(0)).getVersion()).isEqualTo(2L);
    }

    @Test
    public void shouldFilterDuplicateProcess() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process.bpmn", this.process).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process.bpmn", this.process).deploy();
        Assertions.assertThat((long)repeated.getKey()).isGreaterThan(original.getKey());
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        this.assertSameResource((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedProcesses.get(0));
    }

    @Test
    public void shouldNotFilterWithDifferentResourceName() {
        String originalResourceName = "process-1.bpmn";
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process-1.bpmn", this.process).deploy();
        String repeatedResourceName = "process-2.bpmn";
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process-2.bpmn", this.process).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        this.assertDifferentResources((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedProcesses.get(0));
        Assertions.assertThat((String)((ProcessMetadataValue)originalProcesses.get(0)).getResourceName()).isEqualTo("process-1.bpmn");
        Assertions.assertThat((String)((ProcessMetadataValue)repeatedProcesses.get(0)).getResourceName()).isEqualTo("process-2.bpmn");
    }

    @Test
    public void shouldNotFilterWithDifferentResource() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("process.bpmn", this.process).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("process.bpmn", this.process_V2).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        this.assertDifferentResources((ProcessMetadataValue)originalProcesses.get(0), (ProcessMetadataValue)repeatedProcesses.get(0));
    }

    @Test
    public void shouldFilterWithTwoEqualResources() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("p1.bpmn", this.process).withXmlResource("p2.bpmn", this.process2).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("p1.bpmn", this.process).withXmlResource("p2.bpmn", this.process2).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isEqualTo(2);
        for (ProcessMetadataValue process : originalProcesses) {
            this.assertSameResource(process, this.findProcess(repeatedProcesses, process.getBpmnProcessId()));
        }
    }

    @Test
    public void shouldFilterWithOneDifferentAndOneEqual() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("p1.bpmn", this.process).withXmlResource("p2.bpmn", this.process2).deploy();
        Record<DeploymentRecordValue> repeated = ENGINE.deployment().withXmlResource("p1.bpmn", this.process).withXmlResource("p2.bpmn", this.process2_V2).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)repeated.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isEqualTo(2);
        this.assertSameResource(this.findProcess(originalProcesses, this.processId), this.findProcess(repeatedProcesses, this.processId));
        this.assertDifferentResources(this.findProcess(originalProcesses, this.processId2), this.findProcess(repeatedProcesses, this.processId2));
    }

    @Test
    public void shouldNotFilterWithRollbackToPreviousVersion() {
        Record<DeploymentRecordValue> original = ENGINE.deployment().withXmlResource("p1.bpmn", this.process).deploy();
        ENGINE.deployment().withXmlResource("p1.bpmn", this.process_V2).deploy();
        Record<DeploymentRecordValue> rollback = ENGINE.deployment().withXmlResource("p1.bpmn", this.process).deploy();
        List originalProcesses = ((DeploymentRecordValue)original.getValue()).getProcessesMetadata();
        List repeatedProcesses = ((DeploymentRecordValue)rollback.getValue()).getProcessesMetadata();
        Assertions.assertThat((int)repeatedProcesses.size()).isEqualTo(originalProcesses.size()).isOne();
        this.assertDifferentResources(this.findProcess(originalProcesses, this.processId), this.findProcess(repeatedProcesses, this.processId));
    }

    @Test
    public void shouldDeployProcessModelWithUndefinedTask() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().task().endEvent().done();
        Record<DeploymentRecordValue> result = ENGINE.deployment().withXmlResource(modelInstance).deploy();
        Assertions.assertThat((long)result.getKey()).isGreaterThan(0L);
        Assertions.assertThat((List)((DeploymentRecordValue)result.getValue()).getProcessesMetadata()).hasSize(1);
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)result.getValue()).getProcessesMetadata().get(0);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getProcessDefinitionKey()).isGreaterThan(0L);
    }

    @Test
    public void shouldCreateDeploymentWithMessageStartEventIgnoreExtensionElements() {
        BpmnModelInstance modelInstance = ((MessageEventDefinitionBuilder)((MessageEventDefinitionBuilder)Bpmn.createExecutableProcess((String)"processId").startEvent("startEvent").messageEventDefinition().message("messageEvent")).addExtensionElement(ZeebeLoopCharacteristics.class, z -> z.setInputCollection("= inputs"))).messageEventDefinitionDone().endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(modelInstance).deploy();
        Assertions.assertThat((Object)deployment.getIntent()).isEqualTo((Object)DeploymentIntent.CREATED);
    }

    @Test
    public void shouldCreateDeploymentResourceOfExecutablePools() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlClasspathResource(NONE_EXECUTABLE_POOLS).deploy();
        ((AbstractListAssert)Assertions.assertThat((List)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata()).extracting(ProcessMetadataValue::getBpmnProcessId).describedAs("The ProcessesMetadata of DeploymentRecord only contains executable process.", new Object[0]).containsExactly((Object[])new String[]{"Process_Executable"})).doesNotContain((Object[])new String[]{"Process_NonExecutable"});
        ((AbstractListAssert)((ListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().limit(record -> record.getPosition() >= deployment.getPosition())).processRecords().withIntent((Intent)ProcessIntent.CREATED)).hasSize(1)).extracting(p -> ((Process)p.getValue()).getBpmnProcessId()).describedAs("The ProcessRecord only contains executable process.", new Object[0]).containsExactly((Object[])new String[]{"Process_Executable"})).doesNotContain((Object[])new String[]{"Process_NonExecutable"});
    }

    private ProcessMetadataValue findProcess(List<ProcessMetadataValue> processes, String processId) {
        return processes.stream().filter(w -> w.getBpmnProcessId().equals(processId)).findFirst().orElse(null);
    }

    private void assertSameResource(ProcessMetadataValue original, ProcessMetadataValue repeated) {
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessMetadataValue)repeated).hasVersion(original.getVersion()).hasProcessDefinitionKey(original.getProcessDefinitionKey()).hasResourceName(original.getResourceName()).hasBpmnProcessId(original.getBpmnProcessId());
    }

    private void assertDifferentResources(ProcessMetadataValue original, ProcessMetadataValue repeated) {
        Assertions.assertThat((long)original.getProcessDefinitionKey()).isLessThan(repeated.getProcessDefinitionKey());
        Assertions.assertThat((int)original.getVersion()).isLessThan(repeated.getVersion());
    }
}

