/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.processing.deployment.model.validation.ExpectedValidationResult;
import io.camunda.zeebe.engine.processing.deployment.model.validation.ProcessValidationUtil;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeCalledDecision;
import java.util.function.Consumer;
import org.junit.jupiter.api.Test;

public class BusinessRuleTaskValidationTest {
    @Test
    void emptyDecisionIdExpression() {
        BpmnModelInstance process = this.process(task -> ((BusinessRuleTaskBuilder)task.zeebeCalledDecisionIdExpression("")).zeebeResultVariable("result"));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ZeebeCalledDecision.class, "Attribute 'decisionId' must be present and not empty"));
    }

    @Test
    void invalidDecisionIdExpression() {
        BpmnModelInstance process = this.process(task -> task.zeebeCalledDecisionIdExpression("invalid id"));
        ProcessValidationUtil.validateProcess(process, ExpectedValidationResult.expect(ZeebeCalledDecision.class, "failed to parse expression 'invalid id'"));
    }

    private BpmnModelInstance process(Consumer<BusinessRuleTaskBuilder> taskBuilder) {
        return Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask("task", taskBuilder).done();
    }
}

