/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.zeebe.SignalBuilder;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.protocol.record.ExecuteCommandResponseDecoder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class SignalEventValidationTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldDeploySignalStartEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").signal("signalName")).done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal start event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldRejectDeployNoneReferenceSignalEndEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((EndEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").endEvent().addExtensionElement(ZeebeTaskDefinition.class, b -> b.setType("type"))).signalEventDefinition().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: signalEventDefinition_"})).contains(new CharSequence[]{"ERROR: Must reference a signal"});
    }

    @Test
    public void shouldRejectDeployEmptySignalEndEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((EndEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").endEvent().signal("")).done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: signal_"})).contains(new CharSequence[]{"ERROR: Name must be present and not empty"});
    }

    @Test
    public void shouldDeploySignalEndEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((EndEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").endEvent().signal("signalName")).done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal end event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldRejectDeployEmptySignalThrowEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").intermediateThrowEvent().signal("")).endEvent().done();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: signal_"})).contains(new CharSequence[]{"ERROR: Name must be present and not empty"});
    }

    @Test
    public void shouldDeploySignalThrowEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("start").intermediateThrowEvent().signal("signalName")).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal throw event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeployMultipleSignalStartEvents() {
        BpmnModelInstance processDefinition = SignalEventValidationTest.processWithMultipleSignalStartEvents();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support multiple signal star event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeploySignalBoundaryEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = Bpmn.createExecutableProcess((String)processId).startEvent().manualTask().boundaryEvent("boundary-1", b -> b.signal(m -> m.name("signalName"))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal boundary event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeploySignalStartAndMultipleBoundaryEvents() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().signal("start-signal")).manualTask("task").boundaryEvent("boundary-1", b -> b.signal(m -> m.name("signalName1"))).endEvent().moveToActivity("task").boundaryEvent("boundary-2", b -> b.signal(m -> m.name("signalName2"))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal start event and multiple signal boundary event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeployEventSubProcessWithMultipleSignalEvents() {
        BpmnModelInstance processDefinition = SignalEventValidationTest.getEventSubProcessWithEmbeddedSubProcessWithBoundarySignalEvent();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support event sub process with signal start event and boundary event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeploySignalIntermediateCatchEvent() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().intermediateCatchEvent("foo").signal("signalName")).done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal intermediate catch event process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldDeploySignalStartAndBoundaryEventEvenWithSameSignal() {
        String processId = Strings.newRandomValidBpmnId();
        BpmnModelInstance processDefinition = ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().signal(m -> ((SignalBuilder)m.id("start-signal")).name("signalName"))).manualTask().boundaryEvent("boundary-1", b -> b.signal(m -> m.name("signalName"))).endEvent().done();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(processDefinition).deploy();
        ((AbstractLongAssert)Assertions.assertThat((long)deployment.getKey()).describedAs("Support signal start and boundary event even with the same signal name process deployment", new Object[0])).isNotNegative();
    }

    @Test
    public void shouldRejectDeployMultipleStartEventsWithSameSignal() {
        BpmnModelInstance processDefinition = SignalEventValidationTest.getProcessWithMultipleStartEventsWithSameSignal();
        Record<DeploymentRecordValue> rejectedDeployment = ENGINE.deployment().withXmlResource(processDefinition).expectRejection().deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejectedDeployment).hasKey(ExecuteCommandResponseDecoder.keyNullValue()).hasRecordType(RecordType.COMMAND_REJECTION).hasIntent((Intent)DeploymentIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        ((AbstractStringAssert)Assertions.assertThat((String)rejectedDeployment.getRejectionReason()).contains(new CharSequence[]{"Element: process"})).contains(new CharSequence[]{"ERROR: Multiple signal event definitions with the same name 'signalName' are not allowed."});
    }

    private static BpmnModelInstance getEventSubProcessWithEmbeddedSubProcessWithBoundarySignalEvent() {
        ProcessBuilder builder = Bpmn.createExecutableProcess((String)"process");
        builder.eventSubProcess("event_sub_proc").startEvent("event_sub_start", a -> a.signal(m -> ((SignalBuilder)m.id("event_sub_start_signal")).name("signalName1"))).subProcess("embedded", s -> s.boundaryEvent("boundary-msg", b -> ((BoundaryEventBuilder)b.signal("signalName2")).endEvent("boundary-end"))).embeddedSubProcess().startEvent("embedded_sub_start").endEvent("embedded_sub_end").moveToNode("embedded").endEvent("event_sub_end");
        return builder.startEvent("start").endEvent("end").done();
    }

    public static BpmnModelInstance processWithMultipleSignalStartEvents() {
        ProcessBuilder process = Bpmn.createExecutableProcess();
        ((StartEventBuilder)process.startEvent().signal("s1")).endEvent();
        ((StartEventBuilder)process.startEvent().signal("s2")).endEvent();
        ((StartEventBuilder)process.startEvent().signal(s -> s.nameExpression("=\"signal_static_expression\""))).endEvent();
        return ((StartEventBuilder)process.startEvent().signal("s3")).endEvent().done();
    }

    private static BpmnModelInstance getProcessWithMultipleStartEventsWithSameSignal() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)"processId");
        String signalName = "signalName";
        ((StartEventBuilder)process.startEvent("start1").signal(m -> ((SignalBuilder)m.id("start-signal")).name("signalName"))).endEvent();
        ((StartEventBuilder)process.startEvent("start2").signal("signalName")).endEvent();
        return process.done();
    }
}

