/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class ErrorEventIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "wf";
    private static final String JOB_TYPE = "test";
    private static final String ERROR_CODE = "error";
    private static final BpmnModelInstance BOUNDARY_EVENT_PROCESS = Bpmn.createExecutableProcess((String)"wf").startEvent().serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).boundaryEvent("error", b -> b.error(ERROR_CODE)).endEvent().done();
    private static final BpmnModelInstance END_EVENT_PROCESS = Bpmn.createExecutableProcess((String)"wf").startEvent().endEvent("error", e -> e.error(ERROR_CODE)).done();
    private static final BpmnModelInstance EVENT_SUB_PROCESS = Bpmn.createExecutableProcess((String)"wf").eventSubProcess("error", subprocess -> subprocess.startEvent("error-start", s -> ((StartEventBuilder)s.error(ERROR_CODE)).interrupting(true)).serviceTask("task-in-subprocess", t -> t.zeebeJobType(JOB_TYPE)).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().done();
    private static final BpmnModelInstance BOUNDARY_EVENT_SUBPROCESS = Bpmn.createExecutableProcess((String)"wf").startEvent("start").subProcess("subprocess", subprocess -> subprocess.embeddedSubProcess().startEvent("start_subprocess").serviceTask("task_in_subprocess", b -> b.zeebeJobType(JOB_TYPE)).boundaryEvent("error_in_subprocess", event -> event.error("error_in_subprocess")).endEvent("end_boundary_in_subprocess").moveToActivity("task_in_subprocess").endEvent("end_subprocess").subProcessDone()).boundaryEvent("error", b -> b.error(ERROR_CODE)).endEvent("end_boundary").moveToActivity("subprocess").endEvent("end").done();
    @Rule
    public final RecordingExporterTestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCreateIncidentWhenThrownErrorIsUncaught() {
        ENGINE.deployment().withXmlResource(BOUNDARY_EVENT_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> jobEvent = ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("other-error").withErrorMessage("error thrown").throwError();
        ((IncidentRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("unhandled error event incident created", new Object[0])).hasErrorType(ErrorType.UNHANDLED_ERROR_EVENT).hasErrorMessage("Expected to throw an error event with the code 'other-error' with message 'error thrown', but it was not caught. Available error events are [error]").hasBpmnProcessId(((JobRecordValue)jobEvent.getValue()).getBpmnProcessId()).hasProcessDefinitionKey(((JobRecordValue)jobEvent.getValue()).getProcessDefinitionKey()).hasProcessInstanceKey(((JobRecordValue)jobEvent.getValue()).getProcessInstanceKey()).hasElementId(((JobRecordValue)jobEvent.getValue()).getElementId()).hasElementInstanceKey(((JobRecordValue)jobEvent.getValue()).getElementInstanceKey()).hasVariableScopeKey(((JobRecordValue)jobEvent.getValue()).getElementInstanceKey()).hasJobKey(jobEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentWithDefaultErrorMessage() {
        ENGINE.deployment().withXmlResource(BOUNDARY_EVENT_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("other-error").throwError();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.UNHANDLED_ERROR_EVENT).hasErrorMessage("Expected to throw an error event with the code 'other-error', but it was not caught. Available error events are [error]");
    }

    @Test
    public void shouldCreateIncidentIfErrorIsThrownFromInterruptingEventSubprocess() {
        ENGINE.deployment().withXmlResource(EVENT_SUB_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        long jobKey = ((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("task-in-subprocess").getFirst()).getKey();
        ENGINE.job().withKey(jobKey).withType(JOB_TYPE).withErrorCode(ERROR_CODE).throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).hasErrorType(ErrorType.UNHANDLED_ERROR_EVENT).hasErrorMessage(String.format("Expected to throw an error event with the code '%s', but it was not caught. No error events are available in the scope.", ERROR_CODE)).hasElementId("NO_CATCH_EVENT_FOUND");
    }

    @Test
    public void shouldResolveIncidentWhenTerminatingScope() {
        ENGINE.deployment().withXmlResource(BOUNDARY_EVENT_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("other-error").throwError();
        ((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).incidentRecords()).extracting(Record::getIntent).contains((Object[])new Intent[]{IncidentIntent.RESOLVED});
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).jobRecords()).extracting(Record::getIntent).doesNotContain((Object[])new Intent[]{JobIntent.CANCEL});
    }

    @Test
    public void shouldCreateIncidentOnErrorEndEvent() {
        ENGINE.deployment().withXmlResource(END_EVENT_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record endEvent = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.UNHANDLED_ERROR_EVENT).hasErrorMessage("Expected to throw an error event with the code 'error', but it was not caught. No error events are available in the scope.").hasBpmnProcessId(((ProcessInstanceRecordValue)endEvent.getValue()).getBpmnProcessId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)endEvent.getValue()).getProcessDefinitionKey()).hasProcessInstanceKey(((ProcessInstanceRecordValue)endEvent.getValue()).getProcessInstanceKey()).hasElementId(((ProcessInstanceRecordValue)endEvent.getValue()).getElementId()).hasElementInstanceKey(endEvent.getKey()).hasVariableScopeKey(endEvent.getKey()).hasJobKey(-1L);
    }

    @Test
    public void shouldNotResolveIncidentOnEndEvent() {
        ENGINE.deployment().withXmlResource(END_EVENT_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incident = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        Assertions.assertThat((Stream)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limit(3L)).extracting(Record::getIntent).describedAs("incident is created, resolved and recreated", new Object[0]).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED, IncidentIntent.CREATED});
        ((OptionalAssert)((OptionalAssert)Assertions.assertThat((Optional)((IncidentRecordStream)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).onlyEvents()).filter(r -> r.getKey() != incident.getKey())).findFirst()).describedAs("incident is recreated as new incident", new Object[0])).isPresent()).hasValueSatisfying(newIncident -> Assertions.assertThat((Object)((IncidentRecordValue)newIncident.getValue())).isEqualTo((Object)incident.getValue()));
    }

    @Test
    public void shouldResolveIncidentForJob() {
        ENGINE.deployment().withXmlResource(BOUNDARY_EVENT_PROCESS).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> job = ENGINE.job().ofInstance(processInstanceKey).withType(JOB_TYPE).withErrorCode("other-error").throwError();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).withErrorType(ErrorType.UNHANDLED_ERROR_EVENT).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        Assertions.assertThat((Stream)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).onlyEvents()).limit(2L)).extracting(Record::getIntent).describedAs("incident is created and resolved", new Object[0]).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
        ENGINE.job().withKey(job.getKey()).complete();
        Assertions.assertThat((Stream)((JobRecordStream)((JobRecordStream)RecordingExporter.jobRecords().withRecordKey(job.getKey())).onlyEvents()).limit(3L)).extracting(Record::getIntent).describedAs("job that had error_thrown is completed", new Object[0]).containsExactly((Object[])new Intent[]{JobIntent.CREATED, JobIntent.ERROR_THROWN, JobIntent.COMPLETED});
    }

    @Test
    public void shouldCreateIncidentWhenNoCatchEventFoundWithBoundaryEventsInMultipleScopes() {
        ENGINE.deployment().withXmlResource(BOUNDARY_EVENT_SUBPROCESS).deploy();
        long instanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<JobRecordValue> result = ENGINE.job().ofInstance(instanceKey).withType(JOB_TYPE).withErrorCode("unknown_error_code").withErrorMessage("error message").throwError();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(result).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.ERROR_THROWN);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)result.getValue())).hasErrorCode("unknown_error_code").hasErrorMessage("error message");
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)((Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withProcessInstanceKey(instanceKey).withIntent((Intent)IncidentIntent.CREATED)).getFirst()).getValue())).hasErrorMessage("Expected to throw an error event with the code 'unknown_error_code' with message 'error message', but it was not caught. Available error events are [error_in_subprocess, error]");
    }

    @Test
    public void shouldCreateIncidentIfErrorCodeExpressionForTheEndEventCannotBeEvaluated() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent(ERROR_CODE, e -> e.errorExpression("unknown_error_code")).done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record endEvent = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'unknown_error_code': no variable found for name 'unknown_error_code'").hasBpmnProcessId(((ProcessInstanceRecordValue)endEvent.getValue()).getBpmnProcessId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)endEvent.getValue()).getProcessDefinitionKey()).hasProcessInstanceKey(((ProcessInstanceRecordValue)endEvent.getValue()).getProcessInstanceKey()).hasElementId(((ProcessInstanceRecordValue)endEvent.getValue()).getElementId()).hasElementInstanceKey(endEvent.getKey()).hasVariableScopeKey(endEvent.getKey()).hasJobKey(-1L);
    }

    @Test
    public void shouldResolveIncidentIfErrorCodeCouldNotBeEvaluated() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().endEvent(ERROR_CODE, e -> e.errorExpression("errorCodeLookup"))).boundaryEvent("boundary", b -> ((BoundaryEventBuilder)b.error("errorCode")).endEvent()).done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"errorCodeLookup", (Object)"errorCode")})).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreatedRecord.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().onlyEvents()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_TERMINATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedRecord.getKey());
    }
}

