/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class EscalationIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "wf";
    private static final String ESCALATION_CODE = "ESCALATION";
    private static final String THROW_ELEMENT_ID = "throw";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCreateIncidentIfEscalationCodeExpressionOfEndEventCannotBeEvaluated() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent(THROW_ELEMENT_ID, i -> i.escalationExpression("escalationCodeLookup")).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record endEvent = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'escalationCodeLookup': no variable found for name 'escalationCodeLookup'").hasBpmnProcessId(((ProcessInstanceRecordValue)endEvent.getValue()).getBpmnProcessId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)endEvent.getValue()).getProcessDefinitionKey()).hasProcessInstanceKey(((ProcessInstanceRecordValue)endEvent.getValue()).getProcessInstanceKey()).hasElementId(((ProcessInstanceRecordValue)endEvent.getValue()).getElementId()).hasElementInstanceKey(endEvent.getKey()).hasJobKey(-1L).hasVariableScopeKey(endEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentIfEscalationCodeExpressionOfEndEventEvaluatesToWrongType() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent(THROW_ELEMENT_ID, i -> i.escalationExpression("escalationCodeLookup")).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("escalationCodeLookup", 25).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(THROW_ELEMENT_ID).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'escalationCodeLookup' to be 'STRING', but was 'NUMBER'.").hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasElementId(THROW_ELEMENT_ID).hasElementInstanceKey(failureEvent.getKey()).hasJobKey(-1L).hasVariableScopeKey(failureEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentIfEscalationCodeExpressionOfIntermediateEscalationEventCannotBeEvaluated() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalationExpression("escalationCodeLookup")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentEvent = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        Record intermediateThrowEvent = (Record)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.INTERMEDIATE_THROW_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentEvent.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'escalationCodeLookup': no variable found for name 'escalationCodeLookup'").hasBpmnProcessId(((ProcessInstanceRecordValue)intermediateThrowEvent.getValue()).getBpmnProcessId()).hasProcessDefinitionKey(((ProcessInstanceRecordValue)intermediateThrowEvent.getValue()).getProcessDefinitionKey()).hasProcessInstanceKey(((ProcessInstanceRecordValue)intermediateThrowEvent.getValue()).getProcessInstanceKey()).hasElementId(((ProcessInstanceRecordValue)intermediateThrowEvent.getValue()).getElementId()).hasElementInstanceKey(intermediateThrowEvent.getKey()).hasJobKey(-1L).hasVariableScopeKey(intermediateThrowEvent.getKey());
    }

    @Test
    public void shouldCreateIncidentIfEscalationCodeExpressionOfIntermediateEscalationEventEvaluatesToWrongType() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalationExpression("escalationCodeLookup")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("escalationCodeLookup", 25).create();
        Record failureEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementId(THROW_ELEMENT_ID).withProcessInstanceKey(processInstanceKey).getFirst();
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'escalationCodeLookup' to be 'STRING', but was 'NUMBER'.").hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasElementId(THROW_ELEMENT_ID).hasElementInstanceKey(failureEvent.getKey()).hasJobKey(-1L).hasVariableScopeKey(failureEvent.getKey());
    }

    @Test
    public void shouldResolveIncidentIfEscalationCodeOfEndEventCouldNotBeEvaluated() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent(THROW_ELEMENT_ID, i -> i.escalationExpression("escalationCodeLookup")).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(Map.of("escalationCodeLookup", ESCALATION_CODE)).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreatedRecord.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().onlyEvents()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedRecord.getKey());
    }

    @Test
    public void shouldResolveIncidentIfEscalationCodeOfIntermediateEscalationEventCouldNotBeEvaluated() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(THROW_ELEMENT_ID, i -> i.escalationExpression("escalationCodeLookup")).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreatedRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreatedRecord.getValue()).getElementInstanceKey()).withDocument(Map.of("escalationCodeLookup", ESCALATION_CODE)).update();
        Record<IncidentRecordValue> incidentResolvedEvent = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreatedRecord.getKey()).resolve();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted().onlyEvents()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        Assertions.assertThat((long)incidentResolvedEvent.getKey()).isEqualTo(incidentCreatedRecord.getKey());
    }
}

