/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.ByteValue;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class JobActivationIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final int VARIABLE_COUNT = 4;
    private static final long MAX_MESSAGE_SIZE = ByteValue.ofMegabytes((long)4L);
    private static final String LARGE_TEXT = "x".repeat((int)(MAX_MESSAGE_SIZE / 4L));
    @Rule
    public RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private long processDefinitionKey;
    private String jobType;
    private String processId;

    static BpmnModelInstance createProcess(String processId, String jobType) {
        return Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("task", t -> t.zeebeJobType(jobType)).endEvent().done();
    }

    @Before
    public void init() {
        this.jobType = this.helper.getJobType();
        this.processId = this.helper.getBpmnProcessId();
        this.processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE.deployment().withXmlResource(JobActivationIncidentTest.createProcess(this.processId, this.jobType)).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    @Test
    public void shouldRaiseIncidentWhenActivatingJobThatIsTooBigForMessageSize() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        for (int i = 0; i < 4; ++i) {
            ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of(String.valueOf(i), LARGE_TEXT)).update();
        }
        Record<JobBatchRecordValue> activationResult = ENGINE.jobs().withMaxJobsToActivate(1).withType(this.jobType).byWorker("dummy").activate();
        Assertions.assertThat((List)((JobBatchRecordValue)activationResult.getValue()).getJobs()).isEmpty();
        Assertions.assertThat((boolean)((JobBatchRecordValue)activationResult.getValue()).isTruncated()).isTrue();
        Record incidentCommand = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentCommand.getValue())).hasErrorType(ErrorType.MESSAGE_SIZE_EXCEEDED).hasBpmnProcessId(this.processId).hasProcessDefinitionKey(this.processDefinitionKey).hasProcessInstanceKey(processInstanceKey).hasElementId("task");
    }

    @Test
    public void shouldActivateJobIfFetchVariablesFitIntoMessage() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        for (int i = 0; i < 4; ++i) {
            ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of(String.valueOf(i), LARGE_TEXT)).update();
        }
        Record<JobBatchRecordValue> activationResult = ENGINE.jobs().withMaxJobsToActivate(1).withType(this.jobType).withFetchVariables("0").byWorker("dummy").activate();
        Assertions.assertThat((List)((JobBatchRecordValue)activationResult.getValue()).getJobs()).hasSize(1);
        Assertions.assertThat((boolean)((JobBatchRecordValue)activationResult.getValue()).isTruncated()).isFalse();
    }

    @Test
    public void shouldMakeJobActivatableAfterIncidentIsResolved() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(this.processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        for (int i = 0; i < 4; ++i) {
            ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of(String.valueOf(i), LARGE_TEXT)).update();
        }
        ENGINE.jobs().withMaxJobsToActivate(1).withType(this.jobType).byWorker("dummy").activate();
        Record incidentCommand = (Record)((IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)IncidentIntent.CREATED)).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of("0", "lorem ipsum", "1", "lorem ipsum", "2", "lorem ipsum", "3", "lorem ipsum")).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCommand.getKey()).resolve();
        Record<JobBatchRecordValue> activationResult = ENGINE.jobs().withMaxJobsToActivate(1).withType(this.jobType).byWorker("dummy").activate();
        Assertions.assertThat((List)((JobBatchRecordValue)activationResult.getValue()).getJobs()).hasSize(1);
        Assertions.assertThat((boolean)((JobBatchRecordValue)activationResult.getValue()).isTruncated()).isFalse();
    }
}

