/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.JobWorkerElementBuilder;
import io.camunda.zeebe.engine.util.JobWorkerElementBuilderProvider;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeJobWorkerElementBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JobWorkerElementIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TASK_ELEMENT_ID = "task";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter
    public JobWorkerElementBuilder elementBuilder;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return JobWorkerElementBuilderProvider.buildersAsParameters();
    }

    private BpmnModelInstance process(Consumer<ZeebeJobWorkerElementBuilder<?>> elementModifier) {
        StartEventBuilder processBuilder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent();
        AbstractFlowNodeBuilder<?, ?> jobWorkerElementBuilder = this.elementBuilder.build((AbstractFlowNodeBuilder<?, ?>)processBuilder, element -> elementModifier.accept((ZeebeJobWorkerElementBuilder)element.zeebeJobType("test")));
        return ((AbstractFlowNodeBuilder)jobWorkerElementBuilder.id(TASK_ELEMENT_ID)).done();
    }

    @Test
    public void shouldCreateIncidentIfJobTypeExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobTypeExpression("x"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record recordThatLeadsToIncident = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(this.elementBuilder.getElementType()).getFirst();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentCreated.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'x': no variable found for name 'x'").hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(recordThatLeadsToIncident.getKey()).hasJobKey(-1L).hasVariableScopeKey(recordThatLeadsToIncident.getKey());
    }

    @Test
    public void shouldCreateIncidentIfJobTypeExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobTypeExpression("false"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record recordThatLeadsToIncident = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(this.elementBuilder.getElementType()).getFirst();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentCreated.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'false' to be 'STRING', but was 'BOOLEAN'.").hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(recordThatLeadsToIncident.getKey()).hasJobKey(-1L).hasVariableScopeKey(recordThatLeadsToIncident.getKey());
    }

    @Test
    public void shouldResolveIncidentAfterJobTypeExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobTypeExpression("x"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)"test")})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfJobRetriesExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobRetriesExpression("x"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record recordThatLeadsToIncident = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(this.elementBuilder.getElementType()).getFirst();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentCreated.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'x': no variable found for name 'x'").hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(recordThatLeadsToIncident.getKey()).hasJobKey(-1L).hasVariableScopeKey(recordThatLeadsToIncident.getKey());
    }

    @Test
    public void shouldCreateIncidentIfJobRetriesExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobRetriesExpression("false"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record recordThatLeadsToIncident = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(this.elementBuilder.getElementType()).getFirst();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentCreated.getValue())).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression 'false' to be 'NUMBER', but was 'BOOLEAN'.").hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(recordThatLeadsToIncident.getKey()).hasJobKey(-1L).hasVariableScopeKey(recordThatLeadsToIncident.getKey());
    }

    @Test
    public void shouldResolveIncidentAfterJobRetriesExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobRetriesExpression("x"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)3)})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldResolveIncidentAndCreateNewIncidentWhenContinuationFails() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeInputExpression("unknown_var", "input"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withRecordKey(incidentCreated.getKey())).exists()).describedAs("original incident is resolved", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(i -> i.getKey() != incidentCreated.getKey())).exists()).describedAs("a new incident is created", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentIfTaskIsTerminated() {
        ENGINE.deployment().withXmlResource(this.process(t -> t.zeebeJobTypeExpression("x"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).cancel();
        Assertions.assertThat((Stream)RecordingExporter.records().betweenProcessInstance(processInstanceKey).incidentRecords().withRecordKey(incidentCreated.getKey())).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{IncidentIntent.CREATED, IncidentIntent.RESOLVED});
    }
}

