/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.incident;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ZeebeUserTaskPropertiesBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValueAssert;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class UserTaskIncidentTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TASK_ELEMENT_ID = "user-task";
    @Rule
    public final RecordingExporterTestWatcher watcher = new RecordingExporterTestWatcher();

    private BpmnModelInstance processWithUserTask(Consumer<ZeebeUserTaskPropertiesBuilder<?>> modifier) {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask(TASK_ELEMENT_ID, modifier::accept).endEvent().done();
    }

    private IncidentRecordValueAssert assertIncidentCreated(long processInstanceKey, long elementInstanceKey) {
        Record incidentRecord = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        return io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incidentRecord.getValue())).hasElementId(TASK_ELEMENT_ID).hasElementInstanceKey(elementInstanceKey).hasJobKey(-1L).hasVariableScopeKey(elementInstanceKey);
    }

    @Test
    public void shouldCreateIncidentIfAssigneeExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeAssigneeExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'MISSING_VAR': no variable found for name 'MISSING_VAR'");
    }

    @Test
    public void shouldCreateIncidentIfAssigneeExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeAssigneeExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be 'STRING', but was 'ARRAY'.");
    }

    @Test
    public void shouldResolveIncidentAndCreateNewIncidentWhenContinuationFails() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeAssigneeExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.RESOLVED).withProcessInstanceKey(processInstanceKey).withRecordKey(incidentCreated.getKey())).exists()).describedAs("original incident is resolved", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((IncidentRecordStream)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).filter(i -> i.getKey() != incidentCreated.getKey())).exists()).describedAs("a new incident is created", new Object[0])).isTrue();
    }

    @Test
    public void shouldResolveIncidentAfterAssigneeExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeAssigneeExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", (Object)"no longer missing")})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfCandidateGroupsExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateGroupsExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'MISSING_VAR': no variable found for name 'MISSING_VAR'");
    }

    @Test
    public void shouldCreateIncidentIfCandidateGroupsExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateGroupsExpression("\"not a list\""))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '\"not a list\"' to be 'ARRAY', but was 'STRING'.");
    }

    @Test
    public void shouldCreateIncidentIfCandidateGroupsExpressionOfInvalidArrayItemType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateGroupsExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item.");
    }

    @Test
    public void shouldResolveIncidentAfterCandidateGroupsExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeCandidateGroupsExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", List.of("a string value", "and another"))})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }

    @Test
    public void shouldCreateIncidentIfCandidateUsersExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateUsersExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("failed to evaluate expression 'MISSING_VAR': no variable found for name 'MISSING_VAR'");
    }

    @Test
    public void shouldCreateIncidentIfCandidateUsersExpressionOfInvalidType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateUsersExpression("\"not a list\""))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '\"not a list\"' to be 'ARRAY', but was 'STRING'.");
    }

    @Test
    public void shouldCreateIncidentIfCandidateUsersExpressionOfInvalidArrayItemType() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(u -> u.zeebeCandidateUsersExpression("[1,2,3]"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).withElementType(BpmnElementType.USER_TASK).getFirst();
        this.assertIncidentCreated(processInstanceKey, userTaskActivating.getKey()).hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).hasErrorMessage("Expected result of the expression '[1,2,3]' to be 'ARRAY' containing 'STRING' items, but was 'ARRAY' containing at least one non-'STRING' item.");
    }

    @Test
    public void shouldResolveIncidentAfterCandidateUsersExpressionEvaluationFailed() {
        ENGINE.deployment().withXmlResource(this.processWithUserTask(t -> t.zeebeCandidateUsersExpression("MISSING_VAR"))).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record incidentCreated = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        ENGINE.variables().ofScope(((IncidentRecordValue)incidentCreated.getValue()).getElementInstanceKey()).withDocument(Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"MISSING_VAR", List.of("a string value", "and another"))})).update();
        Record<IncidentRecordValue> incidentResolved = ENGINE.incident().ofInstance(processInstanceKey).withKey(incidentCreated.getKey()).resolve();
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId(TASK_ELEMENT_ID).exists()).isTrue();
        Assertions.assertThat((long)incidentResolved.getKey()).isEqualTo(incidentCreated.getKey());
    }
}

