/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.JobTimeoutTrigger;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;

public final class ActivatableJobsNotificationTests {
    private static final String PROCESS_ID = "process";
    private static final Function<String, BpmnModelInstance> MODEL_SUPPLIER = type -> Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").serviceTask("task", b -> ((ServiceTaskBuilder)b.zeebeJobType(type)).done()).endEvent("end").done();
    private static final Consumer<String> JOB_AVAILABLE_CALLBACK = (Consumer)Mockito.spy(Consumer.class);
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().withJobsAvailableCallback(JOB_AVAILABLE_CALLBACK);
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private String taskType;

    @Before
    public void setup() {
        this.taskType = Strings.newRandomValidBpmnId();
        ENGINE.deployment().withXmlResource("process.bpmn", MODEL_SUPPLIER.apply(this.taskType)).deploy();
    }

    @Test
    public void shouldNotifyWhenJobCreated() {
        this.createProcessInstanceAndJobs(3);
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)3))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyWhenJobsAvailableAgain() {
        this.createProcessInstanceAndJobs(1);
        Record<JobBatchRecordValue> jobs = this.activateJobs(1);
        this.createProcessInstanceAndJobs(1);
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)2))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyWhenJobCanceled() {
        List<Long> instanceKeys = this.createProcessInstanceAndJobs(1);
        ENGINE.processInstance().withInstanceKey(instanceKeys.get(0)).cancel();
        this.createProcessInstanceAndJobs(1);
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)2))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyWhenJobsAvailableAfterTimeOut() {
        this.createProcessInstanceAndJobs(1);
        this.activateJobs(1, Duration.ofMillis(10L));
        ENGINE.increaseTime(JobTimeoutTrigger.TIME_OUT_POLLING_INTERVAL);
        RecordingExporter.jobRecords((JobIntent)JobIntent.TIMED_OUT).withType(this.taskType).getFirst();
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)2))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyWhenJobCreatedAfterNotActivatedJobCompleted() {
        this.createProcessInstanceAndJobs(1);
        long jobKey = (Long)((JobBatchRecordValue)this.activateJobs(1, Duration.ofMillis(10L)).getValue()).getJobKeys().get(0);
        ENGINE.increaseTime(JobTimeoutTrigger.TIME_OUT_POLLING_INTERVAL);
        RecordingExporter.jobRecords((JobIntent)JobIntent.TIMED_OUT).withType(this.taskType).getFirst();
        ENGINE.job().withKey(jobKey).complete();
        this.createProcessInstanceAndJobs(1);
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)3))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyWhenJobsFailWithRetryAvailable() {
        this.createProcessInstanceAndJobs(1);
        Record<JobBatchRecordValue> jobs = this.activateJobs(1);
        long jobKey = (Long)((JobBatchRecordValue)jobs.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).withRetries(10).fail();
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)2))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyWhenFailedJobsResolved() {
        this.createProcessInstanceAndJobs(1);
        Record<JobBatchRecordValue> jobs = this.activateJobs(1);
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)jobs.getValue()).getJobs().get(0);
        ENGINE.job().withType(this.taskType).ofInstance(job.getProcessInstanceKey()).fail();
        ENGINE.job().ofInstance(job.getProcessInstanceKey()).withType(this.taskType).withRetries(1).updateRetries();
        ENGINE.incident().ofInstance(job.getProcessInstanceKey()).resolve();
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)2))).accept(this.taskType);
    }

    @Test
    public void shouldNotifyForMultipleJobTypes() {
        String firstType = Strings.newRandomValidBpmnId();
        String secondType = Strings.newRandomValidBpmnId();
        ENGINE.createJob(firstType, PROCESS_ID);
        ENGINE.createJob(secondType, PROCESS_ID);
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)1))).accept(firstType);
        ((Consumer)Mockito.verify(JOB_AVAILABLE_CALLBACK, (VerificationMode)VerificationModeFactory.times((int)1))).accept(secondType);
    }

    private List<Long> createProcessInstanceAndJobs(int amount) {
        return IntStream.range(0, amount).mapToObj(i -> ENGINE.createJob(this.taskType, PROCESS_ID)).map(r -> ((JobRecordValue)r.getValue()).getProcessInstanceKey()).collect(Collectors.toList());
    }

    private Record<JobBatchRecordValue> activateJobs(int amount) {
        Duration timeout = Duration.ofMinutes(12L);
        return this.activateJobs(amount, timeout);
    }

    private Record<JobBatchRecordValue> activateJobs(int amount, Duration timeout) {
        String worker = "myTestWorker";
        return ENGINE.jobs().withType(this.taskType).byWorker("myTestWorker").withTimeout(timeout.toMillis()).withMaxJobsToActivate(amount).activate();
    }
}

