/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class JobUpdateRetriesTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final int NEW_RETRIES = 20;
    private static final String PROCESS_ID = "process";
    private static String jobType;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Before
    public void setup() {
        jobType = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldUpdateRetries() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        JobRecordValue job = (JobRecordValue)((JobBatchRecordValue)batchRecord.getValue()).getJobs().get(0);
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        Record<JobRecordValue> updatedRecord = ENGINE.job().withKey(jobKey).withRetries(20).updateRetries();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(updatedRecord).hasRecordType(RecordType.EVENT).hasIntent((Intent)JobIntent.RETRIES_UPDATED);
        Assertions.assertThat((long)updatedRecord.getKey()).isEqualTo(jobKey);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)updatedRecord.getValue())).hasWorker(job.getWorker()).hasType(job.getType()).hasRetries(20).hasDeadline(job.getDeadline());
    }

    @Test
    public void shouldRejectUpdateRetriesIfJobNotFound() {
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(123L).withRetries(20).expectRejection().updateRetries();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldRejectUpdateRetriesIfJobCompleted() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).withVariables("{}").complete();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withRetries(20).expectRejection().updateRetries();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.NOT_FOUND);
    }

    @Test
    public void shouldUpdateRetriesIfJobActivated() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        Record<JobRecordValue> response = ENGINE.job().withKey(jobKey).withRetries(20).updateRetries();
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)JobIntent.RETRIES_UPDATED);
        Assertions.assertThat((long)response.getKey()).isEqualTo(jobKey);
        Assertions.assertThat((int)((JobRecordValue)response.getValue()).getRetries()).isEqualTo(20);
    }

    @Test
    public void shouldUpdateRetriesIfJobCreated() {
        long jobKey = ENGINE.createJob(jobType, PROCESS_ID).getKey();
        Record<JobRecordValue> response = ENGINE.job().withKey(jobKey).withRetries(20).updateRetries();
        Assertions.assertThat((Comparable)response.getRecordType()).isEqualTo((Object)RecordType.EVENT);
        Assertions.assertThat((Object)response.getIntent()).isEqualTo((Object)JobIntent.RETRIES_UPDATED);
        Assertions.assertThat((long)response.getKey()).isEqualTo(jobKey);
        Assertions.assertThat((int)((JobRecordValue)response.getValue()).getRetries()).isEqualTo(20);
    }

    @Test
    public void shouldRejectUpdateRetriesIfRetriesZero() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).withRetries(0).fail();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withRetries(0).expectRejection().updateRetries();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.INVALID_ARGUMENT);
    }

    @Test
    public void shouldRejectUpdateRetriesIfRetriesLessThanZero() {
        ENGINE.createJob(jobType, PROCESS_ID);
        Record<JobBatchRecordValue> batchRecord = ENGINE.jobs().withType(jobType).activate();
        long jobKey = (Long)((JobBatchRecordValue)batchRecord.getValue()).getJobKeys().get(0);
        ENGINE.job().withKey(jobKey).withRetries(0).fail();
        Record<JobRecordValue> jobRecord = ENGINE.job().withKey(jobKey).withRetries(-1).expectRejection().updateRetries();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(jobRecord).hasRejectionType(RejectionType.INVALID_ARGUMENT);
    }
}

