/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CreateProcessInstanceAnywhereTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper classRuleHelper = new BrokerClassRuleHelper();

    @Test
    public void shouldActivateSingleElement() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("end").create();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to start process instance at end event", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldActivateMultipleElements() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start").parallelGateway("forking").manualTask("task1").parallelGateway("joining").moveToNode("forking").manualTask("task2").connectTo("joining").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task1").withStartInstruction("task2").create();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to start process instance at both tasks", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"start", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"start", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"forking", BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"forking", BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldActivateElementWithinSubprocess() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start_root").subProcess("subprocess", s -> s.embeddedSubProcess().startEvent("start_lvl_1").manualTask("task").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").create();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to start process instance at task inside subprocess", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"start_root", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"start_lvl_1", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldActivateMultipleElementsWithinSubprocess() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start_root").subProcess("subprocess", s -> s.embeddedSubProcess().startEvent("start_lvl_1").parallelGateway("forking").manualTask("task1").parallelGateway("joining").moveToNode("forking").manualTask("task2").connectTo("joining").endEvent().done()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task1").withStartInstruction("task2").create();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to start process instance at both tasks inside subprocess", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"start_root", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"start_lvl_1", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"forking", BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldActivateElementWithinNestedSubprocess() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("start_root").subProcess("subprocess_lvl_1", s -> s.embeddedSubProcess().startEvent("start_lvl_1").subProcess("subprocess_lvl_2", ns -> ns.embeddedSubProcess().startEvent("start_lvl_2").manualTask("task").endEvent()).endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").create();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to start process instance at task inside nested subprocess", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"subprocess_lvl_1", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{"subprocess_lvl_1", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"subprocess_lvl_2", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{"subprocess_lvl_2", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"subprocess_lvl_2", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"subprocess_lvl_1", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"start_root", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"start_lvl_1", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"start_lvl_2", BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    @Test
    public void shouldCreateVariablesInProcessScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("end").withVariable("variable", 123).create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).variableRecords()).hasSize(1)).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getScopeKey, VariableRecordValue::getName, VariableRecordValue::getValue}).describedAs("Expected the variable to be created in the scope of the process instance", new Object[0]).containsExactly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{processInstanceKey, "variable", "123"})});
    }

    @Test
    public void shouldWriteActivateCommandForStartingElement() {
        Record<DeploymentRecordValue> deploymentCreated = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().manualTask("task").endEvent().done()).deploy();
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)deploymentCreated.getValue()).getProcessesMetadata().get(0);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").create();
        Record taskActivateCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT)).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivateCommand.getValue())).hasProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).hasBpmnProcessId(deployedProcess.getBpmnProcessId()).hasVersion(deployedProcess.getVersion()).hasProcessInstanceKey(processInstanceKey).hasBpmnElementType(BpmnElementType.MANUAL_TASK).hasElementId("task").hasFlowScopeKey(processInstanceKey).hasParentProcessInstanceKey(-1L).hasParentElementInstanceKey(-1L);
    }

    @Test
    public void shouldWriteActivationEventsForScopes() {
        Record<DeploymentRecordValue> deploymentCreated = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().manualTask("task").endEvent()).endEvent().done()).deploy();
        ProcessMetadataValue deployedProcess = (ProcessMetadataValue)((DeploymentRecordValue)deploymentCreated.getValue()).getProcessesMetadata().get(0);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").create();
        ProcessInstanceRecordStream processActivationEvents = (ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).limit(2L);
        ((ListAssert)Assertions.assertThat((Stream)processActivationEvents).hasSize(2)).allSatisfy(record -> io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)record.getValue())).hasProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).hasBpmnProcessId(deployedProcess.getBpmnProcessId()).hasVersion(deployedProcess.getVersion()).hasProcessInstanceKey(processInstanceKey).hasBpmnElementType(BpmnElementType.PROCESS).hasElementId(PROCESS_ID).hasFlowScopeKey(-1L).hasParentProcessInstanceKey(-1L).hasParentElementInstanceKey(-1L));
        List subprocessActivationEvents = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).limit(2L)).toList();
        ((ListAssert)Assertions.assertThat((List)subprocessActivationEvents).hasSize(2)).allSatisfy(record -> io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)record.getValue())).hasProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).hasBpmnProcessId(deployedProcess.getBpmnProcessId()).hasVersion(deployedProcess.getVersion()).hasProcessInstanceKey(processInstanceKey).hasBpmnElementType(BpmnElementType.SUB_PROCESS).hasElementId("subprocess").hasFlowScopeKey(processInstanceKey).hasParentProcessInstanceKey(-1L).hasParentElementInstanceKey(-1L));
        Record taskActivateCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId("task").withIntent((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT)).getFirst();
        long subprocessElementInstanceKey = ((Record)subprocessActivationEvents.get(0)).getKey();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivateCommand.getValue())).hasProcessDefinitionKey(deployedProcess.getProcessDefinitionKey()).hasBpmnProcessId(deployedProcess.getBpmnProcessId()).hasVersion(deployedProcess.getVersion()).hasProcessInstanceKey(processInstanceKey).hasBpmnElementType(BpmnElementType.MANUAL_TASK).hasElementId("task").hasFlowScopeKey(subprocessElementInstanceKey).hasParentProcessInstanceKey(-1L).hasParentElementInstanceKey(-1L);
    }

    @Test
    public void shouldActivateTaskAndSubprocess() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().manualTask("task").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").withStartInstruction("subprocess").create();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to activate the subprocess twice", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldActivateSubprocessAndTask() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().manualTask("task").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("subprocess").withStartInstruction("task").create();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to activate the subprocess twice", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldSubscribeToProcessEvents() {
        String messageName = this.classRuleHelper.getMessageName();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("message-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().interrupting(false)).message(m -> m.name(messageName).zeebeCorrelationKeyExpression("key"))).endEvent()).eventSubProcess("timer-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().interrupting(false)).timerWithCycle("R/PT1H")).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").withVariable("key", "key-1").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.message().withName(messageName).withCorrelationKey("key-1").publish();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CORRELATED).withProcessInstanceKey(processInstanceKey).await();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.increaseTime(Duration.ofHours(1L));
        ((AbstractLongAssert)Assertions.assertThat((long)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).limit(2L)).count()).describedAs("Await until the events are triggered", new Object[0])).isEqualTo(2L);
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"message-event-subprocess", BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"timer-event-subprocess", BpmnElementType.EVENT_SUB_PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldSubscribeToScopeEvents() {
        String messageName = this.classRuleHelper.getMessageName();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", subprocess -> {
            subprocess.embeddedSubProcess().startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent();
            ((BoundaryEventBuilder)((BoundaryEventBuilder)subprocess.boundaryEvent("message-boundary-event").cancelActivity(Boolean.valueOf(false))).message(m -> m.name(messageName).zeebeCorrelationKeyExpression("key"))).endEvent();
            ((BoundaryEventBuilder)((BoundaryEventBuilder)subprocess.boundaryEvent("timer-boundary-event").cancelActivity(Boolean.valueOf(false))).timerWithCycle("R/PT1H")).endEvent();
        }).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task").withVariable("key", "key-1").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.message().withName(messageName).withCorrelationKey("key-1").publish();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CORRELATED).withProcessInstanceKey(processInstanceKey).await();
        RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.increaseTime(Duration.ofHours(1L));
        ((AbstractLongAssert)Assertions.assertThat((long)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BOUNDARY_EVENT).limit(2L)).count()).describedAs("Await until the events are triggered", new Object[0])).isEqualTo(2L);
        ENGINE.job().ofInstance(processInstanceKey).withType("task").complete();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{"subprocess", BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task", BpmnElementType.SERVICE_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{"message-boundary-event", BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{"timer-boundary-event", BpmnElementType.BOUNDARY_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldSubscribeToEventsOnlyOnce() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("message-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().interrupting(false)).message(m -> m.name("message").zeebeCorrelationKeyExpression("key"))).endEvent()).eventSubProcess("timer-event-subprocess", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().interrupting(false)).timerWithCycle("R/PT1H")).endEvent()).startEvent().parallelGateway("forking").manualTask("task1").parallelGateway("joining").moveToNode("forking").manualTask("task2").connectTo("joining").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("task1").withStartInstruction("task2").withVariable("key", "key-1").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId(), record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{PROCESS_ID, BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{"task1", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Tuple.tuple((Object[])new Object[]{"task2", BpmnElementType.MANUAL_TASK, ProcessInstanceIntent.ACTIVATE_ELEMENT})});
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).processMessageSubscriptionRecords().withProcessInstanceKey(processInstanceKey)).extracting(Record::getIntent).describedAs("Expected to create the message subscription only once", new Object[0]).containsOnlyOnce((Object[])new Intent[]{ProcessMessageSubscriptionIntent.CREATING});
        Assertions.assertThat((Stream)RecordingExporter.records().limitToProcessInstance(processInstanceKey).timerRecords().withProcessInstanceKey(processInstanceKey)).extracting(Record::getIntent).describedAs("Expected to create the timer only once", new Object[0]).containsOnlyOnce((Object[])new Intent[]{TimerIntent.CREATED});
    }

    @Test
    public void shouldActivateParallelGateway() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").userTask("A").moveToLastGateway().userTask("B").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction("fork").create();
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limit("fork", ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).describedAs("Expected to start process instance at parallel gateway", new Object[0]).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ACTIVATE_ELEMENT})})).containsSubsequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PARALLEL_GATEWAY, ProcessInstanceIntent.ELEMENT_COMPLETED})})).doesNotContain((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{BpmnElementType.START_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

