/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceModificationRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.ByteValue;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ModifyProcessInstanceRejectionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @ClassRule
    public static final BrokerClassRuleHelper CLASS_RULE_HELPER = new BrokerClassRuleHelper();
    private static final String PROCESS_ID = "process";
    private static final long MAX_MESSAGE_SIZE = ByteValue.ofMegabytes((long)4L);
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectCommandWhenProcessInstanceIsUnknown() {
        long unknownKey = 12345L;
        ENGINE.processInstance().withInstanceKey(12345L).modification().activateElement("A").expectRejection().modify();
        Record rejectionRecord = (Record)((ProcessInstanceModificationRecordStream)RecordingExporter.processInstanceModificationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceModificationIntent.MODIFY).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to modify process instance but no process instance found with key '%d'", 12345L)).hasKey(12345L);
    }

    @Test
    public void shouldRejectCommandWhenAtLeastOneActivateElementIdIsUnknown() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A").activateElement("B").activateElement("C").expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that elements with ids 'B' and 'C' are not found", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an element that could not be found: 'B', 'C'".formatted(PROCESS_ID));
    }

    @Test
    public void shouldRejectCommandWhenAtLeastOneTerminateElementInstanceKeyIsUnknown() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record userTaskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").getFirst();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(userTaskActivated.getKey()).terminateElement(123L).terminateElement(456L).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that element instance with key '123' and '456' are not found", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but it contains one or more terminate instructions with an element instance that could not be found: '123', '456'", PROCESS_ID));
    }

    @Test
    public void shouldRejectCommandWhenFlowScopeCantBeCreated() {
        ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("B").endEvent()).boundaryEvent().message(m -> m.name("message").zeebeCorrelationKeyExpression("missingVariable"))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that flow scope could not be created", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to subscribe to catch event(s) of 'sp' but failed to evaluate expression 'missingVariable': no variable found for name 'missingVariable'");
    }

    @Test
    public void shouldRejectCommandWhenItExceedsMaxMessageSize() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A").withGlobalVariables(Map.of("x", "x".repeat((int)(MAX_MESSAGE_SIZE - ByteValue.ofKilobytes((long)1L))))).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that message batch size too large", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Unable to modify process instance with key '%d' as the size exceeds the maximum batch size. Please reduce the size by splitting the modification into multiple commands.".formatted(processInstanceKey));
    }

    @Test
    public void shouldRejectCommandWhenVariableScopeIsUnknown() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withVariables("B", Map.of("var", "B")).withVariables("C", Map.of("var", "C")).activateElement("A").withVariables("D", Map.of("var", "D")).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that variable scopes with ids 'C' and 'D' are not found", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but it contains one or more variable instructions with a scope element id that could not be found: 'C', 'D'", PROCESS_ID));
    }

    @Test
    public void shouldRejectCommandWhenVariableScopeIsNotFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withVariables(PROCESS_ID, Map.of("var", PROCESS_ID)).withVariables("A", Map.of("var", "A")).activateElement("A").withVariables("B", Map.of("var", "B")).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that variable scopes with ids 'A' and 'B' are no flow scopes", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but it contains one or more variable instructions with a scope element that doesn't belong to the activating element's flow scope. These variables should be set before or after the modification.", PROCESS_ID));
    }

    @Test
    public void shouldRejectCommandWhenMoreThanOneAncestor() {
        String correlationKey = CLASS_RULE_HELPER.getCorrelationValue();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-subprocess", eventSubprocess -> ((StartEventBuilder)((StartEventBuilder)eventSubprocess.startEvent().interrupting(false)).message(m -> m.name("start").zeebeCorrelationKeyExpression("key"))).userTask("B").userTask("C").endEvent()).startEvent().userTask("A").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", correlationKey).create();
        ENGINE.message().withName("start").withCorrelationKey(correlationKey).publish();
        ENGINE.message().withName("start").withCorrelationKey(correlationKey).publish();
        ((AbstractLongAssert)Assertions.assertThat((long)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").limit(2L)).count()).describedAs("Assuming that two event subprocesses are active", new Object[0])).isEqualTo(2L);
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("C").expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that the flow scope can have only one instance", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but it contains one or more activate instructions for an element that has a flow scope with more than one active instance: 'event-subprocess'. Can't decide in which instance of the flow scope the element should be activated. Please specify an ancestor element instance key for this activate instruction.", PROCESS_ID));
    }

    @Test
    public void shouldRejectTerminationOfChildProcess() {
        String callActivityProcessId = "callActivityProcess";
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"callActivityProcess").startEvent().userTask("A").endEvent().done()).deploy();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("callActivity", callActivity -> callActivity.zeebeProcessId("callActivityProcess")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long userTaskKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withParentProcessInstanceKey(processInstanceKey).withElementId("A").getFirst()).getKey();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(userTaskKey).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that a child instance may not be terminated directly", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but the given instructions would terminate the instance. The instance was created by a call activity in the parent process. To terminate this instance please modify the parent process instead.", "callActivityProcess"));
    }

    @Test
    public void shouldRejectActivationWithNonExistingAncestor() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", 12345L).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that the ancestor with key 12345 is not found", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not exist, or is not in an active state: '12345'".formatted(PROCESS_ID));
    }

    @Test
    public void shouldRejectActivationWhenAncestorScopeIsActivating() {
        ENGINE.deployment().withXmlResource(((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("A").endEvent()).zeebeInputExpression("doesNotExist", "variable")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long subProcessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementId("sp").getFirst()).getKey();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", subProcessKey).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that activating an element in an ACTIVATING ancestor is not allowed", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not exist, or is not in an active state: '%d'".formatted(PROCESS_ID, subProcessKey));
    }

    @Test
    public void shouldRejectActivationWhenAncestorScopeIsCompleted() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().task("A").endEvent()).userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long subProcessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId("sp").getFirst()).getKey();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", subProcessKey).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that activating an element in a COMPLETING ancestor is not allowed", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not exist, or is not in an active state: '%d'".formatted(PROCESS_ID, subProcessKey));
    }

    @Test
    public void shouldRejectActivationWhenAncestorScopeIsTerminated() {
        ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("A").endEvent()).boundaryEvent("be", be -> be.message(m -> m.name("msg").zeebeCorrelationKeyExpression("=\"correlationKey\""))).cancelActivity(Boolean.valueOf(true))).userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.message().withName("msg").withCorrelationKey("correlationKey").publish();
        long subProcessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withProcessInstanceKey(processInstanceKey).withElementId("sp").getFirst()).getKey();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", subProcessKey).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that activating an element in a TERMINATING ancestor is not allowed", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not exist, or is not in an active state: '%d'".formatted(PROCESS_ID, subProcessKey));
    }

    @Test
    public void shouldRejectActivationWhenAncestorScopeIsNotFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("split").subProcess("subProcess1", sp -> sp.embeddedSubProcess().startEvent().manualTask("A").endEvent()).parallelGateway("join").moveToLastGateway().subProcess("subProcess2", sp2 -> sp2.embeddedSubProcess().startEvent().userTask("B").endEvent()).connectTo("join").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementId("subProcess1").await();
        Record subProcess2 = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("subProcess2").getFirst();
        Record taskB = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").getFirst();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", subProcess2.getKey()).activateElement("B", subProcess2.getKey()).activateElement("A", taskB.getKey()).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that subProcess2 cannot be selected as ancestor of task A", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that is not an ancestor of the element to activate:\n- instance '%s' of element 'subProcess2' is not an ancestor of element 'A'\n- instance '%s' of element 'B' is not an ancestor of element 'A'".formatted(PROCESS_ID, subProcess2.getKey(), taskB.getKey()));
    }

    @Test
    public void shouldRejectActivationOfMultiInstanceInstance() {
        ENGINE.deployment().withXmlResource(((SubProcessBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().manualTask("B").done()).multiInstance(m -> m.zeebeInputCollectionExpression("[1]"))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect we cannot activate an instance of the multi-instance", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process 'process' but it contains one or more activate instructions that would result in the activation of multi-instance element 'subprocess', which is currently unsupported.");
    }

    @Test
    public void shouldRejectSelectedAncestorIsMultiInstance() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("SubProcess", sub -> sub.multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("[1,2,3]")).zeebeInputElement("index")).parallel())).embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("A")).endEvent().subProcessDone().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("A").limit(3L)).describedAs("Wait until all service tasks have activated", new Object[0])).hasSize(3);
        long multiInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.MULTI_INSTANCE_BODY).getFirst()).getKey();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", multiInstanceKey).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that a multi-instance body may not be selected as ancestor", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but it contains one or more activate instructions that would result in the activation of multi-instance element 'SubProcess', which is currently unsupported.", PROCESS_ID));
    }

    @Test
    public void shouldRejectSelectedAncestorWouldActivateMultiInstance() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("SubProcess", sub -> sub.multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("[1]")).zeebeInputElement("index"))).embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("A")).endEvent().subProcessDone().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("A").await();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A", processInstanceKey).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that the activation of a multi-instance's descendant may not result in an activated multi-instance", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to modify instance of process '%s' but it contains one or more activate instructions that would result in the activation of multi-instance element 'SubProcess', which is currently unsupported.", PROCESS_ID));
    }

    @Test
    public void shouldRejectActivationWhenAncestorBelongsToDifferentProcessInstance() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("A").endEvent()).endEvent().done()).deploy();
        long processInstanceKeyOne = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKeyOne).withElementId("A").await();
        long processInstanceKeyTwo = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long subProcessKeyTwo = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKeyTwo).withElementId("A").getFirst()).getKey();
        Record<ProcessInstanceModificationRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKeyOne).modification().activateElement("A", subProcessKeyTwo).expectRejection().modify();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).describedAs("Expect that activating an element with ancestor key of a different process instance is not allowed", new Object[0])).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason("Expected to modify instance of process '%s' but it contains one or more activate instructions with an ancestor scope key that does not belong to the modified process instance: '%d'".formatted(PROCESS_ID, subProcessKeyTwo));
    }
}

