/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessInstanceCommandRejectionTest {
    private static final String PROCESS_ID = "process";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    @Test
    public void shouldRejectActivateIfFlowScopeIsActivating() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.zeebeInputExpression("notExisting", "x")).embeddedSubProcess().startEvent("subprocess-start").endEvent()).done());
        Record subprocessActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst();
        ProcessInstanceRecord startEventCommand = new ProcessInstanceRecord().setProcessDefinitionKey(((ProcessInstanceRecordValue)subprocessActivating.getValue()).getProcessDefinitionKey()).setProcessInstanceKey(processInstanceKey).setElementId("subprocess-start").setBpmnElementType(BpmnElementType.START_EVENT).setFlowScopeKey(subprocessActivating.getKey());
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.ACTIVATE_ELEMENT, (ProcessInstanceRecordValue)startEventCommand));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.START_EVENT).withElementId("subprocess-start").getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance to be in state '%s' but was '%s'.", ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_ACTIVATING));
    }

    @Test
    public void shouldRejectActivateIfFlowScopeIsCompleting() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", s -> ((SubProcessBuilder)s.zeebeOutputExpression("notExisting", "x")).embeddedSubProcess().startEvent("subprocess-start").endEvent()).done());
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).await();
        Record startEventActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.START_EVENT).withElementId("subprocess-start").getFirst();
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.ACTIVATE_ELEMENT, (ProcessInstanceRecordValue)startEventActivated.getValue()));
        Record rejectedCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.START_EVENT).withElementId("subprocess-start").skip(1L)).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance to be in state '%s' but was '%s'.", ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING));
    }

    @Test
    public void shouldRejectActivateIfFlowScopeIsCompleted() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent().done());
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        Record startEventActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.START_EVENT).getFirst();
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.ACTIVATE_ELEMENT, (ProcessInstanceRecordValue)startEventActivated.getValue()));
        Record rejectedCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.START_EVENT).skip(1L)).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance with key '%d' to be present in state but not found.", processInstanceKey));
    }

    @Test
    public void shouldRejectActivateIfFlowScopeIsTerminating() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").serviceTask("a", t -> t.zeebeJobType("a")).serviceTask("b", t -> t.zeebeJobType("b")).parallelGateway("join").moveToNode("fork").serviceTask("c", t -> t.zeebeJobType("c")).connectTo("join").endEvent().done());
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("a").getFirst();
        this.engine.writeRecords(this.jobCompleteCommand((Record<JobRecordValue>)jobCreated), this.cancelProcessInstanceCommand(processInstanceKey));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("b").getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance to be in state '%s' but was '%s'.", ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_TERMINATING));
    }

    @Test
    public void shouldRejectActivateIfFlowScopeIsTerminated() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).serviceTask("b", t -> t.zeebeJobType("b")).endEvent().done());
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.writeRecords(this.jobCompleteCommand((Record<JobRecordValue>)jobCreated), this.cancelProcessInstanceCommand(processInstanceKey));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("b").getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance with key '%d' to be present in state but not found.", processInstanceKey));
    }

    @Test
    public void shouldRejectActivateIfFlowScopeIsInterrupted() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("interrupt", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().interrupting(true)).timerWithDuration("PT1M")).endEvent()).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).serviceTask("b", t -> t.zeebeJobType("b")).endEvent().done());
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record taskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)taskActivated.getValue()).key(taskActivated.getKey()), this.triggerTimerCommand((Record<TimerRecordValue>)timerCreated));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ACTIVATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("b").getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance to be not interrupted but was interrupted by an event with id '%s'.", "interrupt"));
    }

    @Test
    public void shouldRejectCompleteIfFlowScopeIsTerminating() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).serviceTask("b", t -> t.zeebeJobType("b")).endEvent().done());
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.writeRecords(this.cancelProcessInstanceCommand(processInstanceKey), this.jobCompleteCommand((Record<JobRecordValue>)jobCreated));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.COMPLETE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("a").getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance to be in state '%s' but was '%s'.", ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_TERMINATING));
    }

    @Test
    public void shouldRejectCompleteIfFlowScopeIsInterrupted() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("interrupt", s -> ((StartEventBuilder)((StartEventBuilder)s.startEvent().interrupting(true)).timerWithDuration("PT1M")).endEvent()).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).serviceTask("b", t -> t.zeebeJobType("b")).endEvent().done());
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.writeRecords(this.jobCompleteCommand((Record<JobRecordValue>)jobCreated), this.triggerTimerCommand((Record<TimerRecordValue>)timerCreated));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.COMPLETE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("a").getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected flow scope instance to be not interrupted but was interrupted by an event with id '%s'.", "interrupt"));
    }

    @Test
    public void shouldRejectCompleteIfElementIsActivating() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> ((ServiceTaskBuilder)t.zeebeJobType("a")).zeebeInputExpression("notExisting", "x")).endEvent().done());
        Record taskActivating = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)taskActivating.getValue()).key(taskActivating.getKey()));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.COMPLETE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected element instance to be in state '%s' or one of '%s' but was '%s'.", ProcessInstanceIntent.ELEMENT_ACTIVATED, List.of(ProcessInstanceIntent.ELEMENT_COMPLETING), ProcessInstanceIntent.ELEMENT_ACTIVATING));
    }

    @Test
    public void shouldRejectCompleteIfElementIsCompleted() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).serviceTask("b", t -> t.zeebeJobType("b")).endEvent().done());
        Record taskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)taskActivated.getValue()).key(taskActivated.getKey()), RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)taskActivated.getValue()).key(taskActivated.getKey()));
        Record rejectedCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.COMPLETE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).withElementId("a").skip(1L)).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected element instance with key '%d' to be present in state but not found.", taskActivated.getKey()));
    }

    @Test
    public void shouldRejectCompleteIfElementIsTerminated() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).boundaryEvent("interrupt", b -> ((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT1M")).endEvent().done());
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.writeRecords(this.triggerTimerCommand((Record<TimerRecordValue>)timerCreated), this.jobCompleteCommand((Record<JobRecordValue>)jobCreated));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.COMPLETE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected element instance with key '%d' to be present in state but not found.", ((JobRecordValue)jobCreated.getValue()).getElementInstanceKey()));
    }

    @Test
    public void shouldRejectTerminateIfElementIsCompleted() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).done());
        Record taskActivated = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        this.engine.writeRecords(RecordToWrite.command().processInstance(ProcessInstanceIntent.COMPLETE_ELEMENT, (ProcessInstanceRecordValue)taskActivated.getValue()).key(taskActivated.getKey()), this.cancelProcessInstanceCommand(processInstanceKey));
        Record rejectedCommand = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.TERMINATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected element instance with key '%d' to be present in state but not found.", processInstanceKey));
    }

    @Test
    public void shouldRejectTerminateIfElementIsTerminating() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).done());
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        this.engine.writeRecords(this.cancelProcessInstanceCommand(processInstanceKey), this.cancelProcessInstanceCommand(processInstanceKey));
        Record rejectedCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.TERMINATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).skip(1L)).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected element instance to be in state '%s' or one of '%s' but was '%s'.", ProcessInstanceIntent.ELEMENT_ACTIVATING, List.of(ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING), ProcessInstanceIntent.ELEMENT_TERMINATING));
    }

    @Test
    public void shouldRejectTerminateIfElementIsTerminated() {
        long processInstanceKey = this.createProcessInstance(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("a", t -> t.zeebeJobType("a")).boundaryEvent("interrupt", b -> ((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(true))).timerWithDuration("PT1M")).endEvent().done());
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        Record jobCreated = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        this.engine.writeRecords(this.cancelProcessInstanceCommand(processInstanceKey), this.triggerTimerCommand((Record<TimerRecordValue>)timerCreated));
        Record rejectedCommand = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.TERMINATE_ELEMENT).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).skip(1L)).getFirst();
        this.assertThatCommandIsRejected((Record<ProcessInstanceRecordValue>)rejectedCommand, String.format("Expected element instance with key '%d' to be present in state but not found.", ((JobRecordValue)jobCreated.getValue()).getElementInstanceKey()));
    }

    private long createProcessInstance(BpmnModelInstance process) {
        this.engine.deployment().withXmlResource(process).deploy();
        return this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).create();
    }

    private RecordToWrite cancelProcessInstanceCommand(long processInstanceKey) {
        return RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)new ProcessInstanceRecord()).key(processInstanceKey);
    }

    private RecordToWrite jobCompleteCommand(Record<JobRecordValue> job) {
        return RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)job.getValue()).key(job.getKey());
    }

    private RecordToWrite triggerTimerCommand(Record<TimerRecordValue> timer) {
        return RecordToWrite.command().timer(TimerIntent.TRIGGER, (TimerRecordValue)timer.getValue()).key(timer.getKey());
    }

    private void assertThatCommandIsRejected(Record<ProcessInstanceRecordValue> command, String rejectionReason) {
        Record rejection = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyCommandRejections()).withProcessInstanceKey(((ProcessInstanceRecordValue)command.getValue()).getProcessInstanceKey()).getFirst();
        Assertions.assertThat((Record)rejection).hasIntent(command.getIntent()).hasSourceRecordPosition(command.getPosition()).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(rejectionReason);
    }
}

