/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.SignalSubscriptionRecordStream;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public final class SignalSubscriptionTest {
    private static final String SIGNAL_NAME1 = "startSignal1";
    private static final String EVENT_ID1 = "startEventId1";
    private static final String SIGNAL_NAME2 = "startSignal2";
    private static final String EVENT_ID2 = "startEventId2";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final BrokerClassRuleHelper brokerClassRuleHelper = new BrokerClassRuleHelper();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldOpenSignalSubscriptionOnDeployment() {
        String processId = Strings.newRandomValidBpmnId();
        this.engine.deployment().withXmlResource(SignalSubscriptionTest.createProcessWithOneSignalStartEvent(processId)).deploy();
        Record subscription = (Record)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withBpmnProcessId(processId).getFirst();
        Assertions.assertThat((String)((SignalSubscriptionRecordValue)subscription.getValue()).getCatchEventId()).isEqualTo(EVENT_ID1);
        Assertions.assertThat((String)((SignalSubscriptionRecordValue)subscription.getValue()).getSignalName()).isEqualTo(SIGNAL_NAME1);
    }

    @Test
    public void shouldOpenSubscriptionsForAllSignalStartEvents() {
        String processId = Strings.newRandomValidBpmnId();
        this.engine.deployment().withXmlResource(SignalSubscriptionTest.createProcessWithTwoSignalStartEvent(processId)).deploy();
        List subscriptions = ((SignalSubscriptionRecordStream)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withBpmnProcessId(processId).limit(2L)).asList();
        Assertions.assertThat((int)subscriptions.size()).isEqualTo(2);
        ((ListAssert)Assertions.assertThat((List)subscriptions).hasSize(2)).extracting(Record::getValue).extracting(s -> Assertions.tuple((Object[])new Object[]{s.getSignalName(), s.getCatchEventId()})).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{SIGNAL_NAME1, EVENT_ID1}), Assertions.tuple((Object[])new Object[]{SIGNAL_NAME2, EVENT_ID2})});
    }

    @Test
    public void shouldDeleteSubscriptionForOldVersions() {
        String processId = Strings.newRandomValidBpmnId();
        this.engine.deployment().withXmlResource(SignalSubscriptionTest.createProcessWithOneSignalStartEvent(processId)).deploy();
        this.engine.deployment().withXmlResource(SignalSubscriptionTest.createProcessWithOneSignalStartEvent(processId)).deploy();
        List subscriptions = ((SignalSubscriptionRecordStream)RecordingExporter.signalSubscriptionRecords().withBpmnProcessId(processId).limit(3L)).asList();
        List intents = subscriptions.stream().map(Record::getIntent).collect(Collectors.toList());
        Assertions.assertThat(intents).containsExactly((Object[])new Intent[]{SignalSubscriptionIntent.CREATED, SignalSubscriptionIntent.DELETED, SignalSubscriptionIntent.CREATED});
        long closingProcessDefinitionKey = ((SignalSubscriptionRecordValue)((Record)subscriptions.get(1)).getValue()).getProcessDefinitionKey();
        Assertions.assertThat((long)closingProcessDefinitionKey).isEqualTo(((SignalSubscriptionRecordValue)((Record)subscriptions.get(0)).getValue()).getProcessDefinitionKey());
    }

    @Test
    public void shouldDeleteSubscriptionsForAllSignalStartEvents() {
        String processId = Strings.newRandomValidBpmnId();
        this.engine.deployment().withXmlResource(SignalSubscriptionTest.createProcessWithTwoSignalStartEvent(processId)).deploy();
        long processDefinitionKey = ((Record)RecordingExporter.processRecords().getFirst()).getKey();
        this.engine.deployment().withXmlResource(SignalSubscriptionTest.createProcessWithTwoSignalStartEvent(processId)).deploy();
        Assertions.assertThat((Stream)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.DELETED).withBpmnProcessId(processId).limit(2L)).extracting(new Function[]{r -> ((SignalSubscriptionRecordValue)r.getValue()).getProcessDefinitionKey(), r -> ((SignalSubscriptionRecordValue)r.getValue()).getSignalName()}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processDefinitionKey, SIGNAL_NAME1}), Assertions.tuple((Object[])new Object[]{processDefinitionKey, SIGNAL_NAME2})});
    }

    private static BpmnModelInstance createProcessWithOneSignalStartEvent(String processId) {
        return ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent(EVENT_ID1).signal(s -> s.name(SIGNAL_NAME1).id("startSignalId"))).endEvent().done();
    }

    private static BpmnModelInstance createProcessWithTwoSignalStartEvent(String processId) {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)processId);
        ((StartEventBuilder)process.startEvent(EVENT_ID1).signal(s -> s.name(SIGNAL_NAME1).id("startSignalId1"))).endEvent();
        ((StartEventBuilder)process.startEvent(EVENT_ID2).signal(s -> s.name(SIGNAL_NAME2).id("startSignalId2"))).endEvent();
        return process.done();
    }
}

