/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.JsonUtil;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class JobInputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String initialVariables;
    @Parameterized.Parameter(value=1)
    public Consumer<ServiceTaskBuilder> mappings;
    @Parameterized.Parameter(value=2)
    public String expectedVariables;
    private String jobType;

    @Parameterized.Parameters(name="from {0} to {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"{}", JobInputMappingTest.mapping(b -> {}), "{}"}, {"{'x': 1, 'y': 2}", JobInputMappingTest.mapping(b -> {}), "{'x': 1, 'y': 2}"}, {"{'x': {'y': 2}}", JobInputMappingTest.mapping(b -> {}), "{'x': {'y': 2}}"}, {"{'x': 1}", JobInputMappingTest.mapping(b -> b.zeebeInputExpression("x", "y")), "{'x': 1, 'y': 1}"}, {"{'x': 1}", JobInputMappingTest.mapping(b -> ((ServiceTaskBuilder)b.zeebeInputExpression("x", "y")).zeebeInputExpression("x", "z")), "{'x': 1, 'y': 1, 'z': 1}"}, {"{'x': {'y': 2}}", JobInputMappingTest.mapping(b -> b.zeebeInputExpression("x.y", "y")), "{'x': {'y': 2}, 'y': 2}"}};
    }

    @Before
    public void setup() {
        this.jobType = Strings.newRandomValidBpmnId();
    }

    @Test
    public void shouldApplyInputMappings() {
        ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("service", builder -> {
            builder.zeebeJobType(this.jobType);
            this.mappings.accept((ServiceTaskBuilder)builder);
        }).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(this.initialVariables).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE_RULE.jobs().withType(this.jobType).activate();
        JobRecordValue jobRecordValue = (JobRecordValue)((JobBatchRecordValue)((Record)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATED).withType(this.jobType).getFirst()).getValue()).getJobs().get(0);
        Assertions.assertThat((Map)jobRecordValue.getVariables()).isEqualTo((Object)JsonUtil.fromJsonAsMap((String)this.expectedVariables));
    }

    private static Consumer<ServiceTaskBuilder> mapping(Consumer<ServiceTaskBuilder> mappingBuilder) {
        return mappingBuilder;
    }
}

