/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.mutable.MutableDecisionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateExtension;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ZeebeStateExtension.class})
public final class DecisionStateTest {
    private MutableZeebeState zeebeState;
    private MutableDecisionState decisionState;

    @BeforeEach
    public void setup() {
        this.decisionState = this.zeebeState.getDecisionState();
    }

    @DisplayName(value="should return empty if no decision is deployed")
    @Test
    void shouldReturnEmptyIfNoDecisionIsDeployedForDeploymentId() {
        Optional persistedDecision = this.decisionState.findLatestDecisionById(BufferUtil.wrapString((String)"decision-1"));
        Assertions.assertThat((Optional)persistedDecision).isEmpty();
    }

    @DisplayName(value="should return empty if no decision is deployed")
    @Test
    void shouldReturnEmptyIfNoDecisionIsDeployedForDeploymentKey() {
        Optional persistedDecision = this.decisionState.findDecisionByKey(1L);
        Assertions.assertThat((Optional)persistedDecision).isEmpty();
    }

    @DisplayName(value="should return empty if no DRG is deployed by ID")
    @Test
    void shouldReturnEmptyIfNoDrgIsDeployed() {
        Optional persistedDrg = this.decisionState.findLatestDecisionRequirementsById(BufferUtil.wrapString((String)"drg-1"));
        Assertions.assertThat((Optional)persistedDrg).isEmpty();
    }

    @DisplayName(value="should return empty if no DRG is deployed by key")
    @Test
    void shouldReturnEmptyIfNoDrgIsDeployedByKey() {
        Optional persistedDrg = this.decisionState.findDecisionRequirementsByKey(1L);
        Assertions.assertThat((Optional)persistedDrg).isEmpty();
    }

    @DisplayName(value="should put the decision and return it with all properties")
    @Test
    void shouldPutDecision() {
        DecisionRequirementsRecord drg = this.sampleDecisionRequirementsRecord();
        DecisionRecord decisionRecord = this.sampleDecisionRecord().setDecisionRequirementsKey(drg.getDecisionRequirementsKey());
        this.decisionState.storeDecisionRequirements(drg);
        this.decisionState.storeDecisionRecord(decisionRecord);
        Optional persistedDecision = this.decisionState.findLatestDecisionById(decisionRecord.getDecisionIdBuffer());
        Assertions.assertThat((Optional)persistedDecision).isNotEmpty();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecision)persistedDecision.get()).getDecisionId())).isEqualTo(decisionRecord.getDecisionId());
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecision)persistedDecision.get()).getDecisionName())).isEqualTo(decisionRecord.getDecisionName());
        Assertions.assertThat((long)((PersistedDecision)persistedDecision.get()).getDecisionKey()).isEqualTo(decisionRecord.getDecisionKey());
        Assertions.assertThat((int)((PersistedDecision)persistedDecision.get()).getVersion()).isEqualTo(decisionRecord.getVersion());
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecision)persistedDecision.get()).getDecisionRequirementsId())).isEqualTo(decisionRecord.getDecisionRequirementsId());
        Assertions.assertThat((long)((PersistedDecision)persistedDecision.get()).getDecisionRequirementsKey()).isEqualTo(decisionRecord.getDecisionRequirementsKey());
    }

    @DisplayName(value="should find deployed decision by ID")
    @Test
    void shouldFindDeployedDecisionById() {
        DecisionRecord decisionRecord1 = this.sampleDecisionRecord().setDecisionId("decision-1").setDecisionKey(1L);
        DecisionRecord decisionRecord2 = this.sampleDecisionRecord().setDecisionId("decision-2").setDecisionKey(2L);
        DecisionRequirementsRecord drg = this.sampleDecisionRequirementsRecord();
        this.decisionState.storeDecisionRequirements(drg);
        this.decisionState.storeDecisionRecord(decisionRecord1);
        this.decisionState.storeDecisionRecord(decisionRecord2);
        Optional persistedDecision1 = this.decisionState.findLatestDecisionById(decisionRecord1.getDecisionIdBuffer());
        Optional persistedDecision2 = this.decisionState.findLatestDecisionById(decisionRecord2.getDecisionIdBuffer());
        Assertions.assertThat((Optional)persistedDecision1).isNotEmpty();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecision)persistedDecision1.get()).getDecisionId())).isEqualTo(decisionRecord1.getDecisionId());
        Assertions.assertThat((Optional)persistedDecision2).isNotEmpty();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecision)persistedDecision2.get()).getDecisionId())).isEqualTo(decisionRecord2.getDecisionId());
    }

    @DisplayName(value="should find deployed decision by KEY")
    @Test
    void shouldFindDeployedDecisionByKey() {
        DecisionRecord decisionRecord1 = this.sampleDecisionRecord().setDecisionId("decision-1").setDecisionKey(1L);
        DecisionRecord decisionRecord2 = this.sampleDecisionRecord().setDecisionId("decision-2").setDecisionKey(2L);
        DecisionRequirementsRecord drg = this.sampleDecisionRequirementsRecord();
        this.decisionState.storeDecisionRequirements(drg);
        this.decisionState.storeDecisionRecord(decisionRecord1);
        this.decisionState.storeDecisionRecord(decisionRecord2);
        Optional persistedDecision1 = this.decisionState.findDecisionByKey(decisionRecord1.getDecisionKey());
        Optional persistedDecision2 = this.decisionState.findDecisionByKey(decisionRecord2.getDecisionKey());
        Assertions.assertThat((Optional)persistedDecision1).isNotEmpty();
        Assertions.assertThat((long)((PersistedDecision)persistedDecision1.get()).getDecisionKey()).isEqualTo(decisionRecord1.getDecisionKey());
        Assertions.assertThat((Optional)persistedDecision2).isNotEmpty();
        Assertions.assertThat((long)((PersistedDecision)persistedDecision2.get()).getDecisionKey()).isEqualTo(decisionRecord2.getDecisionKey());
    }

    @DisplayName(value="should return the latest version of the deployed decision by ID")
    @Test
    void shouldReturnLatestVersionOfDeployedDecisionById() {
        DecisionRequirementsRecord drgV1 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(1L);
        DecisionRequirementsRecord drgV2 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(2L);
        DecisionRequirementsRecord drgV3 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(3L);
        DecisionRecord decisionRecordV1 = this.sampleDecisionRecord().setDecisionKey(1L).setDecisionRequirementsKey(drgV1.getDecisionRequirementsKey()).setVersion(1);
        DecisionRecord decisionRecordV2 = this.sampleDecisionRecord().setDecisionKey(2L).setDecisionRequirementsKey(drgV2.getDecisionRequirementsKey()).setVersion(2);
        DecisionRecord decisionRecordV3 = this.sampleDecisionRecord().setDecisionKey(3L).setDecisionRequirementsKey(drgV3.getDecisionRequirementsKey()).setVersion(3);
        this.decisionState.storeDecisionRequirements(drgV1);
        this.decisionState.storeDecisionRequirements(drgV2);
        this.decisionState.storeDecisionRequirements(drgV3);
        this.decisionState.storeDecisionRecord(decisionRecordV1);
        this.decisionState.storeDecisionRecord(decisionRecordV3);
        this.decisionState.storeDecisionRecord(decisionRecordV2);
        Optional persistedDecision = this.decisionState.findLatestDecisionById(decisionRecordV1.getDecisionIdBuffer());
        Assertions.assertThat((Optional)persistedDecision).isNotEmpty();
        Assertions.assertThat((int)((PersistedDecision)persistedDecision.get()).getVersion()).isEqualTo(decisionRecordV3.getVersion());
    }

    @DisplayName(value="should put the DRG and return it with all properties")
    @Test
    void shouldPutDecisionRequirements() {
        DecisionRequirementsRecord drg = this.sampleDecisionRequirementsRecord();
        this.decisionState.storeDecisionRequirements(drg);
        Optional persistedDrg = this.decisionState.findLatestDecisionRequirementsById(drg.getDecisionRequirementsIdBuffer());
        Assertions.assertThat((Optional)persistedDrg).isNotEmpty();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecisionRequirements)persistedDrg.get()).getDecisionRequirementsId())).isEqualTo(drg.getDecisionRequirementsId());
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecisionRequirements)persistedDrg.get()).getDecisionRequirementsName())).isEqualTo(drg.getDecisionRequirementsName());
        Assertions.assertThat((long)((PersistedDecisionRequirements)persistedDrg.get()).getDecisionRequirementsKey()).isEqualTo(drg.getDecisionRequirementsKey());
        Assertions.assertThat((int)((PersistedDecisionRequirements)persistedDrg.get()).getDecisionRequirementsVersion()).isEqualTo(drg.getDecisionRequirementsVersion());
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecisionRequirements)persistedDrg.get()).getResourceName())).isEqualTo(drg.getResourceName());
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])BufferUtil.bufferAsArray((DirectBuffer)((PersistedDecisionRequirements)persistedDrg.get()).getResource())).describedAs("Expect resource to be equal", new Object[0])).isEqualTo((Object)drg.getResource());
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])BufferUtil.bufferAsArray((DirectBuffer)((PersistedDecisionRequirements)persistedDrg.get()).getChecksum())).describedAs("Expect checksum to be equal", new Object[0])).isEqualTo((Object)drg.getChecksum());
    }

    @DisplayName(value="should find deployed DRGs by ID")
    @Test
    void shouldFindDeployedDecisionRequirementsById() {
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsId("drg-1").setDecisionRequirementsKey(1L);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsId("drg-2").setDecisionRequirementsKey(2L);
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        Optional persistedDrg1 = this.decisionState.findLatestDecisionRequirementsById(drg1.getDecisionRequirementsIdBuffer());
        Optional persistedDrg2 = this.decisionState.findLatestDecisionRequirementsById(drg2.getDecisionRequirementsIdBuffer());
        Assertions.assertThat((Optional)persistedDrg1).isNotEmpty();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecisionRequirements)persistedDrg1.get()).getDecisionRequirementsId())).isEqualTo(drg1.getDecisionRequirementsId());
        Assertions.assertThat((Optional)persistedDrg2).isNotEmpty();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)((PersistedDecisionRequirements)persistedDrg2.get()).getDecisionRequirementsId())).isEqualTo(drg2.getDecisionRequirementsId());
    }

    @DisplayName(value="should return the latest version of the deployed DRG by ID")
    @Test
    void shouldReturnLatestVersionOfDeployedDecisionRequirementsById() {
        DecisionRequirementsRecord decisionRecordV1 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(1L).setDecisionRequirementsVersion(1);
        DecisionRequirementsRecord decisionRecordV2 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(2L).setDecisionRequirementsVersion(2);
        DecisionRequirementsRecord decisionRecordV3 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(3L).setDecisionRequirementsVersion(3);
        this.decisionState.storeDecisionRequirements(decisionRecordV1);
        this.decisionState.storeDecisionRequirements(decisionRecordV3);
        this.decisionState.storeDecisionRequirements(decisionRecordV2);
        Optional persistedDrg = this.decisionState.findLatestDecisionRequirementsById(decisionRecordV1.getDecisionRequirementsIdBuffer());
        Assertions.assertThat((Optional)persistedDrg).isNotEmpty();
        Assertions.assertThat((int)((PersistedDecisionRequirements)persistedDrg.get()).getDecisionRequirementsVersion()).isEqualTo(decisionRecordV3.getDecisionRequirementsVersion());
    }

    @DisplayName(value="should find deployed DRGs by key")
    @Test
    void shouldFindDeployedDecisionRequirementsByKey() {
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(1L);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(2L);
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        Optional persistedDrg1 = this.decisionState.findDecisionRequirementsByKey(drg1.getDecisionRequirementsKey());
        Optional persistedDrg2 = this.decisionState.findDecisionRequirementsByKey(drg2.getDecisionRequirementsKey());
        Assertions.assertThat((Optional)persistedDrg1).isNotEmpty();
        Assertions.assertThat((long)((PersistedDecisionRequirements)persistedDrg1.get()).getDecisionRequirementsKey()).isEqualTo(drg1.getDecisionRequirementsKey());
        Assertions.assertThat((Optional)persistedDrg2).isNotEmpty();
        Assertions.assertThat((long)((PersistedDecisionRequirements)persistedDrg2.get()).getDecisionRequirementsKey()).isEqualTo(drg2.getDecisionRequirementsKey());
    }

    @DisplayName(value="should return empty if no decision found for DRG key")
    @Test
    void shouldReturnEmptyIfNoDecisionFoundForDrgKey() {
        long unknownDrgKey = 1L;
        List decisions = this.decisionState.findDecisionsByDecisionRequirementsKey(1L);
        Assertions.assertThat((List)decisions).isEmpty();
    }

    @DisplayName(value="should find decisions by DRG key")
    @Test
    void shouldFindDecisionsByDrgKey() {
        DecisionRequirementsRecord drg1 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(10L);
        DecisionRequirementsRecord drg2 = this.sampleDecisionRequirementsRecord().setDecisionRequirementsKey(20L);
        DecisionRecord decision1 = this.sampleDecisionRecord().setDecisionKey(1L).setDecisionRequirementsKey(drg1.getDecisionRequirementsKey());
        DecisionRecord decision2 = this.sampleDecisionRecord().setDecisionKey(2L).setDecisionRequirementsKey(drg1.getDecisionRequirementsKey());
        DecisionRecord decision3 = this.sampleDecisionRecord().setDecisionKey(3L).setDecisionRequirementsKey(drg2.getDecisionRequirementsKey());
        this.decisionState.storeDecisionRequirements(drg1);
        this.decisionState.storeDecisionRequirements(drg2);
        this.decisionState.storeDecisionRecord(decision1);
        this.decisionState.storeDecisionRecord(decision2);
        this.decisionState.storeDecisionRecord(decision3);
        List decisionsOfDrg1 = this.decisionState.findDecisionsByDecisionRequirementsKey(drg1.getDecisionRequirementsKey());
        List decisionsOfDrg2 = this.decisionState.findDecisionsByDecisionRequirementsKey(drg2.getDecisionRequirementsKey());
        ((ListAssert)Assertions.assertThat((List)decisionsOfDrg1).hasSize(2)).extracting(PersistedDecision::getDecisionKey).contains((Object[])new Long[]{decision1.getDecisionKey(), decision2.getDecisionKey()});
        ((ListAssert)Assertions.assertThat((List)decisionsOfDrg2).hasSize(1)).extracting(PersistedDecision::getDecisionKey).contains((Object[])new Long[]{decision3.getDecisionKey()});
    }

    private DecisionRecord sampleDecisionRecord() {
        return new DecisionRecord().setDecisionId("decision-id").setDecisionName("decision-name").setVersion(1).setDecisionKey(1L).setDecisionRequirementsId("drg-id").setDecisionRequirementsKey(1L);
    }

    private DecisionRequirementsRecord sampleDecisionRequirementsRecord() {
        return new DecisionRequirementsRecord().setDecisionRequirementsId("drg-id").setDecisionRequirementsName("drg-name").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(1L).setNamespace("namespace").setResourceName("resource-name").setChecksum(BufferUtil.wrapString((String)"checksum")).setResource(BufferUtil.wrapString((String)"dmn-resource"));
    }
}

