/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.engine.state.mutable.MutableDeploymentState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.apache.commons.lang3.tuple.Triple;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DeploymentStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableDeploymentState deploymentState;

    @Before
    public void setUp() {
        MutableZeebeState zeebeState = this.stateRule.getZeebeState();
        this.deploymentState = zeebeState.getDeploymentState();
    }

    @Test
    public void shouldReturnFalseOnEmptyStateForHasPendingCheck() {
        boolean hasPending = this.deploymentState.hasPendingDeploymentDistribution(10L);
        Assertions.assertThat((boolean)hasPending).isFalse();
    }

    @Test
    public void shouldAddPendingDeployment() {
        long deploymentKey = 10L;
        boolean partition = true;
        this.deploymentState.addPendingDeploymentDistribution(10L, 1);
        Assertions.assertThat((boolean)this.deploymentState.hasPendingDeploymentDistribution(10L)).isTrue();
    }

    @Test
    public void shouldReturnFalseForDifferentPendingDeploymentOnHasPendingCheck() {
        long deploymentKey = 10L;
        boolean partition = true;
        this.deploymentState.addPendingDeploymentDistribution(10L, 1);
        boolean hasPending = this.deploymentState.hasPendingDeploymentDistribution(12L);
        Assertions.assertThat((boolean)hasPending).isFalse();
    }

    @Test
    public void shouldRemovePendingDeployment() {
        long deploymentKey = 10L;
        boolean partition = true;
        this.deploymentState.addPendingDeploymentDistribution(10L, 1);
        this.deploymentState.removePendingDeploymentDistribution(10L, 1);
        Assertions.assertThat((boolean)this.deploymentState.hasPendingDeploymentDistribution(10L)).isFalse();
    }

    @Test
    public void shouldReturnTrueForDifferentPendingDeploymentOnHasPendingCheck() {
        long deploymentKey = 10L;
        boolean partition = true;
        this.deploymentState.addPendingDeploymentDistribution(10L, 1);
        this.deploymentState.addPendingDeploymentDistribution(12L, 1);
        this.deploymentState.removePendingDeploymentDistribution(10L, 1);
        boolean hasPending = this.deploymentState.hasPendingDeploymentDistribution(12L);
        Assertions.assertThat((boolean)hasPending).isTrue();
    }

    @Test
    public void shouldReturnNullOnRequestingStoredDeploymentWhenNothingStored() {
        DeploymentRecord storedDeploymentRecord = this.deploymentState.getStoredDeploymentRecord(1L);
        Assertions.assertThat((Object)storedDeploymentRecord).isNull();
    }

    @Test
    public void shouldRemoveDeploymentIdempotent() {
        this.deploymentState.removeDeploymentRecord(1L);
        DeploymentRecord storedDeploymentRecord = this.deploymentState.getStoredDeploymentRecord(1L);
        Assertions.assertThat((Object)storedDeploymentRecord).isNull();
    }

    @Test
    public void shouldStoreDeploymentInState() {
        DeploymentRecord deployment = this.createDeployment();
        this.deploymentState.storeDeploymentRecord(1L, deployment);
        DeploymentRecord storedDeploymentRecord = this.deploymentState.getStoredDeploymentRecord(1L);
        ((ObjectAssert)Assertions.assertThat((Object)storedDeploymentRecord).isNotNull()).isEqualTo((Object)deployment);
    }

    @Test
    public void shouldRemoveStoredDeployment() {
        DeploymentRecord deployment = this.createDeployment();
        this.deploymentState.storeDeploymentRecord(1L, deployment);
        this.deploymentState.removeDeploymentRecord(1L);
        DeploymentRecord storedDeploymentRecord = this.deploymentState.getStoredDeploymentRecord(1L);
        Assertions.assertThat((Object)storedDeploymentRecord).isNull();
    }

    @Test
    public void shouldRemoveDifferentDeployment() {
        DeploymentRecord deployment = this.createDeployment();
        this.deploymentState.storeDeploymentRecord(1L, deployment);
        this.deploymentState.storeDeploymentRecord(2L, deployment);
        this.deploymentState.removeDeploymentRecord(2L);
        DeploymentRecord storedDeploymentRecord = this.deploymentState.getStoredDeploymentRecord(2L);
        Assertions.assertThat((Object)storedDeploymentRecord).isNull();
        storedDeploymentRecord = this.deploymentState.getStoredDeploymentRecord(1L);
        ((ObjectAssert)Assertions.assertThat((Object)storedDeploymentRecord).isNotNull()).isEqualTo((Object)deployment);
    }

    @Test
    public void shouldIterateOverPendingDeployments() {
        DeploymentRecord deployment = this.createDeployment();
        this.deploymentState.storeDeploymentRecord(1L, deployment);
        boolean deploymentKey = true;
        this.deploymentState.addPendingDeploymentDistribution(1L, 2);
        this.deploymentState.addPendingDeploymentDistribution(1L, 3);
        ArrayList pendings = new ArrayList();
        this.deploymentState.foreachPendingDeploymentDistribution((key, partitionId, deploymentBuffer) -> pendings.add(Triple.of((Object)key, (Object)partitionId, (Object)deploymentBuffer)));
        Assertions.assertThat(pendings).extracting(Triple::getLeft).containsOnly((Object[])new Long[]{1L});
        Assertions.assertThat(pendings).extracting(Triple::getMiddle).containsExactly((Object[])new Integer[]{2, 3});
        Assertions.assertThat(pendings).extracting(Triple::getRight).containsOnly((Object[])new DirectBuffer[]{BufferUtil.createCopy((BufferWriter)deployment)});
    }

    @Test
    public void shouldIterateOverMultiplePendingDeployments() {
        ArrayList<DeploymentRecord> deployments = new ArrayList<DeploymentRecord>();
        for (int deploymentKey = 1; deploymentKey <= 5; ++deploymentKey) {
            DeploymentRecord deployment = this.createDeployment();
            deployments.add(deployment);
            this.deploymentState.storeDeploymentRecord((long)deploymentKey, deployment);
            this.deploymentState.addPendingDeploymentDistribution((long)deploymentKey, 2);
            this.deploymentState.addPendingDeploymentDistribution((long)deploymentKey, 3);
        }
        ArrayList pendings = new ArrayList();
        this.deploymentState.foreachPendingDeploymentDistribution((key, partitionId, deploymentBuffer) -> pendings.add(Triple.of((Object)key, (Object)partitionId, (Object)deploymentBuffer)));
        Assertions.assertThat(pendings).hasSize(10);
        Assertions.assertThat(pendings).extracting(Triple::getLeft).containsOnly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        Assertions.assertThat(pendings).extracting(Triple::getMiddle).containsOnly((Object[])new Integer[]{2, 3});
        Assertions.assertThat(pendings).extracting(Triple::getRight).containsOnly((Object[])deployments.stream().map(BufferUtil::createCopy).collect(Collectors.toList()).toArray(new DirectBuffer[deployments.size()]));
    }

    @Test
    public void shouldNotFailOnMissingDeploymentInState() {
        boolean deploymentKey = true;
        this.deploymentState.addPendingDeploymentDistribution(1L, 2);
        this.deploymentState.addPendingDeploymentDistribution(1L, 3);
        ArrayList pendings = new ArrayList();
        this.deploymentState.foreachPendingDeploymentDistribution((key, partitionId, deploymentBuffer) -> pendings.add(Triple.of((Object)key, (Object)partitionId, (Object)deploymentBuffer)));
        Assertions.assertThat(pendings).isEmpty();
    }

    private DeploymentRecord createDeployment() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        ((DeploymentResource)deploymentRecord.resources().add()).setResourceName(BufferUtil.wrapString((String)"resource")).setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance)));
        ((ProcessMetadata)deploymentRecord.processesMetadata().add()).setChecksum(BufferUtil.wrapString((String)"checksum")).setBpmnProcessId("process").setKey(1L).setVersion(1).setResourceName(BufferUtil.wrapString((String)"resource"));
        return deploymentRecord;
    }
}

