/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessStateTest {
    private static final Long FIRST_PROCESS_KEY = Protocol.encodePartitionId((int)1, (long)1L);
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableProcessState processState;
    private MutableZeebeState zeebeState;

    @Before
    public void setUp() {
        this.zeebeState = this.stateRule.getZeebeState();
        this.processState = this.zeebeState.getProcessState();
    }

    @Test
    public void shouldGetInitialProcessVersion() {
        long nextProcessVersion = this.processState.getProcessVersion("foo");
        Assertions.assertThat((long)nextProcessVersion).isZero();
    }

    @Test
    public void shouldGetProcessVersion() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        long processVersion = this.processState.getProcessVersion("processId");
        Assertions.assertThat((long)processVersion).isEqualTo(1L);
    }

    @Test
    public void shouldIncrementProcessVersion() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        ProcessRecord processRecord2 = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        long processVersion = this.processState.getProcessVersion("processId");
        Assertions.assertThat((long)processVersion).isEqualTo(2L);
    }

    @Test
    public void shouldNotIncrementProcessVersionForDifferentProcessId() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        ProcessRecord processRecord2 = ProcessStateTest.creatingProcessRecord(this.zeebeState, "other");
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        long processVersion = this.processState.getProcessVersion("processId");
        Assertions.assertThat((long)processVersion).isEqualTo(1L);
        long otherversion = this.processState.getProcessVersion("other");
        Assertions.assertThat((long)otherversion).isEqualTo(1L);
    }

    @Test
    public void shouldReturnNullOnGetLatest() {
        DeployedProcess deployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"deployedProcess"));
        Assertions.assertThat((Object)deployedProcess).isNull();
    }

    @Test
    public void shouldReturnNullOnGetProcessByKey() {
        DeployedProcess deployedProcess = this.processState.getProcessByKey(0L);
        Assertions.assertThat((Object)deployedProcess).isNull();
    }

    @Test
    public void shouldReturnNullOnGetProcessByProcessIdAndVersion() {
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"foo"), 0);
        Assertions.assertThat((Object)deployedProcess).isNull();
    }

    @Test
    public void shouldReturnEmptyListOnGetProcesses() {
        Collection deployedProcess = this.processState.getProcesses();
        Assertions.assertThat((Collection)deployedProcess).isEmpty();
    }

    @Test
    public void shouldReturnEmptyListOnGetProcessesByProcessId() {
        Collection deployedProcess = this.processState.getProcessesByBpmnProcessId(BufferUtil.wrapString((String)"foo"));
        Assertions.assertThat((Collection)deployedProcess).isEmpty();
    }

    @Test
    public void shouldPutDeploymentToState() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.zeebeState);
        this.processState.putDeployment(deploymentRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
    }

    @Test
    public void shouldPutProcessToState() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo(processRecord.getKey());
        Assertions.assertThat((Comparable)deployedProcess.getResource()).isEqualTo((Object)processRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)processRecord.getResourceNameBuffer());
        DeployedProcess processByKey = this.processState.getProcessByKey(processRecord.getKey());
        Assertions.assertThat((Object)processByKey).isNotNull();
        Assertions.assertThat((Comparable)processByKey.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((int)processByKey.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)processByKey.getKey()).isEqualTo(processRecord.getKey());
        Assertions.assertThat((Comparable)processByKey.getResource()).isEqualTo((Object)processRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)processByKey.getResourceName()).isEqualTo((Object)processRecord.getResourceNameBuffer());
    }

    @Test
    public void shouldUpdateLatestDigestOnPutProcessToState() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        DirectBuffer checksum = this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((Comparable)checksum).isEqualTo((Object)processRecord.getChecksumBuffer());
    }

    @Test
    public void shouldUpdateLatestProcessOnPutProcessToState() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.zeebeState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        DeployedProcess deployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo(processRecord.getKey());
        Assertions.assertThat((Comparable)deployedProcess.getResource()).isEqualTo((Object)processRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)processRecord.getResourceNameBuffer());
    }

    @Test
    public void shouldNotOverwritePreviousRecord() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.zeebeState);
        this.processState.putDeployment(deploymentRecord);
        ((ProcessMetadata)deploymentRecord.processesMetadata().iterator().next()).setKey(212L).setBpmnProcessId("other");
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        Assertions.assertThat((long)deployedProcess.getKey()).isNotEqualTo(((ProcessMetadata)deploymentRecord.processesMetadata().iterator().next()).getKey());
        Assertions.assertThat((Comparable)((ProcessMetadata)deploymentRecord.processesMetadata().iterator().next()).getBpmnProcessIdBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"other"));
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
    }

    @Test
    public void shouldStoreDifferentProcessVersionsOnPutDeployments() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        DeployedProcess secondProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 2);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Object)secondProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)secondProcess.getBpmnProcessId());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)secondProcess.getResourceName());
        Assertions.assertThat((long)deployedProcess.getKey()).isNotEqualTo(secondProcess.getKey());
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)secondProcess.getVersion()).isEqualTo(2);
    }

    @Test
    public void shouldRestartVersionCountOnDifferentProcessId() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState, "otherId"));
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        DeployedProcess secondProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"otherId"), 1);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Object)secondProcess).isNotNull();
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo((Object)FIRST_PROCESS_KEY);
        Assertions.assertThat((long)secondProcess.getKey()).isEqualTo(FIRST_PROCESS_KEY + 1L);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)secondProcess.getVersion()).isEqualTo(1);
    }

    @Test
    public void shouldGetLatestDeployedProcess() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        DeployedProcess latestProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"));
        DeployedProcess firstProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        DeployedProcess secondProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 2);
        Assertions.assertThat((Object)latestProcess).isNotNull();
        Assertions.assertThat((Object)firstProcess).isNotNull();
        Assertions.assertThat((Object)secondProcess).isNotNull();
        Assertions.assertThat((Comparable)latestProcess.getBpmnProcessId()).isEqualTo((Object)secondProcess.getBpmnProcessId());
        Assertions.assertThat((long)firstProcess.getKey()).isNotEqualTo(latestProcess.getKey());
        Assertions.assertThat((long)latestProcess.getKey()).isEqualTo(secondProcess.getKey());
        Assertions.assertThat((Comparable)latestProcess.getResourceName()).isEqualTo((Object)secondProcess.getResourceName());
        Assertions.assertThat((Comparable)latestProcess.getResource()).isEqualTo((Object)secondProcess.getResource());
        Assertions.assertThat((int)firstProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)latestProcess.getVersion()).isEqualTo(2);
        Assertions.assertThat((int)secondProcess.getVersion()).isEqualTo(2);
    }

    @Test
    public void shouldGetLatestDeployedProcessAfterDeploymentWasAdded() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        DeployedProcess firstLatest = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        DeployedProcess latestProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((Object)firstLatest).isNotNull();
        Assertions.assertThat((Object)latestProcess).isNotNull();
        Assertions.assertThat((Comparable)firstLatest.getBpmnProcessId()).isEqualTo((Object)latestProcess.getBpmnProcessId());
        Assertions.assertThat((long)latestProcess.getKey()).isNotEqualTo(firstLatest.getKey());
        Assertions.assertThat((Comparable)firstLatest.getResourceName()).isEqualTo((Object)latestProcess.getResourceName());
        Assertions.assertThat((int)latestProcess.getVersion()).isEqualTo(2);
        Assertions.assertThat((int)firstLatest.getVersion()).isEqualTo(1);
    }

    @Test
    public void shouldGetExecutableProcess() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.zeebeState);
        this.processState.putDeployment(deploymentRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1);
        ExecutableProcess process = deployedProcess.getProcess();
        Assertions.assertThat((Object)process).isNotNull();
        AbstractFlowElement serviceTask = process.getElementById(BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Object)serviceTask).isNotNull();
    }

    @Test
    public void shouldGetExecutableProcessByKey() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.zeebeState);
        this.processState.putDeployment(deploymentRecord);
        long processDefinitionKey = FIRST_PROCESS_KEY;
        DeployedProcess deployedProcess = this.processState.getProcessByKey(processDefinitionKey);
        ExecutableProcess process = deployedProcess.getProcess();
        Assertions.assertThat((Object)process).isNotNull();
        AbstractFlowElement serviceTask = process.getElementById(BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Object)serviceTask).isNotNull();
    }

    @Test
    public void shouldGetExecutableProcessByLatestProcess() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.zeebeState);
        this.processState.putDeployment(deploymentRecord);
        DeployedProcess deployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"));
        ExecutableProcess process = deployedProcess.getProcess();
        Assertions.assertThat((Object)process).isNotNull();
        AbstractFlowElement serviceTask = process.getElementById(BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Object)serviceTask).isNotNull();
    }

    @Test
    public void shouldGetAllProcesses() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState, "otherId"));
        Collection processes = this.processState.getProcesses();
        Assertions.assertThat((int)processes.size()).isEqualTo(3);
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getBpmnProcessId).contains((Object[])new DirectBuffer[]{BufferUtil.wrapString((String)"processId"), BufferUtil.wrapString((String)"otherId")});
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getVersion).contains((Object[])new Integer[]{1, 2, 1});
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getKey).containsOnly((Object[])new Long[]{FIRST_PROCESS_KEY, FIRST_PROCESS_KEY + 1L, FIRST_PROCESS_KEY + 2L});
    }

    @Test
    public void shouldGetAllProcessesWithProcessId() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        Collection processes = this.processState.getProcessesByBpmnProcessId(BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getBpmnProcessId).containsOnly((Object[])new DirectBuffer[]{BufferUtil.wrapString((String)"processId")});
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getVersion).containsOnly((Object[])new Integer[]{1, 2});
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getKey).containsOnly((Object[])new Long[]{FIRST_PROCESS_KEY, FIRST_PROCESS_KEY + 1L});
    }

    @Test
    public void shouldNotGetProcessesWithOtherProcessId() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState, "otherId"));
        Collection processes = this.processState.getProcessesByBpmnProcessId(BufferUtil.wrapString((String)"otherId"));
        Assertions.assertThat((int)processes.size()).isEqualTo(1);
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getBpmnProcessId).containsOnly((Object[])new DirectBuffer[]{BufferUtil.wrapString((String)"otherId")});
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getVersion).containsOnly((Object[])new Integer[]{1});
        long expectedProcessDefinitionKey = Protocol.encodePartitionId((int)1, (long)2L);
        Assertions.assertThat((Collection)processes).extracting(DeployedProcess::getKey).containsOnly((Object[])new Long[]{expectedProcessDefinitionKey});
    }

    @Test
    public void shouldReturnHighestVersionInsteadOfMostRecent() {
        String processId = "process";
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState, "process", 2));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.zeebeState, "process", 1));
        DeployedProcess latestProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"process"));
        Assertions.assertThat((int)latestProcess.getVersion()).isEqualTo(2);
    }

    public static DeploymentRecord creatingDeploymentRecord(MutableZeebeState zeebeState) {
        return ProcessStateTest.creatingDeploymentRecord(zeebeState, "processId");
    }

    public static DeploymentRecord creatingDeploymentRecord(MutableZeebeState zeebeState, String processId) {
        MutableProcessState processState = zeebeState.getProcessState();
        int version = processState.getProcessVersion(processId) + 1;
        return ProcessStateTest.creatingDeploymentRecord(zeebeState, processId, version);
    }

    public static DeploymentRecord creatingDeploymentRecord(MutableZeebeState zeebeState, String processId, int version) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("test", task -> task.zeebeJobType("type")).endEvent().done();
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        String resourceName = "process.bpmn";
        DirectBuffer resource = BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance));
        DirectBuffer checksum = BufferUtil.wrapString((String)"checksum");
        ((DeploymentResource)deploymentRecord.resources().add()).setResourceName(BufferUtil.wrapString((String)"process.bpmn")).setResource(resource);
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        long key = keyGenerator.nextKey();
        ((ProcessMetadata)deploymentRecord.processesMetadata().add()).setBpmnProcessId(BufferUtil.wrapString((String)processId)).setVersion(version).setKey(key).setResourceName("process.bpmn").setChecksum(checksum);
        return deploymentRecord;
    }

    public static ProcessRecord creatingProcessRecord(MutableZeebeState zeebeState) {
        return ProcessStateTest.creatingProcessRecord(zeebeState, "processId");
    }

    public static ProcessRecord creatingProcessRecord(MutableZeebeState zeebeState, String processId) {
        MutableProcessState processState = zeebeState.getProcessState();
        int version = processState.getProcessVersion(processId) + 1;
        return ProcessStateTest.creatingProcessRecord(zeebeState, processId, version);
    }

    public static ProcessRecord creatingProcessRecord(MutableZeebeState zeebeState, String processId, int version) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("test", task -> task.zeebeJobType("type")).endEvent().done();
        ProcessRecord processRecord = new ProcessRecord();
        String resourceName = "process.bpmn";
        DirectBuffer resource = BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance));
        DirectBuffer checksum = BufferUtil.wrapString((String)"checksum");
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        long key = keyGenerator.nextKey();
        processRecord.setResourceName(BufferUtil.wrapString((String)"process.bpmn")).setResource(resource).setBpmnProcessId(BufferUtil.wrapString((String)processId)).setVersion(version).setKey(key).setResourceName("process.bpmn").setChecksum(checksum);
        return processRecord;
    }
}

