/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.engine.util.ZeebeStateRule;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.test.util.BufferAssert;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class JobStateTest {
    @Rule
    public final ZeebeStateRule stateRule = new ZeebeStateRule();
    private MutableJobState jobState;
    private MutableZeebeState zeebeState;

    @Before
    public void setUp() {
        this.zeebeState = this.stateRule.getZeebeState();
        this.jobState = this.zeebeState.getJobState();
    }

    @Test
    public void shouldCreateJobEntry() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.assertListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L);
    }

    @Test
    public void shouldActivateJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATED);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.assertListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shoulDisableJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.disable(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.FAILED);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldTimeoutJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.timeout(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.assertListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldDeleteJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.delete(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldNeverPersistJobVariables() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        BiConsumer[] biConsumerArray = new BiConsumer[5];
        biConsumerArray[0] = (arg_0, arg_1) -> ((MutableJobState)this.jobState).create(arg_0, arg_1);
        biConsumerArray[1] = (arg_0, arg_1) -> ((MutableJobState)this.jobState).activate(arg_0, arg_1);
        biConsumerArray[2] = (arg_0, arg_1) -> ((MutableJobState)this.jobState).timeout(arg_0, arg_1);
        biConsumerArray[3] = (arg_0, arg_1) -> ((MutableJobState)this.jobState).activate(arg_0, arg_1);
        biConsumerArray[4] = (arg_0, arg_1) -> ((MutableJobState)this.jobState).fail(arg_0, arg_1);
        List<BiConsumer> stateUpdates = Arrays.asList(biConsumerArray);
        for (BiConsumer stateUpdate : stateUpdates) {
            jobRecord.setVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar"));
            stateUpdate.accept(1L, jobRecord);
            DirectBuffer variables = this.jobState.getJob(1L).getVariablesBuffer();
            BufferAssert.assertThatBuffer((DirectBuffer)variables).isEqualTo((Object)DocumentValue.EMPTY_DOCUMENT);
        }
    }

    @Test
    public void shouldCompleteActivatableJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.complete(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldCancelActivatableJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.cancel(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldThrowErrorActivatableJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.throwError(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ERROR_THROWN);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldCompleteActivatedJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.complete(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldCancelActivatedJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.cancel(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldThrowErrorActivatedJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.throwError(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ERROR_THROWN);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldCompleteFailedJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord.setRetries(0));
        this.jobState.complete(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldCancelFailedJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord.setRetries(0));
        this.jobState.cancel(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isFalse();
        Assertions.assertThat((boolean)this.jobState.isInState(1L, JobState.State.NOT_FOUND)).isTrue();
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldFailJobWithRetriesLeft() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord().setRetries(1);
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.assertListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldFailJobWithRetriesAndBackOff() {
        long key = 1L;
        int retryBackoff = 100;
        JobRecord jobRecord = this.newJobRecord().setRetries(1).setRetryBackoff(100L);
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.FAILED);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.assertListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 100L);
    }

    @Test
    public void shouldRetryProperJobWithRetryBackoff() {
        long firstKey = 1L;
        long secondKey = 2L;
        JobRecord firstJobRecord = this.newJobRecord().setRetries(1).setRetryBackoff(0L);
        JobRecord secondJobRecord = this.newJobRecord().setRetries(1).setRetryBackoff(0L);
        this.jobState.create(1L, firstJobRecord);
        this.jobState.activate(1L, firstJobRecord);
        this.jobState.create(2L, secondJobRecord);
        this.jobState.activate(2L, secondJobRecord);
        this.jobState.fail(1L, firstJobRecord);
        this.jobState.fail(2L, secondJobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        Assertions.assertThat((boolean)this.jobState.exists(2L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.assertJobState(2L, JobState.State.ACTIVATABLE);
    }

    @Test
    public void shouldImmediatelyRetryJobAfterFailedIfRetryBackoffIsZeroAndHasRetries() {
        long jobKey = 1L;
        JobRecord jobRecord = this.newJobRecord().setRetries(1).setRetryBackoff(0L);
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime());
    }

    @Test
    public void shouldRetryJobAfterRecurredAndHasRetries() {
        long jobKey = 1L;
        long retryBackoff = Duration.ofDays(1L).toMillis();
        JobRecord jobRecord = this.newJobRecord().setRetries(1).setRetryBackoff(retryBackoff);
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.FAILED);
        this.assertListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + retryBackoff);
        this.jobState.recurAfterBackoff(1L, jobRecord);
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + retryBackoff);
    }

    @Test
    public void shouldFailJobWithNoRetriesLeft() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord().setRetries(0);
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.FAILED);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
    }

    @Test
    public void shouldResolveJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        this.jobState.activate(1L, jobRecord);
        this.jobState.fail(1L, jobRecord.setRetries(0));
        this.jobState.resolve(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.ACTIVATABLE);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.assertListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
        this.refuteListedAsBackOff(1L, jobRecord.getRecurringTime() + 1L + 1L);
    }

    @Test
    public void shouldListTimedOutEntriesInOrder() {
        this.createAndActivateJobRecord(1L, this.newJobRecord().setDeadline(1L));
        this.createAndActivateJobRecord(2L, this.newJobRecord().setDeadline(256L));
        this.jobState.create(5L, this.newJobRecord().setDeadline(512L));
        this.createAndActivateJobRecord(3L, this.newJobRecord().setDeadline(65536L));
        this.createAndActivateJobRecord(4L, this.newJobRecord().setDeadline(0x100000000L));
        List<Long> jobKeys = this.getTimedOutKeys(32768L);
        Assertions.assertThat(jobKeys).hasSize(2);
        Assertions.assertThat(jobKeys).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldOnlyIterateOverTimedoutWhileTrue() {
        this.createAndActivateJobRecord(1L, this.newJobRecord().setDeadline(1L));
        this.createAndActivateJobRecord(2L, this.newJobRecord().setDeadline(256L));
        this.createAndActivateJobRecord(3L, this.newJobRecord().setDeadline(512L));
        this.createAndActivateJobRecord(4L, this.newJobRecord().setDeadline(65536L));
        this.createAndActivateJobRecord(5L, this.newJobRecord().setDeadline(0x100000000L));
        ArrayList timedOutKeys = new ArrayList();
        long since = 65536L;
        this.jobState.forEachTimedOutEntry(65536L, (k, e) -> {
            timedOutKeys.add(k);
            return k < 3L;
        });
        Assertions.assertThat(timedOutKeys).hasSize(3);
        Assertions.assertThat(timedOutKeys).containsExactly((Object[])new Long[]{1L, 2L, 3L});
    }

    @Test
    public void shouldCleanUpOnForEachTimedOutAndVisitNext() {
        this.createAndActivateJobRecord(1L, this.newJobRecord().setDeadline(1L));
        this.jobState.cancel(1L, this.newJobRecord());
        this.createAndActivateJobRecord(2L, this.newJobRecord().setDeadline(256L));
        ArrayList timedOutKeys = new ArrayList();
        long since = 65536L;
        this.jobState.forEachTimedOutEntry(65536L, (k, e) -> {
            timedOutKeys.add(k);
            return true;
        });
        Assertions.assertThat(timedOutKeys).hasSize(1);
        Assertions.assertThat(timedOutKeys).containsExactly((Object[])new Long[]{2L});
    }

    @Test
    public void shouldDoNothingIfNotTimedOutJobs() {
        this.jobState.create(5L, this.newJobRecord().setDeadline(512L));
        this.createAndActivateJobRecord(4L, this.newJobRecord().setDeadline(0x100000000L));
        List<Long> jobKeys = this.getTimedOutKeys(32768L);
        Assertions.assertThat(jobKeys).isEmpty();
    }

    @Test
    public void shouldCheckExistenceCorrectly() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord();
        this.jobState.create(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        Assertions.assertThat((boolean)this.jobState.exists(2L)).isFalse();
    }

    @Test
    public void shouldListActivatableJobsForTypeInOrder() {
        DirectBuffer type = BufferUtil.wrapString((String)"test");
        this.jobState.create(1L, this.newJobRecord().setType("tes"));
        this.jobState.create(256L, this.newJobRecord().setType(type));
        this.createAndActivateJobRecord(512L, this.newJobRecord().setType(type));
        this.jobState.create(65536L, this.newJobRecord().setType(type));
        this.jobState.create(0x100000000L, this.newJobRecord().setType("test-other"));
        List<Long> jobKeys = this.getActivatableKeys(type);
        Assertions.assertThat(jobKeys).hasSize(2);
        Assertions.assertThat(jobKeys).containsExactly((Object[])new Long[]{256L, 65536L});
    }

    @Test
    public void shouldNotDoAnythingIfNoActivatableJobs() {
        DirectBuffer type = BufferUtil.wrapString((String)"test");
        this.createAndActivateJobRecord(1L, this.newJobRecord().setType(type));
        this.jobState.create(256L, this.newJobRecord().setType("other"));
        List<Long> jobKeys = this.getActivatableKeys(type);
        Assertions.assertThat(jobKeys).isEmpty();
    }

    @Test
    public void shouldReturnNullIfJobDoesNotExist() {
        long key = 1L;
        Assertions.assertThat((Object)this.jobState.getJob(1L)).isNull();
    }

    @Test
    public void shouldReturnCorrectJob() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord().setType("test");
        this.jobState.create(1L, jobRecord);
        this.jobState.create(2L, this.newJobRecord().setType("other"));
        JobRecord savedJob = this.jobState.getJob(1L);
        this.assertJobRecordIsEqualTo(savedJob, jobRecord);
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)savedJob.getTypeBuffer())).isEqualTo("test");
    }

    @Test
    public void testInvariants() {
        JobRecord jobWithoutType = this.newJobRecord().setType((DirectBuffer)new UnsafeBuffer(0L, 0));
        JobRecord jobWithoutDeadline = this.newJobRecord().setDeadline(0L);
        Assertions.assertThatThrownBy(() -> this.jobState.create(1L, jobWithoutType)).hasStackTraceContaining("type must not be empty");
        Assertions.assertThatThrownBy(() -> this.jobState.activate(1L, jobWithoutType)).hasMessage("type must not be empty");
        Assertions.assertThatThrownBy(() -> this.jobState.activate(1L, jobWithoutDeadline)).hasMessage("deadline must be greater than 0");
        Assertions.assertThatThrownBy(() -> this.jobState.fail(1L, jobWithoutType)).hasMessage("type must not be empty");
        Assertions.assertThatThrownBy(() -> this.jobState.resolve(1L, jobWithoutType)).hasStackTraceContaining("type must not be empty");
        Assertions.assertThatThrownBy(() -> this.jobState.timeout(1L, jobWithoutType)).hasMessage("type must not be empty");
        Assertions.assertThatThrownBy(() -> this.jobState.timeout(1L, jobWithoutDeadline)).hasMessage("deadline must be greater than 0");
        Assertions.assertThatThrownBy(() -> this.jobState.complete(1L, jobWithoutType)).hasStackTraceContaining("type must not be empty");
        this.jobState.create(1L, this.newJobRecord());
        Assertions.assertThatThrownBy(() -> this.jobState.cancel(1L, jobWithoutType)).hasStackTraceContaining("type must not be empty");
        Assertions.assertThatThrownBy(() -> this.jobState.throwError(1L, jobWithoutType)).hasStackTraceContaining("type must not be empty");
        this.jobState.create(1L, this.newJobRecord());
        this.jobState.activate(1L, this.newJobRecord());
        this.jobState.complete(1L, jobWithoutDeadline);
        this.jobState.create(1L, this.newJobRecord());
        this.jobState.cancel(1L, jobWithoutDeadline);
        this.jobState.create(1L, this.newJobRecord());
        this.jobState.throwError(1L, jobWithoutDeadline);
    }

    @Test
    public void shouldNotOverwritePreviousRecord() {
        long key = 1L;
        JobRecord writtenRecord = this.newJobRecord();
        this.jobState.create(1L, writtenRecord);
        writtenRecord.setType("foo");
        JobRecord readRecord = this.jobState.getJob(1L);
        Assertions.assertThat((Comparable)readRecord.getTypeBuffer()).isNotEqualTo((Object)writtenRecord.getTypeBuffer());
        Assertions.assertThat((Comparable)readRecord.getTypeBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Comparable)writtenRecord.getTypeBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"foo"));
    }

    @Test
    public void shouldMakeJobNotActivatableWhenFailedWithoutRetries() {
        long key = 1L;
        JobRecord jobRecord = this.newJobRecord().setRetries(0);
        this.jobState.create(1L, jobRecord);
        this.jobState.fail(1L, jobRecord);
        Assertions.assertThat((boolean)this.jobState.exists(1L)).isTrue();
        this.assertJobState(1L, JobState.State.FAILED);
        this.assertJobRecordIsEqualTo(this.jobState.getJob(1L), jobRecord);
        this.refuteListedAsActivatable(1L, jobRecord.getTypeBuffer());
        this.refuteListedAsTimedOut(1L, jobRecord.getDeadline() + 1L);
    }

    private void createAndActivateJobRecord(long key, JobRecord record) {
        this.jobState.create(key, record);
        this.jobState.activate(key, record);
    }

    private JobRecord newJobRecord() {
        JobRecord jobRecord = new JobRecord();
        jobRecord.setRetries(2);
        jobRecord.setDeadline(256L);
        jobRecord.setType("test");
        return jobRecord;
    }

    private void assertJobState(long key, JobState.State state) {
        List others = Arrays.stream(JobState.State.values()).filter(s -> s != state).collect(Collectors.toList());
        Assertions.assertThat((boolean)this.jobState.isInState(key, state)).isTrue();
        Assertions.assertThat(others).noneMatch(other -> this.jobState.isInState(key, other));
    }

    private void assertJobRecordIsEqualTo(JobRecord jobRecord, JobRecord expected) {
        Assertions.assertThat((long)jobRecord.getDeadline()).isEqualTo(expected.getDeadline());
        Assertions.assertThat((Comparable)jobRecord.getWorkerBuffer()).isEqualTo((Object)expected.getWorkerBuffer());
        Assertions.assertThat((int)jobRecord.getRetries()).isEqualTo(expected.getRetries());
        Assertions.assertThat((Comparable)jobRecord.getTypeBuffer()).isEqualTo((Object)expected.getTypeBuffer());
        Assertions.assertThat((Comparable)jobRecord.getCustomHeadersBuffer()).isEqualTo((Object)expected.getCustomHeadersBuffer());
        Assertions.assertThat((Comparable)jobRecord.getVariablesBuffer()).isEqualTo((Object)expected.getVariablesBuffer());
    }

    private void assertListedAsActivatable(long key, DirectBuffer type) {
        List<Long> activatableKeys = this.getActivatableKeys(type);
        Assertions.assertThat(activatableKeys).contains((Object[])new Long[]{key});
    }

    private void refuteListedAsActivatable(long key, DirectBuffer type) {
        List<Long> activatableKeys = this.getActivatableKeys(type);
        Assertions.assertThat(activatableKeys).doesNotContain((Object[])new Long[]{key});
    }

    private void assertListedAsTimedOut(long key, long since) {
        List<Long> timedOutKeys = this.getTimedOutKeys(since);
        Assertions.assertThat(timedOutKeys).contains((Object[])new Long[]{key});
    }

    private void refuteListedAsTimedOut(long key, long since) {
        List<Long> timedOutKeys = this.getTimedOutKeys(since);
        Assertions.assertThat(timedOutKeys).doesNotContain((Object[])new Long[]{key});
    }

    private void assertListedAsBackOff(long key, long since) {
        List<Long> backedOffKeys = this.getBackedOffKeys(since);
        Assertions.assertThat(backedOffKeys).contains((Object[])new Long[]{key});
    }

    private void refuteListedAsBackOff(long key, long since) {
        List<Long> backedOffKeys = this.getBackedOffKeys(since);
        Assertions.assertThat(backedOffKeys).doesNotContain((Object[])new Long[]{key});
    }

    private List<Long> getActivatableKeys(DirectBuffer type) {
        ArrayList<Long> activatableKeys = new ArrayList<Long>();
        this.jobState.forEachActivatableJobs(type, (k, e) -> activatableKeys.add((Long)k));
        return activatableKeys;
    }

    private List<Long> getTimedOutKeys(long since) {
        ArrayList<Long> timedOutKeys = new ArrayList<Long>();
        this.jobState.forEachTimedOutEntry(since, (k, e) -> timedOutKeys.add((Long)k));
        return timedOutKeys;
    }

    private List<Long> getBackedOffKeys(long since) {
        ArrayList<Long> backedOffKeys = new ArrayList<Long>();
        this.jobState.findBackedOffJobs(since, (k, record) -> backedOffKeys.add((Long)k));
        return backedOffKeys;
    }
}

